/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api;

import com.google.protobuf.ByteString;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.Edge;
import org.apache.tez.dag.api.EdgeManagerPluginDescriptor;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.records.DAGProtos;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestDAGPlan {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testBasicJobPlanSerde() throws IOException {
        DAGProtos.DAGPlan inJob;
        DAGProtos.DAGPlan job = DAGProtos.DAGPlan.newBuilder().setName("test").addVertex(DAGProtos.VertexPlan.newBuilder().setName("vertex1").setType(DAGProtos.PlanVertexType.NORMAL).addTaskLocationHint(DAGProtos.PlanTaskLocationHint.newBuilder().addHost("machineName").addRack("rack1").build()).setTaskConfig(DAGProtos.PlanTaskConfiguration.newBuilder().setNumTasks(2).setVirtualCores(4).setMemoryMb(1024).setJavaOpts("").setTaskModule("x.y").build()).build()).build();
        File file = this.tempFolder.newFile("jobPlan");
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(file);
            job.writeTo((OutputStream)outStream);
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
        }
        try {
            FileInputStream inputStream = new FileInputStream(file);
            inJob = ((DAGProtos.DAGPlan.Builder)DAGProtos.DAGPlan.newBuilder().mergeFrom((InputStream)inputStream)).build();
        }
        finally {
            outStream.close();
        }
        Assert.assertEquals((Object)job, (Object)inJob);
    }

    @Test(timeout=5000L)
    public void testEdgeManagerSerde() {
        DAG dag = DAG.create((String)"testDag");
        ProcessorDescriptor pd1 = (ProcessorDescriptor)ProcessorDescriptor.create((String)"processor1").setUserPayload(UserPayload.create((ByteBuffer)ByteBuffer.wrap("processor1Bytes".getBytes())));
        ProcessorDescriptor pd2 = (ProcessorDescriptor)ProcessorDescriptor.create((String)"processor2").setUserPayload(UserPayload.create((ByteBuffer)ByteBuffer.wrap("processor2Bytes".getBytes())));
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)pd1, (int)10, (Resource)Resource.newInstance((int)1024, (int)1));
        Vertex v2 = Vertex.create((String)"v2", (ProcessorDescriptor)pd2, (int)1, (Resource)Resource.newInstance((int)1024, (int)1));
        v1.setTaskLaunchCmdOpts("").setTaskEnvironment(new HashMap()).addTaskLocalFiles(new HashMap());
        v2.setTaskLaunchCmdOpts("").setTaskEnvironment(new HashMap()).addTaskLocalFiles(new HashMap());
        InputDescriptor inputDescriptor = (InputDescriptor)InputDescriptor.create((String)"input").setUserPayload(UserPayload.create((ByteBuffer)ByteBuffer.wrap("inputBytes".getBytes())));
        OutputDescriptor outputDescriptor = (OutputDescriptor)OutputDescriptor.create((String)"output").setUserPayload(UserPayload.create((ByteBuffer)ByteBuffer.wrap("outputBytes".getBytes())));
        Edge edge = Edge.create((Vertex)v1, (Vertex)v2, (EdgeProperty)EdgeProperty.create((EdgeManagerPluginDescriptor)((EdgeManagerPluginDescriptor)EdgeManagerPluginDescriptor.create((String)"emClass").setUserPayload(UserPayload.create((ByteBuffer)ByteBuffer.wrap("emPayload".getBytes())))), (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)outputDescriptor, (InputDescriptor)inputDescriptor));
        dag.addVertex(v1).addVertex(v2).addEdge(edge);
        DAGProtos.DAGPlan dagProto = dag.createDag((Configuration)new TezConfiguration(), null, null, null, true);
        EdgeProperty edgeProperty = DagTypeConverters.createEdgePropertyMapFromDAGPlan((DAGProtos.EdgePlan)((DAGProtos.EdgePlan)dagProto.getEdgeList().get(0)));
        EdgeManagerPluginDescriptor emDesc = edgeProperty.getEdgeManagerDescriptor();
        Assert.assertNotNull((Object)emDesc);
        Assert.assertEquals((Object)"emClass", (Object)emDesc.getClassName());
        Assert.assertTrue((boolean)Arrays.equals("emPayload".getBytes(), emDesc.getUserPayload().deepCopyAsArray()));
    }

    @Test(timeout=5000L)
    public void testUserPayloadSerde() {
        DAG dag = DAG.create((String)"testDag");
        ProcessorDescriptor pd1 = (ProcessorDescriptor)ProcessorDescriptor.create((String)"processor1").setUserPayload(UserPayload.create((ByteBuffer)ByteBuffer.wrap("processor1Bytes".getBytes())));
        ProcessorDescriptor pd2 = (ProcessorDescriptor)ProcessorDescriptor.create((String)"processor2").setUserPayload(UserPayload.create((ByteBuffer)ByteBuffer.wrap("processor2Bytes".getBytes())));
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)pd1, (int)10, (Resource)Resource.newInstance((int)1024, (int)1));
        Vertex v2 = Vertex.create((String)"v2", (ProcessorDescriptor)pd2, (int)1, (Resource)Resource.newInstance((int)1024, (int)1));
        v1.setTaskLaunchCmdOpts("").setTaskEnvironment(new HashMap()).addTaskLocalFiles(new HashMap());
        v2.setTaskLaunchCmdOpts("").setTaskEnvironment(new HashMap()).addTaskLocalFiles(new HashMap());
        InputDescriptor inputDescriptor = (InputDescriptor)InputDescriptor.create((String)"input").setUserPayload(UserPayload.create((ByteBuffer)ByteBuffer.wrap("inputBytes".getBytes())));
        OutputDescriptor outputDescriptor = (OutputDescriptor)OutputDescriptor.create((String)"output").setUserPayload(UserPayload.create((ByteBuffer)ByteBuffer.wrap("outputBytes".getBytes())));
        Edge edge = Edge.create((Vertex)v1, (Vertex)v2, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)outputDescriptor, (InputDescriptor)inputDescriptor));
        dag.addVertex(v1).addVertex(v2).addEdge(edge);
        DAGProtos.DAGPlan dagProto = dag.createDag((Configuration)new TezConfiguration(), null, null, null, true);
        Assert.assertEquals((long)2L, (long)dagProto.getVertexCount());
        Assert.assertEquals((long)1L, (long)dagProto.getEdgeCount());
        DAGProtos.VertexPlan v1Proto = dagProto.getVertex(0);
        DAGProtos.VertexPlan v2Proto = dagProto.getVertex(1);
        DAGProtos.EdgePlan edgeProto = dagProto.getEdge(0);
        Assert.assertEquals((Object)"processor1Bytes", (Object)new String(v1Proto.getProcessorDescriptor().getTezUserPayload().getUserPayload().toByteArray()));
        Assert.assertEquals((Object)"processor1", (Object)v1Proto.getProcessorDescriptor().getClassName());
        Assert.assertEquals((Object)"processor2Bytes", (Object)new String(v2Proto.getProcessorDescriptor().getTezUserPayload().getUserPayload().toByteArray()));
        Assert.assertEquals((Object)"processor2", (Object)v2Proto.getProcessorDescriptor().getClassName());
        Assert.assertEquals((Object)"inputBytes", (Object)new String(edgeProto.getEdgeDestination().getTezUserPayload().getUserPayload().toByteArray()));
        Assert.assertEquals((Object)"input", (Object)edgeProto.getEdgeDestination().getClassName());
        Assert.assertEquals((Object)"outputBytes", (Object)new String(edgeProto.getEdgeSource().getTezUserPayload().getUserPayload().toByteArray()));
        Assert.assertEquals((Object)"output", (Object)edgeProto.getEdgeSource().getClassName());
        EdgeProperty edgeProperty = DagTypeConverters.createEdgePropertyMapFromDAGPlan((DAGProtos.EdgePlan)((DAGProtos.EdgePlan)dagProto.getEdgeList().get(0)));
        byte[] ib = edgeProperty.getEdgeDestination().getUserPayload().deepCopyAsArray();
        Assert.assertEquals((Object)"inputBytes", (Object)new String(ib));
        Assert.assertEquals((Object)"input", (Object)edgeProperty.getEdgeDestination().getClassName());
        byte[] ob = edgeProperty.getEdgeSource().getUserPayload().deepCopyAsArray();
        Assert.assertEquals((Object)"outputBytes", (Object)new String(ob));
        Assert.assertEquals((Object)"output", (Object)edgeProperty.getEdgeSource().getClassName());
    }

    @Test(timeout=5000L)
    public void userVertexOrderingIsMaintained() {
        DAG dag = DAG.create((String)"testDag");
        ProcessorDescriptor pd1 = (ProcessorDescriptor)ProcessorDescriptor.create((String)"processor1").setUserPayload(UserPayload.create((ByteBuffer)ByteBuffer.wrap("processor1Bytes".getBytes())));
        ProcessorDescriptor pd2 = (ProcessorDescriptor)ProcessorDescriptor.create((String)"processor2").setUserPayload(UserPayload.create((ByteBuffer)ByteBuffer.wrap("processor2Bytes".getBytes())));
        ProcessorDescriptor pd3 = (ProcessorDescriptor)ProcessorDescriptor.create((String)"processor3").setUserPayload(UserPayload.create((ByteBuffer)ByteBuffer.wrap("processor3Bytes".getBytes())));
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)pd1, (int)10, (Resource)Resource.newInstance((int)1024, (int)1));
        Vertex v2 = Vertex.create((String)"v2", (ProcessorDescriptor)pd2, (int)1, (Resource)Resource.newInstance((int)1024, (int)1));
        Vertex v3 = Vertex.create((String)"v3", (ProcessorDescriptor)pd3, (int)1, (Resource)Resource.newInstance((int)1024, (int)1));
        v1.setTaskLaunchCmdOpts("").setTaskEnvironment(new HashMap()).addTaskLocalFiles(new HashMap());
        v2.setTaskLaunchCmdOpts("").setTaskEnvironment(new HashMap()).addTaskLocalFiles(new HashMap());
        v3.setTaskLaunchCmdOpts("").setTaskEnvironment(new HashMap()).addTaskLocalFiles(new HashMap());
        InputDescriptor inputDescriptor = (InputDescriptor)InputDescriptor.create((String)"input").setUserPayload(UserPayload.create((ByteBuffer)ByteBuffer.wrap("inputBytes".getBytes())));
        OutputDescriptor outputDescriptor = (OutputDescriptor)OutputDescriptor.create((String)"output").setUserPayload(UserPayload.create((ByteBuffer)ByteBuffer.wrap("outputBytes".getBytes())));
        Edge edge = Edge.create((Vertex)v1, (Vertex)v2, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)outputDescriptor, (InputDescriptor)inputDescriptor));
        dag.addVertex(v1).addVertex(v2).addEdge(edge).addVertex(v3);
        DAGProtos.DAGPlan dagProto = dag.createDag((Configuration)new TezConfiguration(), null, null, null, true);
        Assert.assertEquals((long)3L, (long)dagProto.getVertexCount());
        Assert.assertEquals((long)1L, (long)dagProto.getEdgeCount());
        DAGProtos.VertexPlan v1Proto = dagProto.getVertex(0);
        DAGProtos.VertexPlan v2Proto = dagProto.getVertex(1);
        DAGProtos.VertexPlan v3Proto = dagProto.getVertex(2);
        DAGProtos.EdgePlan edgeProto = dagProto.getEdge(0);
        String v1ProtoPayload = new String(v1Proto.getProcessorDescriptor().getTezUserPayload().getUserPayload().toByteArray());
        String v2ProtoPayload = new String(v2Proto.getProcessorDescriptor().getTezUserPayload().getUserPayload().toByteArray());
        Assert.assertTrue((v1ProtoPayload.equals("processor1Bytes") || v1ProtoPayload.equals("processor3Bytes") ? 1 : 0) != 0);
        Assert.assertTrue((v2ProtoPayload.equals("processor1Bytes") || v2ProtoPayload.equals("processor3Bytes") ? 1 : 0) != 0);
        Assert.assertTrue((v1Proto.getProcessorDescriptor().getClassName().equals("processor1") || v1Proto.getProcessorDescriptor().getClassName().equals("processor3") ? 1 : 0) != 0);
        Assert.assertTrue((v2Proto.getProcessorDescriptor().getClassName().equals("processor1") || v2Proto.getProcessorDescriptor().getClassName().equals("processor3") ? 1 : 0) != 0);
        Assert.assertEquals((Object)"processor2Bytes", (Object)new String(v3Proto.getProcessorDescriptor().getTezUserPayload().getUserPayload().toByteArray()));
        Assert.assertEquals((Object)"processor2", (Object)v3Proto.getProcessorDescriptor().getClassName());
        Assert.assertEquals((Object)"inputBytes", (Object)new String(edgeProto.getEdgeDestination().getTezUserPayload().getUserPayload().toByteArray()));
        Assert.assertEquals((Object)"input", (Object)edgeProto.getEdgeDestination().getClassName());
        Assert.assertEquals((Object)"outputBytes", (Object)new String(edgeProto.getEdgeSource().getTezUserPayload().getUserPayload().toByteArray()));
        Assert.assertEquals((Object)"output", (Object)edgeProto.getEdgeSource().getClassName());
        EdgeProperty edgeProperty = DagTypeConverters.createEdgePropertyMapFromDAGPlan((DAGProtos.EdgePlan)((DAGProtos.EdgePlan)dagProto.getEdgeList().get(0)));
        byte[] ib = edgeProperty.getEdgeDestination().getUserPayload().deepCopyAsArray();
        Assert.assertEquals((Object)"inputBytes", (Object)new String(ib));
        Assert.assertEquals((Object)"input", (Object)edgeProperty.getEdgeDestination().getClassName());
        byte[] ob = edgeProperty.getEdgeSource().getUserPayload().deepCopyAsArray();
        Assert.assertEquals((Object)"outputBytes", (Object)new String(ob));
        Assert.assertEquals((Object)"output", (Object)edgeProperty.getEdgeSource().getClassName());
    }

    @Test(timeout=5000L)
    public void testCredentialsSerde() {
        DAG dag = DAG.create((String)"testDag");
        ProcessorDescriptor pd1 = (ProcessorDescriptor)ProcessorDescriptor.create((String)"processor1").setUserPayload(UserPayload.create((ByteBuffer)ByteBuffer.wrap("processor1Bytes".getBytes())));
        ProcessorDescriptor pd2 = (ProcessorDescriptor)ProcessorDescriptor.create((String)"processor2").setUserPayload(UserPayload.create((ByteBuffer)ByteBuffer.wrap("processor2Bytes".getBytes())));
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)pd1, (int)10, (Resource)Resource.newInstance((int)1024, (int)1));
        Vertex v2 = Vertex.create((String)"v2", (ProcessorDescriptor)pd2, (int)1, (Resource)Resource.newInstance((int)1024, (int)1));
        v1.setTaskLaunchCmdOpts("").setTaskEnvironment(new HashMap()).addTaskLocalFiles(new HashMap());
        v2.setTaskLaunchCmdOpts("").setTaskEnvironment(new HashMap()).addTaskLocalFiles(new HashMap());
        InputDescriptor inputDescriptor = (InputDescriptor)InputDescriptor.create((String)"input").setUserPayload(UserPayload.create((ByteBuffer)ByteBuffer.wrap("inputBytes".getBytes())));
        OutputDescriptor outputDescriptor = (OutputDescriptor)OutputDescriptor.create((String)"output").setUserPayload(UserPayload.create((ByteBuffer)ByteBuffer.wrap("outputBytes".getBytes())));
        Edge edge = Edge.create((Vertex)v1, (Vertex)v2, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)outputDescriptor, (InputDescriptor)inputDescriptor));
        dag.addVertex(v1).addVertex(v2).addEdge(edge);
        Credentials dagCredentials = new Credentials();
        Token token1 = new Token();
        Token token2 = new Token();
        dagCredentials.addToken(new Text("Token1"), token1);
        dagCredentials.addToken(new Text("Token2"), token2);
        dag.setCredentials(dagCredentials);
        DAGProtos.DAGPlan dagProto = dag.createDag((Configuration)new TezConfiguration(), null, null, null, true);
        Assert.assertTrue((boolean)dagProto.hasCredentialsBinary());
        Credentials fetchedCredentials = DagTypeConverters.convertByteStringToCredentials((ByteString)dagProto.getCredentialsBinary());
        Assert.assertEquals((long)2L, (long)fetchedCredentials.numberOfTokens());
        Assert.assertNotNull((Object)fetchedCredentials.getToken(new Text("Token1")));
        Assert.assertNotNull((Object)fetchedCredentials.getToken(new Text("Token2")));
    }
}

