/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common.security;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.tez.common.security.ACLManager;
import org.apache.tez.common.security.ACLType;
import org.junit.Assert;
import org.junit.Test;

public class TestACLManager {
    private static final String[] noGroups = new String[0];

    @Test
    public void testCurrentUserACLChecks() {
        UserGroupInformation currentUser = UserGroupInformation.createUserForTesting((String)"currentUser", (String[])noGroups);
        UserGroupInformation dagUser = UserGroupInformation.createUserForTesting((String)"dagUser", (String[])noGroups);
        UserGroupInformation user1 = UserGroupInformation.createUserForTesting((String)"user1", (String[])noGroups);
        ACLManager aclManager = new ACLManager(currentUser.getShortUserName());
        UserGroupInformation user = user1;
        Assert.assertFalse((boolean)aclManager.checkAccess(user, ACLType.AM_VIEW_ACL));
        Assert.assertFalse((boolean)aclManager.checkAccess(user, ACLType.AM_MODIFY_ACL));
        user = currentUser;
        Assert.assertTrue((boolean)aclManager.checkAccess(user, ACLType.AM_VIEW_ACL));
        Assert.assertTrue((boolean)aclManager.checkAccess(user, ACLType.AM_MODIFY_ACL));
        aclManager = new ACLManager(currentUser.getShortUserName(), new Configuration(false));
        user = user1;
        Assert.assertFalse((boolean)aclManager.checkAccess(user, ACLType.AM_VIEW_ACL));
        Assert.assertFalse((boolean)aclManager.checkAccess(user, ACLType.AM_MODIFY_ACL));
        user = currentUser;
        Assert.assertTrue((boolean)aclManager.checkAccess(user, ACLType.AM_VIEW_ACL));
        Assert.assertTrue((boolean)aclManager.checkAccess(user, ACLType.AM_MODIFY_ACL));
        ACLManager dagAclManager = new ACLManager(aclManager, dagUser.getShortUserName(), new Configuration(false));
        user = dagUser;
        Assert.assertFalse((boolean)dagAclManager.checkAccess(user, ACLType.AM_VIEW_ACL));
        Assert.assertFalse((boolean)dagAclManager.checkAccess(user, ACLType.AM_MODIFY_ACL));
        Assert.assertTrue((boolean)dagAclManager.checkAccess(user, ACLType.DAG_VIEW_ACL));
        Assert.assertTrue((boolean)dagAclManager.checkAccess(user, ACLType.DAG_MODIFY_ACL));
        user = user1;
        Assert.assertFalse((boolean)dagAclManager.checkAccess(user, ACLType.DAG_VIEW_ACL));
        Assert.assertFalse((boolean)dagAclManager.checkAccess(user, ACLType.DAG_MODIFY_ACL));
    }

    @Test
    public void testOtherUserACLChecks() throws IOException {
        String[] groups1 = new String[]{"grp1", "grp2"};
        String[] groups2 = new String[]{"grp3", "grp4"};
        String[] groups3 = new String[]{"grp5", "grp6"};
        UserGroupInformation currentUser = UserGroupInformation.createUserForTesting((String)"currentUser", (String[])noGroups);
        UserGroupInformation user1 = UserGroupInformation.createUserForTesting((String)"user1", (String[])groups1);
        UserGroupInformation user2 = UserGroupInformation.createUserForTesting((String)"user2", (String[])groups2);
        UserGroupInformation user3 = UserGroupInformation.createUserForTesting((String)"user3", (String[])noGroups);
        UserGroupInformation user4 = UserGroupInformation.createUserForTesting((String)"user4", (String[])noGroups);
        UserGroupInformation user5 = UserGroupInformation.createUserForTesting((String)"user5", (String[])groups3);
        UserGroupInformation user6 = UserGroupInformation.createUserForTesting((String)"user6", (String[])noGroups);
        Configuration conf = new Configuration(false);
        String viewACLs = user1.getShortUserName() + "," + user4.getShortUserName() + "   " + "grp3,grp4  ";
        String modifyACLs = user3.getShortUserName() + "  " + "grp6,grp7";
        conf.set("tez.am.view-acls", viewACLs);
        conf.set("tez.am.modify-acls", modifyACLs);
        ACLManager aclManager = new ACLManager(currentUser.getShortUserName(), conf);
        Assert.assertTrue((boolean)aclManager.checkAccess(currentUser, ACLType.AM_VIEW_ACL));
        Assert.assertTrue((boolean)aclManager.checkAccess(user1, ACLType.AM_VIEW_ACL));
        Assert.assertTrue((boolean)aclManager.checkAccess(user2, ACLType.AM_VIEW_ACL));
        Assert.assertFalse((boolean)aclManager.checkAccess(user3, ACLType.AM_VIEW_ACL));
        Assert.assertTrue((boolean)aclManager.checkAccess(user4, ACLType.AM_VIEW_ACL));
        Assert.assertFalse((boolean)aclManager.checkAccess(user5, ACLType.AM_VIEW_ACL));
        Assert.assertFalse((boolean)aclManager.checkAccess(user6, ACLType.AM_VIEW_ACL));
        Assert.assertTrue((boolean)aclManager.checkAccess(currentUser, ACLType.AM_MODIFY_ACL));
        Assert.assertFalse((boolean)aclManager.checkAccess(user1, ACLType.AM_MODIFY_ACL));
        Assert.assertFalse((boolean)aclManager.checkAccess(user2, ACLType.AM_MODIFY_ACL));
        Assert.assertTrue((boolean)aclManager.checkAccess(user3, ACLType.AM_MODIFY_ACL));
        Assert.assertFalse((boolean)aclManager.checkAccess(user4, ACLType.AM_MODIFY_ACL));
        Assert.assertTrue((boolean)aclManager.checkAccess(user5, ACLType.AM_MODIFY_ACL));
        Assert.assertFalse((boolean)aclManager.checkAccess(user6, ACLType.AM_MODIFY_ACL));
    }

    @Test
    public void testNoGroupsACLChecks() throws IOException {
        String[] groups1 = new String[]{"grp1", "grp2"};
        String[] groups2 = new String[]{"grp3", "grp4"};
        String[] groups3 = new String[]{"grp5", "grp6"};
        UserGroupInformation currentUser = UserGroupInformation.createUserForTesting((String)"currentUser", (String[])noGroups);
        UserGroupInformation user1 = UserGroupInformation.createUserForTesting((String)"user1", (String[])groups1);
        UserGroupInformation user2 = UserGroupInformation.createUserForTesting((String)"user2", (String[])groups2);
        UserGroupInformation user3 = UserGroupInformation.createUserForTesting((String)"user3", (String[])noGroups);
        UserGroupInformation user4 = UserGroupInformation.createUserForTesting((String)"user4", (String[])noGroups);
        UserGroupInformation user5 = UserGroupInformation.createUserForTesting((String)"user5", (String[])groups3);
        UserGroupInformation user6 = UserGroupInformation.createUserForTesting((String)"user6", (String[])noGroups);
        Configuration conf = new Configuration(false);
        String viewACLs = user1.getShortUserName() + "," + user4.getShortUserName() + " ";
        String modifyACLs = user3.getShortUserName() + " ";
        conf.set("tez.am.view-acls", viewACLs);
        conf.set("tez.am.modify-acls", modifyACLs);
        ACLManager aclManager = new ACLManager(currentUser.getShortUserName(), conf);
        Assert.assertTrue((boolean)aclManager.checkAccess(currentUser, ACLType.AM_VIEW_ACL));
        Assert.assertTrue((boolean)aclManager.checkAccess(user1, ACLType.AM_VIEW_ACL));
        Assert.assertFalse((boolean)aclManager.checkAccess(user2, ACLType.AM_VIEW_ACL));
        Assert.assertFalse((boolean)aclManager.checkAccess(user3, ACLType.AM_VIEW_ACL));
        Assert.assertTrue((boolean)aclManager.checkAccess(user4, ACLType.AM_VIEW_ACL));
        Assert.assertFalse((boolean)aclManager.checkAccess(user5, ACLType.AM_VIEW_ACL));
        Assert.assertFalse((boolean)aclManager.checkAccess(user6, ACLType.AM_VIEW_ACL));
        Assert.assertTrue((boolean)aclManager.checkAccess(currentUser, ACLType.AM_MODIFY_ACL));
        Assert.assertFalse((boolean)aclManager.checkAccess(user1, ACLType.AM_MODIFY_ACL));
        Assert.assertFalse((boolean)aclManager.checkAccess(user2, ACLType.AM_MODIFY_ACL));
        Assert.assertTrue((boolean)aclManager.checkAccess(user3, ACLType.AM_MODIFY_ACL));
        Assert.assertFalse((boolean)aclManager.checkAccess(user4, ACLType.AM_MODIFY_ACL));
        Assert.assertFalse((boolean)aclManager.checkAccess(user5, ACLType.AM_MODIFY_ACL));
        Assert.assertFalse((boolean)aclManager.checkAccess(user6, ACLType.AM_MODIFY_ACL));
    }

    @Test
    public void checkAMACLs() throws IOException {
        String[] groups1 = new String[]{"grp1", "grp2"};
        String[] groups2 = new String[]{"grp3", "grp4"};
        String[] groups3 = new String[]{"grp5", "grp6"};
        UserGroupInformation currentUser = UserGroupInformation.createUserForTesting((String)"currentUser", (String[])noGroups);
        UserGroupInformation user1 = UserGroupInformation.createUserForTesting((String)"user1", (String[])groups1);
        UserGroupInformation user2 = UserGroupInformation.createUserForTesting((String)"user2", (String[])groups2);
        UserGroupInformation user3 = UserGroupInformation.createUserForTesting((String)"user3", (String[])noGroups);
        UserGroupInformation user4 = UserGroupInformation.createUserForTesting((String)"user4", (String[])noGroups);
        UserGroupInformation user5 = UserGroupInformation.createUserForTesting((String)"user5", (String[])groups3);
        UserGroupInformation user6 = UserGroupInformation.createUserForTesting((String)"user6", (String[])noGroups);
        Configuration conf = new Configuration(false);
        String viewACLs = "user1,user4,,   grp3,grp4  ";
        String modifyACLs = "user3   grp6,grp7";
        conf.set("tez.am.view-acls", viewACLs);
        conf.set("tez.am.modify-acls", modifyACLs);
        ACLManager aclManager = new ACLManager(currentUser.getShortUserName(), conf);
        Assert.assertTrue((boolean)aclManager.checkAMViewAccess(currentUser));
        Assert.assertTrue((boolean)aclManager.checkAMViewAccess(user1));
        Assert.assertTrue((boolean)aclManager.checkAMViewAccess(user2));
        Assert.assertFalse((boolean)aclManager.checkAMViewAccess(user3));
        Assert.assertTrue((boolean)aclManager.checkAMViewAccess(user4));
        Assert.assertFalse((boolean)aclManager.checkAMViewAccess(user5));
        Assert.assertFalse((boolean)aclManager.checkAMViewAccess(user6));
        Assert.assertTrue((boolean)aclManager.checkAMModifyAccess(currentUser));
        Assert.assertFalse((boolean)aclManager.checkAMModifyAccess(user1));
        Assert.assertFalse((boolean)aclManager.checkAMModifyAccess(user2));
        Assert.assertTrue((boolean)aclManager.checkAMModifyAccess(user3));
        Assert.assertFalse((boolean)aclManager.checkAMModifyAccess(user4));
        Assert.assertTrue((boolean)aclManager.checkAMModifyAccess(user5));
        Assert.assertFalse((boolean)aclManager.checkAMModifyAccess(user6));
        Assert.assertTrue((boolean)aclManager.checkDAGViewAccess(currentUser));
        Assert.assertTrue((boolean)aclManager.checkDAGViewAccess(user1));
        Assert.assertTrue((boolean)aclManager.checkDAGViewAccess(user2));
        Assert.assertFalse((boolean)aclManager.checkDAGViewAccess(user3));
        Assert.assertTrue((boolean)aclManager.checkDAGViewAccess(user4));
        Assert.assertFalse((boolean)aclManager.checkDAGViewAccess(user5));
        Assert.assertFalse((boolean)aclManager.checkDAGViewAccess(user6));
        Assert.assertTrue((boolean)aclManager.checkDAGModifyAccess(currentUser));
        Assert.assertFalse((boolean)aclManager.checkDAGModifyAccess(user1));
        Assert.assertFalse((boolean)aclManager.checkDAGModifyAccess(user2));
        Assert.assertTrue((boolean)aclManager.checkDAGModifyAccess(user3));
        Assert.assertFalse((boolean)aclManager.checkDAGModifyAccess(user4));
        Assert.assertTrue((boolean)aclManager.checkDAGModifyAccess(user5));
        Assert.assertFalse((boolean)aclManager.checkDAGModifyAccess(user6));
    }

    @Test
    public void checkDAGACLs() throws IOException {
        String[] groups1 = new String[]{"grp1", "grp2"};
        String[] groups2 = new String[]{"grp3", "grp4"};
        String[] groups3 = new String[]{"grp5", "grp6"};
        UserGroupInformation currentUser = UserGroupInformation.createUserForTesting((String)"currentUser", (String[])noGroups);
        UserGroupInformation user1 = UserGroupInformation.createUserForTesting((String)"user1", (String[])groups1);
        UserGroupInformation user2 = UserGroupInformation.createUserForTesting((String)"user2", (String[])groups2);
        UserGroupInformation user3 = UserGroupInformation.createUserForTesting((String)"user3", (String[])noGroups);
        UserGroupInformation user4 = UserGroupInformation.createUserForTesting((String)"user4", (String[])noGroups);
        UserGroupInformation user5 = UserGroupInformation.createUserForTesting((String)"user5", (String[])groups3);
        UserGroupInformation user6 = UserGroupInformation.createUserForTesting((String)"user6", (String[])noGroups);
        Configuration conf = new Configuration(false);
        String viewACLs = "user1,user4,,   grp3,grp4  ";
        String modifyACLs = "user3   grp6,grp7";
        conf.set("tez.am.view-acls", viewACLs);
        conf.set("tez.am.modify-acls", modifyACLs);
        String dagViewACLs = "user6,   grp5  ";
        String dagModifyACLs = "user6,user5 ";
        conf.set("tez.am.dag.view-acls", dagViewACLs);
        conf.set("tez.am.dag.modify-acls", dagModifyACLs);
        UserGroupInformation dagUser = UserGroupInformation.createUserForTesting((String)"dagUser", (String[])noGroups);
        ACLManager amAclManager = new ACLManager(currentUser.getShortUserName(), conf);
        ACLManager aclManager = new ACLManager(amAclManager, dagUser.getShortUserName(), conf);
        Assert.assertTrue((boolean)aclManager.checkAMViewAccess(currentUser));
        Assert.assertFalse((boolean)aclManager.checkAMViewAccess(dagUser));
        Assert.assertTrue((boolean)aclManager.checkAMViewAccess(user1));
        Assert.assertTrue((boolean)aclManager.checkAMViewAccess(user2));
        Assert.assertFalse((boolean)aclManager.checkAMViewAccess(user3));
        Assert.assertTrue((boolean)aclManager.checkAMViewAccess(user4));
        Assert.assertFalse((boolean)aclManager.checkAMViewAccess(user5));
        Assert.assertFalse((boolean)aclManager.checkAMViewAccess(user6));
        Assert.assertTrue((boolean)aclManager.checkAMModifyAccess(currentUser));
        Assert.assertFalse((boolean)aclManager.checkAMModifyAccess(dagUser));
        Assert.assertFalse((boolean)aclManager.checkAMModifyAccess(user1));
        Assert.assertFalse((boolean)aclManager.checkAMModifyAccess(user2));
        Assert.assertTrue((boolean)aclManager.checkAMModifyAccess(user3));
        Assert.assertFalse((boolean)aclManager.checkAMModifyAccess(user4));
        Assert.assertTrue((boolean)aclManager.checkAMModifyAccess(user5));
        Assert.assertFalse((boolean)aclManager.checkAMModifyAccess(user6));
        Assert.assertTrue((boolean)aclManager.checkDAGViewAccess(currentUser));
        Assert.assertTrue((boolean)aclManager.checkDAGViewAccess(dagUser));
        Assert.assertTrue((boolean)aclManager.checkDAGViewAccess(user1));
        Assert.assertTrue((boolean)aclManager.checkDAGViewAccess(user2));
        Assert.assertFalse((boolean)aclManager.checkDAGViewAccess(user3));
        Assert.assertTrue((boolean)aclManager.checkDAGViewAccess(user4));
        Assert.assertTrue((boolean)aclManager.checkDAGViewAccess(user5));
        Assert.assertTrue((boolean)aclManager.checkDAGViewAccess(user6));
        Assert.assertTrue((boolean)aclManager.checkDAGModifyAccess(currentUser));
        Assert.assertTrue((boolean)aclManager.checkDAGModifyAccess(dagUser));
        Assert.assertFalse((boolean)aclManager.checkDAGModifyAccess(user1));
        Assert.assertFalse((boolean)aclManager.checkDAGModifyAccess(user2));
        Assert.assertTrue((boolean)aclManager.checkDAGModifyAccess(user3));
        Assert.assertFalse((boolean)aclManager.checkDAGModifyAccess(user4));
        Assert.assertTrue((boolean)aclManager.checkDAGModifyAccess(user5));
        Assert.assertTrue((boolean)aclManager.checkDAGModifyAccess(user6));
    }

    @Test
    public void testWildCardCheck() {
        Configuration conf = new Configuration(false);
        String viewACLs = "   *  ";
        String modifyACLs = "   * ";
        conf.set("tez.am.view-acls", viewACLs);
        conf.set("tez.am.modify-acls", modifyACLs);
        UserGroupInformation a1 = UserGroupInformation.createUserForTesting((String)"a1", (String[])noGroups);
        UserGroupInformation u1 = UserGroupInformation.createUserForTesting((String)"u1", (String[])noGroups);
        ACLManager aclManager = new ACLManager(a1.getShortUserName(), conf);
        Assert.assertTrue((boolean)aclManager.checkAMViewAccess(a1));
        Assert.assertTrue((boolean)aclManager.checkAMViewAccess(u1));
        Assert.assertTrue((boolean)aclManager.checkAMModifyAccess(a1));
        Assert.assertTrue((boolean)aclManager.checkAMModifyAccess(u1));
        Assert.assertTrue((boolean)aclManager.checkDAGViewAccess(a1));
        Assert.assertTrue((boolean)aclManager.checkDAGViewAccess(u1));
        Assert.assertTrue((boolean)aclManager.checkDAGModifyAccess(a1));
        Assert.assertTrue((boolean)aclManager.checkDAGModifyAccess(u1));
    }

    @Test
    public void testACLsDisabled() {
        Configuration conf = new Configuration(false);
        conf.setBoolean("tez.am.acls.enabled", false);
        String viewACLs = "a2,u2  ";
        String modifyACLs = "a2,u2 ";
        conf.set("tez.am.view-acls", viewACLs);
        conf.set("tez.am.modify-acls", modifyACLs);
        UserGroupInformation a1 = UserGroupInformation.createUserForTesting((String)"a1", (String[])noGroups);
        UserGroupInformation u1 = UserGroupInformation.createUserForTesting((String)"u1", (String[])noGroups);
        ACLManager aclManager = new ACLManager(a1.getShortUserName(), conf);
        Assert.assertTrue((boolean)aclManager.checkAMViewAccess(a1));
        Assert.assertTrue((boolean)aclManager.checkAMViewAccess(u1));
        Assert.assertTrue((boolean)aclManager.checkAMModifyAccess(a1));
        Assert.assertTrue((boolean)aclManager.checkAMModifyAccess(u1));
        Assert.assertTrue((boolean)aclManager.checkDAGViewAccess(a1));
        Assert.assertTrue((boolean)aclManager.checkDAGViewAccess(u1));
        Assert.assertTrue((boolean)aclManager.checkDAGModifyAccess(a1));
        Assert.assertTrue((boolean)aclManager.checkDAGModifyAccess(u1));
        ACLManager dagAclManager = new ACLManager(aclManager, "dagUser", null);
        Assert.assertTrue((boolean)dagAclManager.checkAMViewAccess(a1));
        Assert.assertTrue((boolean)dagAclManager.checkAMViewAccess(u1));
        Assert.assertTrue((boolean)dagAclManager.checkAMModifyAccess(a1));
        Assert.assertTrue((boolean)dagAclManager.checkAMModifyAccess(u1));
        Assert.assertTrue((boolean)dagAclManager.checkDAGViewAccess(a1));
        Assert.assertTrue((boolean)dagAclManager.checkDAGViewAccess(u1));
        Assert.assertTrue((boolean)dagAclManager.checkDAGModifyAccess(a1));
        Assert.assertTrue((boolean)dagAclManager.checkDAGModifyAccess(u1));
    }

    @Test
    public void testConvertToYARNACLs() {
        String currentUser = "c1";
        Configuration conf = new Configuration(false);
        String viewACLs = "user1,user4,,   grp3,grp4  ";
        conf.set("tez.am.view-acls", viewACLs);
        conf.set("tez.am.modify-acls", "   * ");
        ACLManager aclManager = new ACLManager(currentUser, conf);
        Map yarnAcls = aclManager.toYARNACls();
        Assert.assertTrue((boolean)yarnAcls.containsKey(ApplicationAccessType.VIEW_APP));
        Assert.assertEquals((Object)"c1,user1,user4 grp3,grp4", yarnAcls.get(ApplicationAccessType.VIEW_APP));
        Assert.assertTrue((boolean)yarnAcls.containsKey(ApplicationAccessType.MODIFY_APP));
        Assert.assertEquals((Object)"*", yarnAcls.get(ApplicationAccessType.MODIFY_APP));
        viewACLs = "   grp3,grp4  ";
        conf.set("tez.am.view-acls", viewACLs);
        ACLManager aclManager1 = new ACLManager(currentUser, conf);
        yarnAcls = aclManager1.toYARNACls();
        Assert.assertEquals((Object)"c1 grp3,grp4", yarnAcls.get(ApplicationAccessType.VIEW_APP));
    }
}

