/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.tez.common.TezYARNUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestTezYARNUtils {
    @Test
    public void testAuxClasspath() {
        Configuration conf = new Configuration(false);
        conf.set("tez.cluster.additional.classpath.prefix", "foobar");
        String classpath = TezYARNUtils.getFrameworkClasspath((Configuration)conf, (boolean)true);
        Assert.assertTrue((boolean)classpath.contains("foobar"));
        Assert.assertTrue((classpath.indexOf("foobar") < classpath.indexOf("tezlib") ? 1 : 0) != 0);
        Assert.assertTrue((classpath.indexOf("foobar") < classpath.indexOf(ApplicationConstants.Environment.PWD.$()) ? 1 : 0) != 0);
    }

    @Test
    public void testBasicArchiveClasspath() {
        Configuration conf = new Configuration(false);
        String classpath = TezYARNUtils.getFrameworkClasspath((Configuration)conf, (boolean)true);
        Assert.assertTrue((boolean)classpath.contains(ApplicationConstants.Environment.PWD.$()));
        Assert.assertTrue((boolean)classpath.contains(ApplicationConstants.Environment.PWD.$() + File.separator + "*"));
        Assert.assertTrue((boolean)classpath.contains("tezlib" + File.separator + "*"));
        Assert.assertTrue((boolean)classpath.contains("tezlib" + File.separator + "lib" + File.separator + "*"));
        Assert.assertTrue((boolean)classpath.contains(ApplicationConstants.Environment.HADOOP_CONF_DIR.$()));
        Assert.assertTrue((classpath.indexOf(ApplicationConstants.Environment.PWD.$()) < classpath.indexOf("tezlib") ? 1 : 0) != 0);
        Assert.assertTrue((classpath.indexOf("tezlib") < classpath.indexOf(ApplicationConstants.Environment.HADOOP_CONF_DIR.$()) ? 1 : 0) != 0);
    }
}

