/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.tez.common.ReflectionUtils;
import org.apache.tez.dag.api.TezException;
import org.junit.Assert;
import org.junit.Test;

public class TestReflectionUtils {
    @Test
    public void testConstructorWithParameters() {
        Class[] parameterTypes = new Class[]{String.class, Integer.TYPE};
        Object[] parameters = new Object[]{new String("test"), 1};
        ParameterizedConstructorClass instance = (ParameterizedConstructorClass)ReflectionUtils.createClazzInstance((String)ParameterizedConstructorClass.class.getName(), (Class[])parameterTypes, (Object[])parameters);
        Assert.assertEquals((String)"Class not constructed with first parameter correctly", (Object)instance.first, (Object)"test");
        Assert.assertEquals((String)"Class not constructed with second parameter correctly", (long)instance.second, (long)1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddResourceToClasspath() throws IOException, TezException {
        String rsrcName = "dummyfile.xml";
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)new Configuration());
        Path p = new Path(rsrcName);
        p = localFs.makeQualified(p);
        localFs.delete(p, false);
        try {
            URL loadedUrl = null;
            loadedUrl = Thread.currentThread().getContextClassLoader().getResource(rsrcName);
            Assert.assertNull((Object)loadedUrl);
            Assert.assertTrue((boolean)localFs.createNewFile(p));
            String urlForm = p.toUri().toURL().toString();
            urlForm = urlForm.substring(0, urlForm.lastIndexOf(47) + 1);
            URL url = new URL(urlForm);
            ReflectionUtils.addResourcesToClasspath(Collections.singletonList(url));
            loadedUrl = Thread.currentThread().getContextClassLoader().getResource(rsrcName);
            Assert.assertNotNull((Object)loadedUrl);
        }
        finally {
            localFs.delete(p, false);
        }
    }

    public static class ParameterizedConstructorClass {
        final String first;
        final int second;

        public ParameterizedConstructorClass(String first, int second) {
            this.first = first;
            this.second = second;
        }
    }
}

