/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.client;

import com.google.common.collect.Maps;
import com.google.protobuf.RpcController;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.tez.client.FrameworkClient;
import org.apache.tez.client.TezClient;
import org.apache.tez.client.TezYarnClient;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.PreWarmVertex;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.SessionNotRunning;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.rpc.DAGClientAMProtocolBlockingPB;
import org.apache.tez.dag.api.client.rpc.DAGClientAMProtocolRPC;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestTezClient {
    TezClientForTest configure() throws YarnException, IOException {
        return this.configure(new HashMap<String, LocalResource>(), true);
    }

    TezClientForTest configure(Map<String, LocalResource> lrs, boolean isSession) throws YarnException, IOException {
        DAGClientAMProtocolBlockingPB sessionAmProxy;
        TezConfiguration conf = new TezConfiguration();
        conf.setBoolean("tez.ignore.lib.uris", true);
        conf.setBoolean("tez.am.mode.session", isSession);
        TezClientForTest client = new TezClientForTest("test", conf, lrs, null);
        ApplicationId appId1 = ApplicationId.newInstance((long)0L, (int)1);
        YarnClient yarnClient = (YarnClient)Mockito.mock(YarnClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)yarnClient.createApplication().getNewApplicationResponse().getApplicationId()).thenReturn((Object)appId1);
        client.sessionAmProxy = sessionAmProxy = (DAGClientAMProtocolBlockingPB)Mockito.mock(DAGClientAMProtocolBlockingPB.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        client.mockTezYarnClient = new TezYarnClient(yarnClient);
        client.mockYarnClient = yarnClient;
        client.mockAppId = appId1;
        return client;
    }

    @Test(timeout=5000L)
    public void testTezclientApp() throws Exception {
        this.testTezClient(false);
    }

    @Test(timeout=5000L)
    public void testTezclientSession() throws Exception {
        this.testTezClient(true);
    }

    public void testTezClient(boolean isSession) throws Exception {
        HashMap lrs = Maps.newHashMap();
        String lrName1 = "LR1";
        lrs.put(lrName1, LocalResource.newInstance((URL)URL.newInstance((String)"file", (String)"localhost", (int)0, (String)"/test"), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.PUBLIC, (long)1L, (long)1L));
        TezClientForTest client = this.configure(lrs, isSession);
        ArgumentCaptor captor = ArgumentCaptor.forClass(ApplicationSubmissionContext.class);
        client.start();
        ((YarnClient)Mockito.verify((Object)client.mockYarnClient, (VerificationMode)Mockito.times((int)1))).init((Configuration)Matchers.any());
        ((YarnClient)Mockito.verify((Object)client.mockYarnClient, (VerificationMode)Mockito.times((int)1))).start();
        if (isSession) {
            ((YarnClient)Mockito.verify((Object)client.mockYarnClient, (VerificationMode)Mockito.times((int)1))).submitApplication((ApplicationSubmissionContext)captor.capture());
            ApplicationSubmissionContext context = (ApplicationSubmissionContext)captor.getValue();
            Assert.assertEquals((long)3L, (long)context.getAMContainerSpec().getLocalResources().size());
            Assert.assertTrue((boolean)context.getAMContainerSpec().getLocalResources().containsKey("tez.session.local-resources.pb"));
            Assert.assertTrue((boolean)context.getAMContainerSpec().getLocalResources().containsKey("tez-conf.pb"));
            Assert.assertTrue((boolean)context.getAMContainerSpec().getLocalResources().containsKey(lrName1));
        } else {
            ((YarnClient)Mockito.verify((Object)client.mockYarnClient, (VerificationMode)Mockito.times((int)0))).submitApplication((ApplicationSubmissionContext)captor.capture());
        }
        String mockLR1Name = "LR1";
        Map<String, LocalResource> lrDAG = Collections.singletonMap(mockLR1Name, LocalResource.newInstance((URL)URL.newInstance((String)"file", (String)"localhost", (int)0, (String)"/test1"), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.PUBLIC, (long)1L, (long)1L));
        Vertex vertex = Vertex.create((String)"Vertex", (ProcessorDescriptor)ProcessorDescriptor.create((String)"P"), (int)1, (Resource)Resource.newInstance((int)1, (int)1));
        DAG dag = DAG.create((String)"DAG").addVertex(vertex).addTaskLocalFiles(lrDAG);
        DAGClient dagClient = client.submitDAG(dag);
        Assert.assertTrue((boolean)dagClient.getExecutionContext().contains(client.mockAppId.toString()));
        if (isSession) {
            ((YarnClient)Mockito.verify((Object)client.mockYarnClient, (VerificationMode)Mockito.times((int)1))).submitApplication((ApplicationSubmissionContext)captor.capture());
            ((DAGClientAMProtocolBlockingPB)Mockito.verify((Object)client.sessionAmProxy, (VerificationMode)Mockito.times((int)1))).submitDAG((RpcController)Matchers.any(), (DAGClientAMProtocolRPC.SubmitDAGRequestProto)Matchers.any());
        } else {
            ((YarnClient)Mockito.verify((Object)client.mockYarnClient, (VerificationMode)Mockito.times((int)1))).submitApplication((ApplicationSubmissionContext)captor.capture());
            ApplicationSubmissionContext context = (ApplicationSubmissionContext)captor.getValue();
            Assert.assertEquals((long)4L, (long)context.getAMContainerSpec().getLocalResources().size());
            Assert.assertTrue((boolean)context.getAMContainerSpec().getLocalResources().containsKey("tez.session.local-resources.pb"));
            Assert.assertTrue((boolean)context.getAMContainerSpec().getLocalResources().containsKey("tez-conf.pb"));
            Assert.assertTrue((boolean)context.getAMContainerSpec().getLocalResources().containsKey("tez-dag.pb"));
            Assert.assertTrue((boolean)context.getAMContainerSpec().getLocalResources().containsKey(lrName1));
        }
        String lrName2 = "LR2";
        lrs.clear();
        lrs.put(lrName2, LocalResource.newInstance((URL)URL.newInstance((String)"file", (String)"localhost", (int)0, (String)"/test2"), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.PUBLIC, (long)1L, (long)1L));
        client.addAppMasterLocalFiles(lrs);
        ApplicationId appId2 = ApplicationId.newInstance((long)0L, (int)2);
        Mockito.when((Object)client.mockYarnClient.createApplication().getNewApplicationResponse().getApplicationId()).thenReturn((Object)appId2);
        dag = DAG.create((String)"DAG").addVertex(Vertex.create((String)"Vertex", (ProcessorDescriptor)ProcessorDescriptor.create((String)"P"), (int)1, (Resource)Resource.newInstance((int)1, (int)1)));
        dagClient = client.submitDAG(dag);
        if (isSession) {
            ((YarnClient)Mockito.verify((Object)client.mockYarnClient, (VerificationMode)Mockito.times((int)1))).submitApplication((ApplicationSubmissionContext)captor.capture());
            Assert.assertTrue((boolean)dagClient.getExecutionContext().contains(client.mockAppId.toString()));
            ArgumentCaptor captor1 = ArgumentCaptor.forClass(DAGClientAMProtocolRPC.SubmitDAGRequestProto.class);
            ((DAGClientAMProtocolBlockingPB)Mockito.verify((Object)client.sessionAmProxy, (VerificationMode)Mockito.times((int)2))).submitDAG((RpcController)Matchers.any(), (DAGClientAMProtocolRPC.SubmitDAGRequestProto)captor1.capture());
            DAGClientAMProtocolRPC.SubmitDAGRequestProto proto = (DAGClientAMProtocolRPC.SubmitDAGRequestProto)captor1.getValue();
            Assert.assertEquals((long)1L, (long)proto.getAdditionalAmResources().getLocalResourcesCount());
            Assert.assertEquals((Object)lrName2, (Object)proto.getAdditionalAmResources().getLocalResources(0).getName());
        } else {
            Assert.assertTrue((boolean)dagClient.getExecutionContext().contains(appId2.toString()));
            ((YarnClient)Mockito.verify((Object)client.mockYarnClient, (VerificationMode)Mockito.times((int)2))).submitApplication((ApplicationSubmissionContext)captor.capture());
            ApplicationSubmissionContext context = (ApplicationSubmissionContext)captor.getValue();
            Assert.assertEquals((long)5L, (long)context.getAMContainerSpec().getLocalResources().size());
            Assert.assertTrue((boolean)context.getAMContainerSpec().getLocalResources().containsKey("tez.session.local-resources.pb"));
            Assert.assertTrue((boolean)context.getAMContainerSpec().getLocalResources().containsKey("tez-conf.pb"));
            Assert.assertTrue((boolean)context.getAMContainerSpec().getLocalResources().containsKey("tez-dag.pb"));
            Assert.assertTrue((boolean)context.getAMContainerSpec().getLocalResources().containsKey(lrName1));
            Assert.assertTrue((boolean)context.getAMContainerSpec().getLocalResources().containsKey(lrName2));
        }
        client.stop();
        if (isSession) {
            ((DAGClientAMProtocolBlockingPB)Mockito.verify((Object)client.sessionAmProxy, (VerificationMode)Mockito.times((int)1))).shutdownSession((RpcController)Matchers.any(), (DAGClientAMProtocolRPC.ShutdownSessionRequestProto)Matchers.any());
        }
        ((YarnClient)Mockito.verify((Object)client.mockYarnClient, (VerificationMode)Mockito.times((int)1))).stop();
    }

    @Test(timeout=5000L)
    public void testPreWarm() throws Exception {
        TezClientForTest client = this.configure();
        client.start();
        Mockito.when((Object)client.mockYarnClient.getApplicationReport(client.mockAppId).getYarnApplicationState()).thenReturn((Object)YarnApplicationState.RUNNING);
        Mockito.when((Object)client.sessionAmProxy.getAMStatus((RpcController)Matchers.any(), (DAGClientAMProtocolRPC.GetAMStatusRequestProto)Matchers.any())).thenReturn((Object)DAGClientAMProtocolRPC.GetAMStatusResponseProto.newBuilder().setStatus(DAGClientAMProtocolRPC.TezSessionStatusProto.READY).build());
        PreWarmVertex vertex = PreWarmVertex.create((String)"PreWarm", (int)1, (Resource)Resource.newInstance((int)1, (int)1));
        client.preWarm(vertex);
        ArgumentCaptor captor1 = ArgumentCaptor.forClass(DAGClientAMProtocolRPC.SubmitDAGRequestProto.class);
        ((DAGClientAMProtocolBlockingPB)Mockito.verify((Object)client.sessionAmProxy, (VerificationMode)Mockito.times((int)1))).submitDAG((RpcController)Matchers.any(), (DAGClientAMProtocolRPC.SubmitDAGRequestProto)captor1.capture());
        DAGClientAMProtocolRPC.SubmitDAGRequestProto proto = (DAGClientAMProtocolRPC.SubmitDAGRequestProto)captor1.getValue();
        Assert.assertTrue((boolean)proto.getDAGPlan().getName().startsWith("TezPreWarmDAG"));
        client.stop();
    }

    @Test(timeout=10000L)
    public void testMultipleSubmissions() throws Exception {
        this.testMultipleSubmissionsJob(false);
        this.testMultipleSubmissionsJob(true);
    }

    public void testMultipleSubmissionsJob(boolean isSession) throws Exception {
        TezClientForTest client1 = this.configure(new HashMap<String, LocalResource>(), isSession);
        client1.start();
        String mockLR1Name = "LR1";
        Map<String, LocalResource> lrDAG = Collections.singletonMap(mockLR1Name, LocalResource.newInstance((URL)URL.newInstance((String)"file", (String)"localhost", (int)0, (String)"/test"), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.PUBLIC, (long)1L, (long)1L));
        String mockLR2Name = "LR2";
        Map<String, LocalResource> lrVertex = Collections.singletonMap(mockLR2Name, LocalResource.newInstance((URL)URL.newInstance((String)"file", (String)"localhost", (int)0, (String)"/test1"), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.PUBLIC, (long)1L, (long)1L));
        Vertex vertex = Vertex.create((String)"Vertex", (ProcessorDescriptor)ProcessorDescriptor.create((String)"P"), (int)1, (Resource)Resource.newInstance((int)1, (int)1)).addTaskLocalFiles(lrVertex);
        DAG dag = DAG.create((String)"DAG").addVertex(vertex).addTaskLocalFiles(lrDAG);
        client1.submitDAG(dag);
        TezClientForTest client2 = this.configure();
        client2.start();
        client2.submitDAG(dag);
        client1.stop();
        client2.stop();
    }

    @Test(timeout=5000L)
    public void testWaitTillReady_Interrupt() throws Exception {
        final TezClientForTest client = this.configure();
        client.start();
        Mockito.when((Object)client.mockYarnClient.getApplicationReport(client.mockAppId).getYarnApplicationState()).thenReturn((Object)YarnApplicationState.NEW);
        final AtomicReference exceptionReference = new AtomicReference();
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    client.waitTillReady();
                }
                catch (Exception e) {
                    exceptionReference.set(e);
                }
            }
        };
        thread.start();
        thread.join(250L);
        thread.interrupt();
        thread.join();
        Assert.assertThat(exceptionReference.get(), (Matcher)CoreMatchers.instanceOf(InterruptedException.class));
        client.stop();
    }

    @Test(timeout=5000L)
    public void testWaitTillReadyAppFailed() throws Exception {
        TezClientForTest client = this.configure();
        client.start();
        String msg = "Application Test Failed";
        Mockito.when((Object)client.mockYarnClient.getApplicationReport(client.mockAppId).getYarnApplicationState()).thenReturn((Object)YarnApplicationState.NEW).thenReturn((Object)YarnApplicationState.FAILED);
        Mockito.when((Object)client.mockYarnClient.getApplicationReport(client.mockAppId).getDiagnostics()).thenReturn((Object)msg);
        try {
            client.waitTillReady();
            Assert.fail();
        }
        catch (SessionNotRunning e) {
            Assert.assertTrue((boolean)e.getMessage().contains(msg));
        }
        client.stop();
    }

    @Test(timeout=5000L)
    public void testWaitTillReadyAppFailedNoDiagnostics() throws Exception {
        TezClientForTest client = this.configure();
        client.start();
        Mockito.when((Object)client.mockYarnClient.getApplicationReport(client.mockAppId).getYarnApplicationState()).thenReturn((Object)YarnApplicationState.NEW).thenReturn((Object)YarnApplicationState.FAILED);
        try {
            client.waitTillReady();
            Assert.fail();
        }
        catch (SessionNotRunning e) {
            Assert.assertTrue((boolean)e.getMessage().contains("No cluster diagnostics found."));
        }
        client.stop();
    }

    @Test(timeout=5000L)
    public void testSubmitDAGAppFailed() throws Exception {
        TezClientForTest client = this.configure();
        client.start();
        client.callRealGetSessionAMProxy = true;
        String msg = "Application Test Failed";
        Mockito.when((Object)client.mockYarnClient.getApplicationReport(client.mockAppId).getYarnApplicationState()).thenReturn((Object)YarnApplicationState.KILLED);
        Mockito.when((Object)client.mockYarnClient.getApplicationReport(client.mockAppId).getDiagnostics()).thenReturn((Object)msg);
        Vertex vertex = Vertex.create((String)"Vertex", (ProcessorDescriptor)ProcessorDescriptor.create((String)"P"), (int)1, (Resource)Resource.newInstance((int)1, (int)1));
        DAG dag = DAG.create((String)"DAG").addVertex(vertex);
        try {
            client.submitDAG(dag);
            Assert.fail();
        }
        catch (SessionNotRunning e) {
            Assert.assertTrue((boolean)e.getMessage().contains(msg));
        }
        client.stop();
    }

    class TezClientForTest
    extends TezClient {
        TezYarnClient mockTezYarnClient;
        DAGClientAMProtocolBlockingPB sessionAmProxy;
        YarnClient mockYarnClient;
        ApplicationId mockAppId;
        boolean callRealGetSessionAMProxy;

        public TezClientForTest(String name, @Nullable TezConfiguration tezConf, @Nullable Map<String, LocalResource> localResources, Credentials credentials) {
            super(name, tezConf, localResources, credentials);
        }

        protected FrameworkClient createFrameworkClient() {
            return this.mockTezYarnClient;
        }

        protected DAGClientAMProtocolBlockingPB getSessionAMProxy(ApplicationId appId) throws TezException, IOException {
            if (!this.callRealGetSessionAMProxy) {
                return this.sessionAmProxy;
            }
            return super.getSessionAMProxy(appId);
        }
    }
}

