/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api;

import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.Edge;
import org.apache.tez.dag.api.EdgeManagerDescriptor;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.GroupInputEdge;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.RootInputLeafOutput;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.VertexGroup;
import org.junit.Assert;
import org.junit.Test;

public class TestDAGVerify {
    private final String dummyProcessorClassName = TestDAGVerify.class.getName();
    private final String dummyInputClassName = TestDAGVerify.class.getName();
    private final String dummyOutputClassName = TestDAGVerify.class.getName();
    private final int dummyTaskCount = 2;
    private final Resource dummyTaskResource = Resource.newInstance((int)1, (int)1);

    @Test
    public void testVerifyScatterGather() {
        Vertex v1 = new Vertex("v1", new ProcessorDescriptor(this.dummyProcessorClassName), 2, this.dummyTaskResource);
        Vertex v2 = new Vertex("v2", new ProcessorDescriptor("MapProcessor"), 2, this.dummyTaskResource);
        Edge e1 = new Edge(v1, v2, new EdgeProperty(EdgeProperty.DataMovementType.SCATTER_GATHER, EdgeProperty.DataSourceType.PERSISTED, EdgeProperty.SchedulingType.SEQUENTIAL, new OutputDescriptor(this.dummyOutputClassName), new InputDescriptor(this.dummyInputClassName)));
        DAG dag = new DAG("testDag");
        dag.addVertex(v1);
        dag.addVertex(v2);
        dag.addEdge(e1);
        dag.verify();
    }

    @Test
    public void testVerifyCustomEdge() {
        Vertex v1 = new Vertex("v1", new ProcessorDescriptor(this.dummyProcessorClassName), 2, this.dummyTaskResource);
        Vertex v2 = new Vertex("v2", new ProcessorDescriptor("MapProcessor"), 2, this.dummyTaskResource);
        Edge e1 = new Edge(v1, v2, new EdgeProperty(new EdgeManagerDescriptor("emClass"), EdgeProperty.DataSourceType.PERSISTED, EdgeProperty.SchedulingType.SEQUENTIAL, new OutputDescriptor(this.dummyOutputClassName), new InputDescriptor(this.dummyInputClassName)));
        DAG dag = new DAG("testDag");
        dag.addVertex(v1);
        dag.addVertex(v2);
        dag.addEdge(e1);
        dag.verify();
    }

    @Test
    public void testVerifyOneToOne() {
        Vertex v1 = new Vertex("v1", new ProcessorDescriptor(this.dummyProcessorClassName), 2, this.dummyTaskResource);
        Vertex v2 = new Vertex("v2", new ProcessorDescriptor("MapProcessor"), 2, this.dummyTaskResource);
        Edge e1 = new Edge(v1, v2, new EdgeProperty(EdgeProperty.DataMovementType.ONE_TO_ONE, EdgeProperty.DataSourceType.PERSISTED, EdgeProperty.SchedulingType.SEQUENTIAL, new OutputDescriptor(this.dummyOutputClassName), new InputDescriptor(this.dummyInputClassName)));
        DAG dag = new DAG("testDag");
        dag.addVertex(v1);
        dag.addVertex(v2);
        dag.addEdge(e1);
        dag.verify();
    }

    @Test
    public void testVerifyBroadcast() {
        Vertex v1 = new Vertex("v1", new ProcessorDescriptor(this.dummyProcessorClassName), 2, this.dummyTaskResource);
        Vertex v2 = new Vertex("v2", new ProcessorDescriptor("MapProcessor"), 2, this.dummyTaskResource);
        Edge e1 = new Edge(v1, v2, new EdgeProperty(EdgeProperty.DataMovementType.BROADCAST, EdgeProperty.DataSourceType.PERSISTED, EdgeProperty.SchedulingType.SEQUENTIAL, new OutputDescriptor(this.dummyOutputClassName), new InputDescriptor(this.dummyInputClassName)));
        DAG dag = new DAG("testDag");
        dag.addVertex(v1);
        dag.addVertex(v2);
        dag.addEdge(e1);
        dag.verify();
    }

    @Test(expected=IllegalStateException.class)
    public void testVerify3() {
        Vertex v1 = new Vertex("v1", new ProcessorDescriptor(this.dummyProcessorClassName), 2, this.dummyTaskResource);
        Vertex v2 = new Vertex("v2", new ProcessorDescriptor("MapProcessor"), 2, this.dummyTaskResource);
        Edge e1 = new Edge(v1, v2, new EdgeProperty(EdgeProperty.DataMovementType.SCATTER_GATHER, EdgeProperty.DataSourceType.EPHEMERAL, EdgeProperty.SchedulingType.SEQUENTIAL, new OutputDescriptor(this.dummyOutputClassName), new InputDescriptor(this.dummyInputClassName)));
        DAG dag = new DAG("testDag");
        dag.addVertex(v1);
        dag.addVertex(v2);
        dag.addEdge(e1);
        dag.verify();
    }

    @Test(expected=IllegalStateException.class)
    public void testVerify4() {
        Vertex v1 = new Vertex("v1", new ProcessorDescriptor(this.dummyProcessorClassName), 2, this.dummyTaskResource);
        Vertex v2 = new Vertex("v2", new ProcessorDescriptor("MapProcessor"), 2, this.dummyTaskResource);
        Edge e1 = new Edge(v1, v2, new EdgeProperty(EdgeProperty.DataMovementType.SCATTER_GATHER, EdgeProperty.DataSourceType.EPHEMERAL, EdgeProperty.SchedulingType.CONCURRENT, new OutputDescriptor(this.dummyOutputClassName), new InputDescriptor(this.dummyInputClassName)));
        DAG dag = new DAG("testDag");
        dag.addVertex(v1);
        dag.addVertex(v2);
        dag.addEdge(e1);
        dag.verify();
    }

    @Test
    public void testCycle1() {
        IllegalStateException ex = null;
        Vertex v1 = new Vertex("v1", new ProcessorDescriptor("MapProcessor"), 2, this.dummyTaskResource);
        Vertex v2 = new Vertex("v2", new ProcessorDescriptor("MapProcessor"), 2, this.dummyTaskResource);
        Vertex v3 = new Vertex("v3", new ProcessorDescriptor("MapProcessor"), 2, this.dummyTaskResource);
        Vertex v4 = new Vertex("v4", new ProcessorDescriptor("MapProcessor"), 2, this.dummyTaskResource);
        Edge e1 = new Edge(v1, v2, new EdgeProperty(EdgeProperty.DataMovementType.SCATTER_GATHER, EdgeProperty.DataSourceType.PERSISTED, EdgeProperty.SchedulingType.SEQUENTIAL, new OutputDescriptor("dummy output class"), new InputDescriptor("dummy input class")));
        Edge e2 = new Edge(v2, v3, new EdgeProperty(EdgeProperty.DataMovementType.SCATTER_GATHER, EdgeProperty.DataSourceType.PERSISTED, EdgeProperty.SchedulingType.SEQUENTIAL, new OutputDescriptor("dummy output class"), new InputDescriptor("dummy input class")));
        Edge e3 = new Edge(v2, v4, new EdgeProperty(EdgeProperty.DataMovementType.SCATTER_GATHER, EdgeProperty.DataSourceType.PERSISTED, EdgeProperty.SchedulingType.SEQUENTIAL, new OutputDescriptor("dummy output class"), new InputDescriptor("dummy input class")));
        Edge e4 = new Edge(v4, v1, new EdgeProperty(EdgeProperty.DataMovementType.SCATTER_GATHER, EdgeProperty.DataSourceType.PERSISTED, EdgeProperty.SchedulingType.SEQUENTIAL, new OutputDescriptor("dummy output class"), new InputDescriptor("dummy input class")));
        DAG dag = new DAG("testDag");
        dag.addVertex(v1);
        dag.addVertex(v2);
        dag.addVertex(v3);
        dag.addVertex(v4);
        dag.addEdge(e1);
        dag.addEdge(e2);
        dag.addEdge(e3);
        dag.addEdge(e4);
        try {
            dag.verify();
        }
        catch (IllegalStateException e) {
            ex = e;
        }
        Assert.assertNotNull((Object)ex);
        System.out.println(ex.getMessage());
        Assert.assertTrue((boolean)ex.getMessage().startsWith("DAG contains a cycle"));
    }

    @Test
    public void testCycle2() {
        IllegalStateException ex = null;
        Vertex v1 = new Vertex("v1", new ProcessorDescriptor("MapProcessor"), 2, this.dummyTaskResource);
        Vertex v2 = new Vertex("v2", new ProcessorDescriptor("MapProcessor"), 2, this.dummyTaskResource);
        Vertex v3 = new Vertex("v3", new ProcessorDescriptor("MapProcessor"), 2, this.dummyTaskResource);
        Vertex v4 = new Vertex("v4", new ProcessorDescriptor("MapProcessor"), 2, this.dummyTaskResource);
        Edge e1 = new Edge(v1, v2, new EdgeProperty(EdgeProperty.DataMovementType.SCATTER_GATHER, EdgeProperty.DataSourceType.PERSISTED, EdgeProperty.SchedulingType.SEQUENTIAL, new OutputDescriptor("dummy output class"), new InputDescriptor("dummy input class")));
        Edge e2 = new Edge(v2, v3, new EdgeProperty(EdgeProperty.DataMovementType.SCATTER_GATHER, EdgeProperty.DataSourceType.PERSISTED, EdgeProperty.SchedulingType.SEQUENTIAL, new OutputDescriptor("dummy output class"), new InputDescriptor("dummy input class")));
        Edge e3 = new Edge(v2, v4, new EdgeProperty(EdgeProperty.DataMovementType.SCATTER_GATHER, EdgeProperty.DataSourceType.PERSISTED, EdgeProperty.SchedulingType.SEQUENTIAL, new OutputDescriptor("dummy output class"), new InputDescriptor("dummy input class")));
        Edge e4 = new Edge(v3, v2, new EdgeProperty(EdgeProperty.DataMovementType.SCATTER_GATHER, EdgeProperty.DataSourceType.PERSISTED, EdgeProperty.SchedulingType.SEQUENTIAL, new OutputDescriptor("dummy output class"), new InputDescriptor("dummy input class")));
        DAG dag = new DAG("testDag");
        dag.addVertex(v1);
        dag.addVertex(v2);
        dag.addVertex(v3);
        dag.addVertex(v4);
        dag.addEdge(e1);
        dag.addEdge(e2);
        dag.addEdge(e3);
        dag.addEdge(e4);
        try {
            dag.verify();
        }
        catch (IllegalStateException e) {
            ex = e;
        }
        Assert.assertNotNull((Object)ex);
        System.out.println(ex.getMessage());
        Assert.assertTrue((boolean)ex.getMessage().startsWith("DAG contains a cycle"));
    }

    @Test
    public void repeatedVertexName() {
        IllegalStateException ex = null;
        Vertex v1 = new Vertex("v1", new ProcessorDescriptor("MapProcessor"), 2, this.dummyTaskResource);
        Vertex v1repeat = new Vertex("v1", new ProcessorDescriptor("MapProcessor"), 2, this.dummyTaskResource);
        try {
            DAG dag = new DAG("testDag");
            dag.addVertex(v1);
            dag.addVertex(v1repeat);
            dag.verify();
        }
        catch (IllegalStateException e) {
            ex = e;
        }
        Assert.assertNotNull((Object)ex);
        System.out.println(ex.getMessage());
        Assert.assertTrue((boolean)ex.getMessage().startsWith("Vertex v1 already defined"));
    }

    @Test(expected=IllegalStateException.class)
    public void testInputAndInputVertexNameCollision() {
        Vertex v1 = new Vertex("v1", new ProcessorDescriptor("MapProcessor"), 2, this.dummyTaskResource);
        Vertex v2 = new Vertex("v2", new ProcessorDescriptor("MapProcessor"), 2, this.dummyTaskResource);
        v2.addInput("v1", new InputDescriptor(), null);
        Edge e1 = new Edge(v1, v2, new EdgeProperty(EdgeProperty.DataMovementType.SCATTER_GATHER, EdgeProperty.DataSourceType.PERSISTED, EdgeProperty.SchedulingType.SEQUENTIAL, new OutputDescriptor("dummy output class"), new InputDescriptor("dummy input class")));
        DAG dag = new DAG("testDag");
        dag.addVertex(v1);
        dag.addVertex(v2);
        dag.addEdge(e1);
        dag.verify();
    }

    @Test(expected=IllegalStateException.class)
    public void testOutputAndOutputVertexNameCollision() {
        Vertex v1 = new Vertex("v1", new ProcessorDescriptor("MapProcessor"), 2, this.dummyTaskResource);
        Vertex v2 = new Vertex("v2", new ProcessorDescriptor("MapProcessor"), 2, this.dummyTaskResource);
        v1.addOutput("v2", new OutputDescriptor());
        Edge e1 = new Edge(v1, v2, new EdgeProperty(EdgeProperty.DataMovementType.SCATTER_GATHER, EdgeProperty.DataSourceType.PERSISTED, EdgeProperty.SchedulingType.SEQUENTIAL, new OutputDescriptor("dummy output class"), new InputDescriptor("dummy input class")));
        DAG dag = new DAG("testDag");
        dag.addVertex(v1);
        dag.addVertex(v2);
        dag.addEdge(e1);
        dag.verify();
    }

    @Test(expected=IllegalStateException.class)
    public void testOutputAndVertexNameCollision() {
        Vertex v1 = new Vertex("v1", new ProcessorDescriptor("MapProcessor"), 2, this.dummyTaskResource);
        Vertex v2 = new Vertex("v2", new ProcessorDescriptor("MapProcessor"), 2, this.dummyTaskResource);
        v1.addOutput("v2", new OutputDescriptor());
        DAG dag = new DAG("testDag");
        dag.addVertex(v1);
        dag.addVertex(v2);
        dag.verify();
    }

    @Test(expected=IllegalStateException.class)
    public void testInputAndVertexNameCollision() {
        Vertex v1 = new Vertex("v1", new ProcessorDescriptor("MapProcessor"), 2, this.dummyTaskResource);
        Vertex v2 = new Vertex("v2", new ProcessorDescriptor("MapProcessor"), 2, this.dummyTaskResource);
        v1.addInput("v2", new InputDescriptor(), null);
        DAG dag = new DAG("testDag");
        dag.addVertex(v1);
        dag.addVertex(v2);
        dag.verify();
    }

    @Test
    public void BinaryInputAllowed() {
        Vertex v1 = new Vertex("v1", new ProcessorDescriptor("MapProcessor"), 2, this.dummyTaskResource);
        Vertex v2 = new Vertex("v2", new ProcessorDescriptor("MapProcessor"), 2, this.dummyTaskResource);
        Vertex v3 = new Vertex("v3", new ProcessorDescriptor("ReduceProcessor"), 2, this.dummyTaskResource);
        Edge e1 = new Edge(v1, v3, new EdgeProperty(EdgeProperty.DataMovementType.SCATTER_GATHER, EdgeProperty.DataSourceType.PERSISTED, EdgeProperty.SchedulingType.SEQUENTIAL, new OutputDescriptor("dummy output class"), new InputDescriptor("dummy input class")));
        Edge e2 = new Edge(v2, v3, new EdgeProperty(EdgeProperty.DataMovementType.SCATTER_GATHER, EdgeProperty.DataSourceType.PERSISTED, EdgeProperty.SchedulingType.SEQUENTIAL, new OutputDescriptor("dummy output class"), new InputDescriptor("dummy input class")));
        DAG dag = new DAG("testDag");
        dag.addVertex(v1);
        dag.addVertex(v2);
        dag.addVertex(v3);
        dag.addEdge(e1);
        dag.addEdge(e2);
        dag.verify();
    }

    @Test
    public void testVertexGroupWithMultipleOutputEdges() {
        Vertex v1 = new Vertex("v1", new ProcessorDescriptor("Processor"), 2, this.dummyTaskResource);
        Vertex v2 = new Vertex("v2", new ProcessorDescriptor("Processor"), 2, this.dummyTaskResource);
        Vertex v3 = new Vertex("v3", new ProcessorDescriptor("Processor"), 2, this.dummyTaskResource);
        Vertex v4 = new Vertex("v4", new ProcessorDescriptor("Processor"), 2, this.dummyTaskResource);
        DAG dag = new DAG("testDag");
        VertexGroup uv12 = dag.createVertexGroup("uv12", new Vertex[]{v1, v2});
        OutputDescriptor outDesc = new OutputDescriptor();
        uv12.addOutput("uvOut", outDesc, null);
        GroupInputEdge e1 = new GroupInputEdge(uv12, v3, new EdgeProperty(EdgeProperty.DataMovementType.SCATTER_GATHER, EdgeProperty.DataSourceType.PERSISTED, EdgeProperty.SchedulingType.SEQUENTIAL, new OutputDescriptor("dummy output class"), new InputDescriptor("dummy input class")), new InputDescriptor("dummy input class"));
        GroupInputEdge e2 = new GroupInputEdge(uv12, v4, new EdgeProperty(EdgeProperty.DataMovementType.SCATTER_GATHER, EdgeProperty.DataSourceType.PERSISTED, EdgeProperty.SchedulingType.SEQUENTIAL, new OutputDescriptor("dummy output class"), new InputDescriptor("dummy input class")), new InputDescriptor("dummy input class"));
        dag.addVertex(v1);
        dag.addVertex(v2);
        dag.addVertex(v3);
        dag.addVertex(v4);
        dag.addEdge(e1);
        dag.addEdge(e2);
        dag.verify();
        Assert.assertEquals((long)2L, (long)v1.getOutputVertices().size());
        Assert.assertEquals((long)2L, (long)v2.getOutputVertices().size());
        Assert.assertTrue((boolean)v1.getOutputVertices().contains(v3));
        Assert.assertTrue((boolean)v1.getOutputVertices().contains(v4));
        Assert.assertTrue((boolean)v2.getOutputVertices().contains(v3));
        Assert.assertTrue((boolean)v2.getOutputVertices().contains(v4));
    }

    @Test
    public void testVertexGroup() {
        Vertex v1 = new Vertex("v1", new ProcessorDescriptor("Processor"), 2, this.dummyTaskResource);
        Vertex v2 = new Vertex("v2", new ProcessorDescriptor("Processor"), 2, this.dummyTaskResource);
        Vertex v3 = new Vertex("v3", new ProcessorDescriptor("Processor"), 2, this.dummyTaskResource);
        Vertex v4 = new Vertex("v4", new ProcessorDescriptor("Processor"), 2, this.dummyTaskResource);
        Vertex v5 = new Vertex("v5", new ProcessorDescriptor("Processor"), 2, this.dummyTaskResource);
        DAG dag = new DAG("testDag");
        String groupName1 = "uv12";
        VertexGroup uv12 = dag.createVertexGroup(groupName1, new Vertex[]{v1, v2});
        OutputDescriptor outDesc = new OutputDescriptor();
        uv12.addOutput("uvOut", outDesc, null);
        String groupName2 = "uv23";
        VertexGroup uv23 = dag.createVertexGroup(groupName2, new Vertex[]{v2, v3});
        GroupInputEdge e1 = new GroupInputEdge(uv12, v4, new EdgeProperty(EdgeProperty.DataMovementType.SCATTER_GATHER, EdgeProperty.DataSourceType.PERSISTED, EdgeProperty.SchedulingType.SEQUENTIAL, new OutputDescriptor("dummy output class"), new InputDescriptor("dummy input class")), new InputDescriptor("dummy input class"));
        GroupInputEdge e2 = new GroupInputEdge(uv23, v5, new EdgeProperty(EdgeProperty.DataMovementType.SCATTER_GATHER, EdgeProperty.DataSourceType.PERSISTED, EdgeProperty.SchedulingType.SEQUENTIAL, new OutputDescriptor("dummy output class"), new InputDescriptor("dummy input class")), new InputDescriptor("dummy input class"));
        dag.addVertex(v1);
        dag.addVertex(v2);
        dag.addVertex(v3);
        dag.addVertex(v4);
        dag.addVertex(v5);
        dag.addEdge(e1);
        dag.addEdge(e2);
        dag.verify();
        Assert.assertNull((Object)dag.getVertex(uv12.getGroupName()));
        Assert.assertNull((Object)dag.getVertex(uv23.getGroupName()));
        Assert.assertFalse((boolean)dag.edges.contains(e1));
        Assert.assertFalse((boolean)dag.edges.contains(e2));
        Assert.assertEquals((long)1L, (long)v1.getOutputs().size());
        Assert.assertEquals((long)1L, (long)v2.getOutputs().size());
        Assert.assertEquals((Object)outDesc, (Object)((RootInputLeafOutput)v1.getOutputs().get(0)).getDescriptor());
        Assert.assertEquals((Object)outDesc, (Object)((RootInputLeafOutput)v2.getOutputs().get(0)).getDescriptor());
        Assert.assertEquals((long)1L, (long)v1.getOutputVertices().size());
        Assert.assertEquals((long)1L, (long)v3.getOutputVertices().size());
        Assert.assertEquals((long)2L, (long)v2.getOutputVertices().size());
        Assert.assertTrue((boolean)v1.getOutputVertices().contains(v4));
        Assert.assertTrue((boolean)v3.getOutputVertices().contains(v5));
        Assert.assertTrue((boolean)v2.getOutputVertices().contains(v4));
        Assert.assertTrue((boolean)v2.getOutputVertices().contains(v5));
        Assert.assertEquals((long)2L, (long)v4.getInputVertices().size());
        Assert.assertTrue((boolean)v4.getInputVertices().contains(v1));
        Assert.assertTrue((boolean)v4.getInputVertices().contains(v2));
        Assert.assertEquals((long)2L, (long)v5.getInputVertices().size());
        Assert.assertTrue((boolean)v5.getInputVertices().contains(v2));
        Assert.assertTrue((boolean)v5.getInputVertices().contains(v3));
        Assert.assertEquals((long)1L, (long)v4.getGroupInputs().size());
        Assert.assertTrue((boolean)v4.getGroupInputs().containsKey(groupName1));
        Assert.assertEquals((long)1L, (long)v5.getGroupInputs().size());
        Assert.assertTrue((boolean)v5.getGroupInputs().containsKey(groupName2));
        Assert.assertEquals((long)2L, (long)dag.vertexGroups.size());
    }

    @Test
    public void BinaryOutput() {
        IllegalStateException ex = null;
        try {
            Vertex v1 = new Vertex("v1", new ProcessorDescriptor("MapProcessor"), 2, this.dummyTaskResource);
            Vertex v2 = new Vertex("v2", new ProcessorDescriptor("MapProcessor"), 2, this.dummyTaskResource);
            Vertex v3 = new Vertex("v3", new ProcessorDescriptor("MapProcessor"), 2, this.dummyTaskResource);
            Edge e1 = new Edge(v1, v2, new EdgeProperty(EdgeProperty.DataMovementType.SCATTER_GATHER, EdgeProperty.DataSourceType.PERSISTED, EdgeProperty.SchedulingType.SEQUENTIAL, new OutputDescriptor("dummy output class"), new InputDescriptor("dummy input class")));
            Edge e2 = new Edge(v1, v2, new EdgeProperty(EdgeProperty.DataMovementType.SCATTER_GATHER, EdgeProperty.DataSourceType.PERSISTED, EdgeProperty.SchedulingType.SEQUENTIAL, new OutputDescriptor("dummy output class"), new InputDescriptor("dummy input class")));
            DAG dag = new DAG("testDag");
            dag.addVertex(v1);
            dag.addVertex(v2);
            dag.addVertex(v3);
            dag.addEdge(e1);
            dag.addEdge(e2);
            dag.verify();
        }
        catch (IllegalStateException e) {
            ex = e;
        }
        Assert.assertNull((Object)ex);
    }

    @Test
    public void testDagWithNoVertices() {
        IllegalStateException ex = null;
        try {
            DAG dag = new DAG("testDag");
            dag.verify();
        }
        catch (IllegalStateException e) {
            ex = e;
        }
        Assert.assertNotNull((Object)ex);
        System.out.println(ex.getMessage());
        Assert.assertTrue((boolean)ex.getMessage().startsWith("Invalid dag containing 0 vertices"));
    }

    @Test
    public void testInvalidVertexConstruction() {
        Vertex v1 = new Vertex("v1", new ProcessorDescriptor("MapProcessor"), 0, this.dummyTaskResource);
        Vertex vertex = new Vertex("v1", new ProcessorDescriptor("MapProcessor"), -1, this.dummyTaskResource);
        try {
            v1 = new Vertex("v1", new ProcessorDescriptor("MapProcessor"), -2, this.dummyTaskResource);
            Assert.fail((String)"Expected exception for 0 parallelism");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Parallelism should be -1 if determined by the AM, otherwise should be >= 0"));
        }
        try {
            v1 = new Vertex("v1", new ProcessorDescriptor("MapProcessor"), 1, null);
            Assert.fail((String)"Expected exception for 0 parallelism");
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Resource cannot be null"));
        }
    }
}

