/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api;

import com.google.protobuf.ByteString;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.Edge;
import org.apache.tez.dag.api.EdgeManagerDescriptor;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.records.DAGProtos;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestDAGPlan {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testBasicJobPlanSerde() throws IOException {
        DAGProtos.DAGPlan inJob;
        DAGProtos.DAGPlan job = DAGProtos.DAGPlan.newBuilder().setName("test").addVertex(DAGProtos.VertexPlan.newBuilder().setName("vertex1").setType(DAGProtos.PlanVertexType.NORMAL).addTaskLocationHint(DAGProtos.PlanTaskLocationHint.newBuilder().addHost("machineName").addRack("rack1").build()).setTaskConfig(DAGProtos.PlanTaskConfiguration.newBuilder().setNumTasks(2).setVirtualCores(4).setMemoryMb(1024).setJavaOpts("").setTaskModule("x.y").build()).build()).build();
        File file = this.tempFolder.newFile("jobPlan");
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(file);
            job.writeTo((OutputStream)outStream);
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
        }
        try {
            FileInputStream inputStream = new FileInputStream(file);
            inJob = ((DAGProtos.DAGPlan.Builder)DAGProtos.DAGPlan.newBuilder().mergeFrom((InputStream)inputStream)).build();
        }
        finally {
            outStream.close();
        }
        Assert.assertEquals((Object)job, (Object)inJob);
    }

    @Test(timeout=5000L)
    public void testEdgeManagerSerde() {
        DAG dag = new DAG("testDag");
        ProcessorDescriptor pd1 = new ProcessorDescriptor("processor1").setUserPayload("processor1Bytes".getBytes());
        ProcessorDescriptor pd2 = new ProcessorDescriptor("processor2").setUserPayload("processor2Bytes".getBytes());
        Vertex v1 = new Vertex("v1", pd1, 10, Resource.newInstance((int)1024, (int)1));
        Vertex v2 = new Vertex("v2", pd2, 1, Resource.newInstance((int)1024, (int)1));
        v1.setJavaOpts("").setTaskEnvironment(new HashMap()).setTaskLocalResources(new HashMap());
        v2.setJavaOpts("").setTaskEnvironment(new HashMap()).setTaskLocalResources(new HashMap());
        InputDescriptor inputDescriptor = new InputDescriptor("input").setUserPayload("inputBytes".getBytes());
        OutputDescriptor outputDescriptor = new OutputDescriptor("output").setUserPayload("outputBytes".getBytes());
        Edge edge = new Edge(v1, v2, new EdgeProperty(new EdgeManagerDescriptor("emClass").setUserPayload("emPayload".getBytes()), EdgeProperty.DataSourceType.PERSISTED, EdgeProperty.SchedulingType.SEQUENTIAL, outputDescriptor, inputDescriptor));
        dag.addVertex(v1).addVertex(v2).addEdge(edge);
        DAGProtos.DAGPlan dagProto = dag.createDag((Configuration)new TezConfiguration());
        EdgeProperty edgeProperty = DagTypeConverters.createEdgePropertyMapFromDAGPlan((DAGProtos.EdgePlan)((DAGProtos.EdgePlan)dagProto.getEdgeList().get(0)));
        EdgeManagerDescriptor emDesc = edgeProperty.getEdgeManagerDescriptor();
        Assert.assertNotNull((Object)emDesc);
        Assert.assertEquals((Object)"emClass", (Object)emDesc.getClassName());
        Assert.assertTrue((boolean)Arrays.equals("emPayload".getBytes(), emDesc.getUserPayload()));
    }

    @Test(timeout=5000L)
    public void testUserPayloadSerde() {
        DAG dag = new DAG("testDag");
        ProcessorDescriptor pd1 = new ProcessorDescriptor("processor1").setUserPayload("processor1Bytes".getBytes());
        ProcessorDescriptor pd2 = new ProcessorDescriptor("processor2").setUserPayload("processor2Bytes".getBytes());
        Vertex v1 = new Vertex("v1", pd1, 10, Resource.newInstance((int)1024, (int)1));
        Vertex v2 = new Vertex("v2", pd2, 1, Resource.newInstance((int)1024, (int)1));
        v1.setJavaOpts("").setTaskEnvironment(new HashMap()).setTaskLocalResources(new HashMap());
        v2.setJavaOpts("").setTaskEnvironment(new HashMap()).setTaskLocalResources(new HashMap());
        InputDescriptor inputDescriptor = new InputDescriptor("input").setUserPayload("inputBytes".getBytes());
        OutputDescriptor outputDescriptor = new OutputDescriptor("output").setUserPayload("outputBytes".getBytes());
        Edge edge = new Edge(v1, v2, new EdgeProperty(EdgeProperty.DataMovementType.SCATTER_GATHER, EdgeProperty.DataSourceType.PERSISTED, EdgeProperty.SchedulingType.SEQUENTIAL, outputDescriptor, inputDescriptor));
        dag.addVertex(v1).addVertex(v2).addEdge(edge);
        DAGProtos.DAGPlan dagProto = dag.createDag((Configuration)new TezConfiguration());
        Assert.assertEquals((long)2L, (long)dagProto.getVertexCount());
        Assert.assertEquals((long)1L, (long)dagProto.getEdgeCount());
        DAGProtos.VertexPlan v1Proto = dagProto.getVertex(0);
        DAGProtos.VertexPlan v2Proto = dagProto.getVertex(1);
        DAGProtos.EdgePlan edgeProto = dagProto.getEdge(0);
        Assert.assertEquals((Object)"processor1Bytes", (Object)new String(v1Proto.getProcessorDescriptor().getUserPayload().toByteArray()));
        Assert.assertEquals((Object)"processor1", (Object)v1Proto.getProcessorDescriptor().getClassName());
        Assert.assertEquals((Object)"processor2Bytes", (Object)new String(v2Proto.getProcessorDescriptor().getUserPayload().toByteArray()));
        Assert.assertEquals((Object)"processor2", (Object)v2Proto.getProcessorDescriptor().getClassName());
        Assert.assertEquals((Object)"inputBytes", (Object)new String(edgeProto.getEdgeDestination().getUserPayload().toByteArray()));
        Assert.assertEquals((Object)"input", (Object)edgeProto.getEdgeDestination().getClassName());
        Assert.assertEquals((Object)"outputBytes", (Object)new String(edgeProto.getEdgeSource().getUserPayload().toByteArray()));
        Assert.assertEquals((Object)"output", (Object)edgeProto.getEdgeSource().getClassName());
        EdgeProperty edgeProperty = DagTypeConverters.createEdgePropertyMapFromDAGPlan((DAGProtos.EdgePlan)((DAGProtos.EdgePlan)dagProto.getEdgeList().get(0)));
        byte[] ib = edgeProperty.getEdgeDestination().getUserPayload();
        Assert.assertEquals((Object)"inputBytes", (Object)new String(ib));
        Assert.assertEquals((Object)"input", (Object)edgeProperty.getEdgeDestination().getClassName());
        byte[] ob = edgeProperty.getEdgeSource().getUserPayload();
        Assert.assertEquals((Object)"outputBytes", (Object)new String(ob));
        Assert.assertEquals((Object)"output", (Object)edgeProperty.getEdgeSource().getClassName());
    }

    @Test(timeout=5000L)
    public void userVertexOrderingIsMaintained() {
        DAG dag = new DAG("testDag");
        ProcessorDescriptor pd1 = new ProcessorDescriptor("processor1").setUserPayload("processor1Bytes".getBytes());
        ProcessorDescriptor pd2 = new ProcessorDescriptor("processor2").setUserPayload("processor2Bytes".getBytes());
        ProcessorDescriptor pd3 = new ProcessorDescriptor("processor3").setUserPayload("processor3Bytes".getBytes());
        Vertex v1 = new Vertex("v1", pd1, 10, Resource.newInstance((int)1024, (int)1));
        Vertex v2 = new Vertex("v2", pd2, 1, Resource.newInstance((int)1024, (int)1));
        Vertex v3 = new Vertex("v3", pd3, 1, Resource.newInstance((int)1024, (int)1));
        v1.setJavaOpts("").setTaskEnvironment(new HashMap()).setTaskLocalResources(new HashMap());
        v2.setJavaOpts("").setTaskEnvironment(new HashMap()).setTaskLocalResources(new HashMap());
        v3.setJavaOpts("").setTaskEnvironment(new HashMap()).setTaskLocalResources(new HashMap());
        InputDescriptor inputDescriptor = new InputDescriptor("input").setUserPayload("inputBytes".getBytes());
        OutputDescriptor outputDescriptor = new OutputDescriptor("output").setUserPayload("outputBytes".getBytes());
        Edge edge = new Edge(v1, v2, new EdgeProperty(EdgeProperty.DataMovementType.SCATTER_GATHER, EdgeProperty.DataSourceType.PERSISTED, EdgeProperty.SchedulingType.SEQUENTIAL, outputDescriptor, inputDescriptor));
        dag.addVertex(v1).addVertex(v2).addEdge(edge).addVertex(v3);
        DAGProtos.DAGPlan dagProto = dag.createDag((Configuration)new TezConfiguration());
        Assert.assertEquals((long)3L, (long)dagProto.getVertexCount());
        Assert.assertEquals((long)1L, (long)dagProto.getEdgeCount());
        DAGProtos.VertexPlan v1Proto = dagProto.getVertex(0);
        DAGProtos.VertexPlan v2Proto = dagProto.getVertex(1);
        DAGProtos.VertexPlan v3Proto = dagProto.getVertex(2);
        DAGProtos.EdgePlan edgeProto = dagProto.getEdge(0);
        Assert.assertEquals((Object)"processor1Bytes", (Object)new String(v1Proto.getProcessorDescriptor().getUserPayload().toByteArray()));
        Assert.assertEquals((Object)"processor1", (Object)v1Proto.getProcessorDescriptor().getClassName());
        Assert.assertEquals((Object)"processor2Bytes", (Object)new String(v2Proto.getProcessorDescriptor().getUserPayload().toByteArray()));
        Assert.assertEquals((Object)"processor2", (Object)v2Proto.getProcessorDescriptor().getClassName());
        Assert.assertEquals((Object)"processor3Bytes", (Object)new String(v3Proto.getProcessorDescriptor().getUserPayload().toByteArray()));
        Assert.assertEquals((Object)"processor3", (Object)v3Proto.getProcessorDescriptor().getClassName());
        Assert.assertEquals((Object)"inputBytes", (Object)new String(edgeProto.getEdgeDestination().getUserPayload().toByteArray()));
        Assert.assertEquals((Object)"input", (Object)edgeProto.getEdgeDestination().getClassName());
        Assert.assertEquals((Object)"outputBytes", (Object)new String(edgeProto.getEdgeSource().getUserPayload().toByteArray()));
        Assert.assertEquals((Object)"output", (Object)edgeProto.getEdgeSource().getClassName());
        EdgeProperty edgeProperty = DagTypeConverters.createEdgePropertyMapFromDAGPlan((DAGProtos.EdgePlan)((DAGProtos.EdgePlan)dagProto.getEdgeList().get(0)));
        byte[] ib = edgeProperty.getEdgeDestination().getUserPayload();
        Assert.assertEquals((Object)"inputBytes", (Object)new String(ib));
        Assert.assertEquals((Object)"input", (Object)edgeProperty.getEdgeDestination().getClassName());
        byte[] ob = edgeProperty.getEdgeSource().getUserPayload();
        Assert.assertEquals((Object)"outputBytes", (Object)new String(ob));
        Assert.assertEquals((Object)"output", (Object)edgeProperty.getEdgeSource().getClassName());
    }

    @Test(timeout=5000L)
    public void testCredentialsSerde() {
        DAG dag = new DAG("testDag");
        ProcessorDescriptor pd1 = new ProcessorDescriptor("processor1").setUserPayload("processor1Bytes".getBytes());
        ProcessorDescriptor pd2 = new ProcessorDescriptor("processor2").setUserPayload("processor2Bytes".getBytes());
        Vertex v1 = new Vertex("v1", pd1, 10, Resource.newInstance((int)1024, (int)1));
        Vertex v2 = new Vertex("v2", pd2, 1, Resource.newInstance((int)1024, (int)1));
        v1.setJavaOpts("").setTaskEnvironment(new HashMap()).setTaskLocalResources(new HashMap());
        v2.setJavaOpts("").setTaskEnvironment(new HashMap()).setTaskLocalResources(new HashMap());
        InputDescriptor inputDescriptor = new InputDescriptor("input").setUserPayload("inputBytes".getBytes());
        OutputDescriptor outputDescriptor = new OutputDescriptor("output").setUserPayload("outputBytes".getBytes());
        Edge edge = new Edge(v1, v2, new EdgeProperty(EdgeProperty.DataMovementType.SCATTER_GATHER, EdgeProperty.DataSourceType.PERSISTED, EdgeProperty.SchedulingType.SEQUENTIAL, outputDescriptor, inputDescriptor));
        dag.addVertex(v1).addVertex(v2).addEdge(edge);
        Credentials dagCredentials = new Credentials();
        Token token1 = new Token();
        Token token2 = new Token();
        dagCredentials.addToken(new Text("Token1"), token1);
        dagCredentials.addToken(new Text("Token2"), token2);
        dag.setCredentials(dagCredentials);
        DAGProtos.DAGPlan dagProto = dag.createDag((Configuration)new TezConfiguration());
        Assert.assertTrue((boolean)dagProto.hasCredentialsBinary());
        Credentials fetchedCredentials = DagTypeConverters.convertByteStringToCredentials((ByteString)dagProto.getCredentialsBinary());
        Assert.assertEquals((long)2L, (long)fetchedCredentials.numberOfTokens());
        Assert.assertNotNull((Object)fetchedCredentials.getToken(new Text("Token1")));
        Assert.assertNotNull((Object)fetchedCredentials.getToken(new Text("Token2")));
    }
}

