/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common.security;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.tez.common.security.Master;
import org.apache.tez.common.security.TokenCache;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestTokenCache {
    private static Configuration conf;
    private static String renewer;

    @BeforeClass
    public static void setup() throws Exception {
        conf = new Configuration();
        conf.set("yarn.resourcemanager.principal", "mapred/host@REALM");
        renewer = Master.getMasterPrincipal((Configuration)conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void testBinaryCredentials() throws Exception {
        String binaryTokenFile = null;
        try {
            Path TEST_ROOT_DIR = new Path("target");
            binaryTokenFile = FileSystem.getLocal((Configuration)conf).makeQualified(new Path(TEST_ROOT_DIR, "tokenFile")).toUri().getPath();
            FileSystemTestHelper.MockFileSystem fs1 = this.createFileSystemForServiceName("service1");
            FileSystemTestHelper.MockFileSystem fs2 = this.createFileSystemForServiceName("service2");
            FileSystemTestHelper.MockFileSystem fs3 = this.createFileSystemForServiceName("service3");
            Credentials creds = new Credentials();
            Token token1 = fs1.getDelegationToken(renewer);
            Token token2 = fs2.getDelegationToken(renewer);
            creds.addToken(token1.getService(), token1);
            creds.addToken(token2.getService(), token2);
            creds.writeTokenStorageFile(new Path(binaryTokenFile), conf);
            Credentials newCreds = new Credentials();
            TokenCache.mergeBinaryTokens((Credentials)newCreds, (Configuration)conf, (String)binaryTokenFile);
            Assert.assertTrue((newCreds.getAllTokens().size() > 0 ? 1 : 0) != 0);
            this.checkTokens(creds, newCreds);
            if (binaryTokenFile == null) return;
        }
        catch (Throwable throwable) {
            if (binaryTokenFile == null) throw throwable;
            try {
                FileSystem.getLocal((Configuration)conf).delete(new Path(binaryTokenFile));
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            FileSystem.getLocal((Configuration)conf).delete(new Path(binaryTokenFile));
            return;
        }
        catch (IOException iOException) {}
    }

    private FileSystemTestHelper.MockFileSystem createFileSystemForServiceName(final String service) throws IOException {
        FileSystemTestHelper.MockFileSystem mockFs = new FileSystemTestHelper.MockFileSystem();
        Mockito.when((Object)mockFs.getCanonicalServiceName()).thenReturn((Object)service);
        Mockito.when((Object)mockFs.getDelegationToken((String)Matchers.any(String.class))).thenAnswer(new Answer<Token<?>>(){
            int unique = 0;

            public Token<?> answer(InvocationOnMock invocation) throws Throwable {
                Token token = new Token();
                token.setService(new Text(service));
                token.setKind(new Text("token" + this.unique++));
                return token;
            }
        });
        return mockFs;
    }

    private void checkTokens(Credentials creds, Credentials newCreds) {
        Assert.assertEquals((long)creds.getAllTokens().size(), (long)newCreds.getAllTokens().size());
        for (Token token : newCreds.getAllTokens()) {
            Token credsToken = creds.getToken(token.getService());
            Assert.assertTrue((credsToken != null ? 1 : 0) != 0);
            Assert.assertEquals((Object)token, (Object)credsToken);
        }
    }
}

