/*
 * Decompiled with CFR 0.152.
 */
package storm.kafka;

import java.util.HashMap;
import java.util.Map;
import kafka.javaapi.consumer.SimpleConsumer;
import storm.kafka.Broker;
import storm.kafka.KafkaConfig;
import storm.kafka.StaticHosts;

public class StaticPartitionConnections {
    Map<Integer, SimpleConsumer> _kafka = new HashMap<Integer, SimpleConsumer>();
    KafkaConfig _config;
    StaticHosts hosts;

    public StaticPartitionConnections(KafkaConfig conf) {
        this._config = conf;
        if (!(conf.hosts instanceof StaticHosts)) {
            throw new RuntimeException("Must configure with static hosts");
        }
        this.hosts = (StaticHosts)conf.hosts;
    }

    public SimpleConsumer getConsumer(int partition2) {
        if (!this._kafka.containsKey(partition2)) {
            Broker hp = this.hosts.getPartitionInformation().getBrokerFor(partition2);
            this._kafka.put(partition2, new SimpleConsumer(hp.host, hp.port, this._config.socketTimeoutMs, this._config.bufferSizeBytes, this._config.clientId));
        }
        return this._kafka.get(partition2);
    }

    public void close() {
        for (SimpleConsumer consumer : this._kafka.values()) {
            consumer.close();
        }
    }
}

