/*
 * Decompiled with CFR 0.152.
 */
package storm.kafka;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RebalanceListener
implements ConsumerRebalanceListener {
    private static final Logger log = LoggerFactory.getLogger(RebalanceListener.class);
    private AtomicBoolean rebalanceFlag;

    public RebalanceListener(AtomicBoolean rebalanceFlag) {
        this.rebalanceFlag = rebalanceFlag;
    }

    public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
        for (TopicPartition partition2 : partitions) {
            log.info("topic {} - partition {} revoked.", (Object)partition2.topic(), (Object)partition2.partition());
        }
        this.rebalanceFlag.set(true);
    }

    public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
        for (TopicPartition partition2 : partitions) {
            log.info("topic {} - partition {} assigned.", (Object)partition2.topic(), (Object)partition2.partition());
        }
    }
}

