/*
 * Decompiled with CFR 0.152.
 */
package storm.kafka;

import backtype.storm.spout.SpoutOutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.topology.base.BaseRichSpout;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import storm.kafka.KafkaJavaApiSpout;
import storm.kafka.KafkaSpoutOld;
import storm.kafka.SpoutConfig;

public class KafkaSpout
extends BaseRichSpout {
    public static final Logger LOG = LoggerFactory.getLogger(KafkaSpout.class);
    private BaseRichSpout implementation;
    private SpoutConfig _spoutConfig;

    public KafkaSpout(SpoutConfig spoutConfig) {
        this._spoutConfig = spoutConfig;
        if (this._spoutConfig.kafkaAPIv != null && 0.9 >= Double.parseDouble(this._spoutConfig.kafkaAPIv)) {
            this.implementation = new KafkaJavaApiSpout(this._spoutConfig);
            LOG.debug("Will use 0.9 Kafka spout implementation");
        } else {
            this.implementation = new KafkaSpoutOld(this._spoutConfig);
            LOG.debug("Will use 0.8 Kafka spout implementation");
        }
    }

    public void open(Map conf, TopologyContext context, SpoutOutputCollector collector) {
        this.implementation.open(conf, context, collector);
    }

    public void nextTuple() {
        this.implementation.nextTuple();
    }

    public void ack(Object msgId) {
        this.implementation.ack(msgId);
    }

    public void fail(Object msgId) {
        this.implementation.fail(msgId);
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        this.implementation.declareOutputFields(declarer);
    }

    public void close() {
        this.implementation.close();
    }

    public void activate() {
        this.implementation.activate();
    }

    public void deactivate() {
        this.implementation.deactivate();
    }
}

