/*
 * Decompiled with CFR 0.152.
 */
package storm.kafka;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kafka.javaapi.consumer.SimpleConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import storm.kafka.Broker;
import storm.kafka.KafkaConfig;
import storm.kafka.Partition;
import storm.kafka.trident.IBrokerReader;

public class DynamicPartitionConnections {
    public static final Logger LOG = LoggerFactory.getLogger(DynamicPartitionConnections.class);
    Map<Broker, ConnectionInfo> _connections = new HashMap<Broker, ConnectionInfo>();
    KafkaConfig _config;
    IBrokerReader _reader;

    public DynamicPartitionConnections(KafkaConfig config, IBrokerReader brokerReader) {
        this._config = config;
        this._reader = brokerReader;
    }

    public SimpleConsumer register(Partition partition2) {
        Broker broker = this._reader.getBrokerForTopic(partition2.topic).getBrokerFor(partition2.partition);
        return this.register(broker, partition2.topic, partition2.partition);
    }

    public SimpleConsumer register(Broker host, String topic, int partition2) {
        if (!this._connections.containsKey(host)) {
            this._connections.put(host, new ConnectionInfo(new SimpleConsumer(host.host, host.port, this._config.socketTimeoutMs, this._config.bufferSizeBytes, this._config.clientId)));
        }
        ConnectionInfo info = this._connections.get(host);
        info.partitions.add(this.getHashKey(topic, partition2));
        return info.consumer;
    }

    public SimpleConsumer getConnection(Partition partition2) {
        ConnectionInfo info = this._connections.get(partition2.host);
        if (info != null) {
            return info.consumer;
        }
        return null;
    }

    public void unregister(Broker port, String topic, int partition2) {
        ConnectionInfo info = this._connections.get(port);
        info.partitions.remove(this.getHashKey(topic, partition2));
        if (info.partitions.isEmpty()) {
            info.consumer.close();
            this._connections.remove(port);
        }
    }

    public void unregister(Partition partition2) {
        this.unregister(partition2.host, partition2.topic, partition2.partition);
    }

    public void clear() {
        for (ConnectionInfo info : this._connections.values()) {
            info.consumer.close();
        }
        this._connections.clear();
    }

    private String getHashKey(String topic, int partition2) {
        return topic + "_" + partition2;
    }

    static class ConnectionInfo {
        SimpleConsumer consumer;
        Set<String> partitions = new HashSet<String>();

        public ConnectionInfo(SimpleConsumer consumer) {
            this.consumer = consumer;
        }
    }
}

