/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.snappy;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Properties;
import org.xerial.snappy.SnappyError;
import org.xerial.snappy.SnappyErrorCode;
import org.xerial.snappy.SnappyLoader;
import org.xerial.snappy.SnappyNativeAPI;

public class Snappy {
    private static Object impl;

    public static void arrayCopy(Object src, int offset, int byteLength, Object dest, int dest_offset) throws IOException {
        ((SnappyNativeAPI)impl).arrayCopy(src, offset, byteLength, dest, dest_offset);
    }

    public static byte[] compress(byte[] input2) throws IOException {
        return Snappy.rawCompress(input2, input2.length);
    }

    public static int compress(byte[] input2, int inputOffset, int inputLength, byte[] output, int outputOffset) throws IOException {
        return Snappy.rawCompress(input2, inputOffset, inputLength, output, outputOffset);
    }

    public static int compress(ByteBuffer uncompressed, ByteBuffer compressed) throws IOException {
        if (!uncompressed.isDirect()) {
            throw new SnappyError(SnappyErrorCode.NOT_A_DIRECT_BUFFER, "input is not a direct buffer");
        }
        if (!compressed.isDirect()) {
            throw new SnappyError(SnappyErrorCode.NOT_A_DIRECT_BUFFER, "destination is not a direct buffer");
        }
        int uPos = uncompressed.position();
        int uLen = uncompressed.remaining();
        int compressedSize = ((SnappyNativeAPI)impl).rawCompress(uncompressed, uPos, uLen, compressed, compressed.position());
        compressed.limit(compressed.position() + compressedSize);
        return compressedSize;
    }

    public static byte[] compress(char[] input2) {
        return Snappy.rawCompress(input2, input2.length * 2);
    }

    public static byte[] compress(double[] input2) {
        return Snappy.rawCompress(input2, input2.length * 8);
    }

    public static byte[] compress(float[] input2) {
        return Snappy.rawCompress(input2, input2.length * 4);
    }

    public static byte[] compress(int[] input2) {
        return Snappy.rawCompress(input2, input2.length * 4);
    }

    public static byte[] compress(long[] input2) {
        return Snappy.rawCompress(input2, input2.length * 8);
    }

    public static byte[] compress(short[] input2) {
        return Snappy.rawCompress(input2, input2.length * 2);
    }

    public static byte[] compress(String s2) throws IOException {
        try {
            return Snappy.compress(s2, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 encoder is not found");
        }
    }

    public static byte[] compress(String s2, String encoding) throws UnsupportedEncodingException, IOException {
        byte[] data2 = s2.getBytes(encoding);
        return Snappy.compress(data2);
    }

    public static byte[] compress(String s2, Charset encoding) throws IOException {
        byte[] data2 = s2.getBytes(encoding);
        return Snappy.compress(data2);
    }

    public static String getNativeLibraryVersion() {
        URL versionFile = SnappyLoader.class.getResource("/org/xerial/snappy/VERSION");
        String version = "unknown";
        try {
            if (versionFile != null) {
                Properties versionData = new Properties();
                versionData.load(versionFile.openStream());
                version = versionData.getProperty("version", version);
                if (version.equals("unknown")) {
                    version = versionData.getProperty("VERSION", version);
                }
                version = version.trim().replaceAll("[^0-9\\.]", "");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return version;
    }

    public static boolean isValidCompressedBuffer(byte[] input2, int offset, int length) throws IOException {
        if (input2 == null) {
            throw new NullPointerException("input is null");
        }
        return ((SnappyNativeAPI)impl).isValidCompressedBuffer(input2, offset, length);
    }

    public static boolean isValidCompressedBuffer(byte[] input2) throws IOException {
        return Snappy.isValidCompressedBuffer(input2, 0, input2.length);
    }

    public static boolean isValidCompressedBuffer(ByteBuffer compressed) throws IOException {
        return ((SnappyNativeAPI)impl).isValidCompressedBuffer(compressed, compressed.position(), compressed.remaining());
    }

    public static int maxCompressedLength(int byteSize) {
        return ((SnappyNativeAPI)impl).maxCompressedLength(byteSize);
    }

    public static byte[] rawCompress(Object data2, int byteSize) {
        byte[] buf = new byte[Snappy.maxCompressedLength(byteSize)];
        int compressedByteSize = ((SnappyNativeAPI)impl).rawCompress(data2, 0, byteSize, buf, 0);
        byte[] result2 = new byte[compressedByteSize];
        System.arraycopy(buf, 0, result2, 0, compressedByteSize);
        return result2;
    }

    public static int rawCompress(Object input2, int inputOffset, int inputLength, byte[] output, int outputOffset) throws IOException {
        if (input2 == null || output == null) {
            throw new NullPointerException("input or output is null");
        }
        int compressedSize = ((SnappyNativeAPI)impl).rawCompress(input2, inputOffset, inputLength, output, outputOffset);
        return compressedSize;
    }

    public static int rawUncompress(byte[] input2, int inputOffset, int inputLength, Object output, int outputOffset) throws IOException {
        if (input2 == null || output == null) {
            throw new NullPointerException("input or output is null");
        }
        return ((SnappyNativeAPI)impl).rawUncompress(input2, inputOffset, inputLength, output, outputOffset);
    }

    public static byte[] uncompress(byte[] input2) throws IOException {
        byte[] result2 = new byte[Snappy.uncompressedLength(input2)];
        int byteSize = Snappy.uncompress(input2, 0, input2.length, result2, 0);
        return result2;
    }

    public static int uncompress(byte[] input2, int inputOffset, int inputLength, byte[] output, int outputOffset) throws IOException {
        return Snappy.rawUncompress(input2, inputOffset, inputLength, output, outputOffset);
    }

    public static int uncompress(ByteBuffer compressed, ByteBuffer uncompressed) throws IOException {
        if (!compressed.isDirect()) {
            throw new SnappyError(SnappyErrorCode.NOT_A_DIRECT_BUFFER, "input is not a direct buffer");
        }
        if (!uncompressed.isDirect()) {
            throw new SnappyError(SnappyErrorCode.NOT_A_DIRECT_BUFFER, "destination is not a direct buffer");
        }
        int cPos = compressed.position();
        int cLen = compressed.remaining();
        int decompressedSize = ((SnappyNativeAPI)impl).rawUncompress(compressed, cPos, cLen, uncompressed, uncompressed.position());
        uncompressed.limit(uncompressed.position() + decompressedSize);
        return decompressedSize;
    }

    public static char[] uncompressCharArray(byte[] input2) throws IOException {
        return Snappy.uncompressCharArray(input2, 0, input2.length);
    }

    public static char[] uncompressCharArray(byte[] input2, int offset, int length) throws IOException {
        int uncompressedLength = Snappy.uncompressedLength(input2, offset, length);
        char[] result2 = new char[uncompressedLength / 2];
        int byteSize = ((SnappyNativeAPI)impl).rawUncompress(input2, offset, length, result2, 0);
        return result2;
    }

    public static double[] uncompressDoubleArray(byte[] input2) throws IOException {
        int uncompressedLength = Snappy.uncompressedLength(input2, 0, input2.length);
        double[] result2 = new double[uncompressedLength / 8];
        int byteSize = ((SnappyNativeAPI)impl).rawUncompress(input2, 0, input2.length, result2, 0);
        return result2;
    }

    public static int uncompressedLength(byte[] input2) throws IOException {
        return ((SnappyNativeAPI)impl).uncompressedLength(input2, 0, input2.length);
    }

    public static int uncompressedLength(byte[] input2, int offset, int length) throws IOException {
        if (input2 == null) {
            throw new NullPointerException("input is null");
        }
        return ((SnappyNativeAPI)impl).uncompressedLength(input2, offset, length);
    }

    public static int uncompressedLength(ByteBuffer compressed) throws IOException {
        if (!compressed.isDirect()) {
            throw new SnappyError(SnappyErrorCode.NOT_A_DIRECT_BUFFER, "input is not a direct buffer");
        }
        return ((SnappyNativeAPI)impl).uncompressedLength(compressed, compressed.position(), compressed.remaining());
    }

    public static float[] uncompressFloatArray(byte[] input2) throws IOException {
        return Snappy.uncompressFloatArray(input2, 0, input2.length);
    }

    public static float[] uncompressFloatArray(byte[] input2, int offset, int length) throws IOException {
        int uncompressedLength = Snappy.uncompressedLength(input2, offset, length);
        float[] result2 = new float[uncompressedLength / 4];
        int byteSize = ((SnappyNativeAPI)impl).rawUncompress(input2, offset, length, result2, 0);
        return result2;
    }

    public static int[] uncompressIntArray(byte[] input2) throws IOException {
        return Snappy.uncompressIntArray(input2, 0, input2.length);
    }

    public static int[] uncompressIntArray(byte[] input2, int offset, int length) throws IOException {
        int uncompressedLength = Snappy.uncompressedLength(input2, offset, length);
        int[] result2 = new int[uncompressedLength / 4];
        int byteSize = ((SnappyNativeAPI)impl).rawUncompress(input2, offset, length, result2, 0);
        return result2;
    }

    public static long[] uncompressLongArray(byte[] input2) throws IOException {
        return Snappy.uncompressLongArray(input2, 0, input2.length);
    }

    public static long[] uncompressLongArray(byte[] input2, int offset, int length) throws IOException {
        int uncompressedLength = Snappy.uncompressedLength(input2, offset, length);
        long[] result2 = new long[uncompressedLength / 8];
        int byteSize = ((SnappyNativeAPI)impl).rawUncompress(input2, offset, length, result2, 0);
        return result2;
    }

    public static short[] uncompressShortArray(byte[] input2) throws IOException {
        return Snappy.uncompressShortArray(input2, 0, input2.length);
    }

    public static short[] uncompressShortArray(byte[] input2, int offset, int length) throws IOException {
        int uncompressedLength = Snappy.uncompressedLength(input2, offset, length);
        short[] result2 = new short[uncompressedLength / 2];
        int byteSize = ((SnappyNativeAPI)impl).rawUncompress(input2, offset, length, result2, 0);
        return result2;
    }

    public static String uncompressString(byte[] input2) throws IOException {
        try {
            return Snappy.uncompressString(input2, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 decoder is not found");
        }
    }

    public static String uncompressString(byte[] input2, int offset, int length) throws IOException {
        try {
            return Snappy.uncompressString(input2, offset, length, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 decoder is not found");
        }
    }

    public static String uncompressString(byte[] input2, int offset, int length, String encoding) throws IOException, UnsupportedEncodingException {
        byte[] uncompressed = new byte[Snappy.uncompressedLength(input2, offset, length)];
        int compressedSize = Snappy.uncompress(input2, offset, length, uncompressed, 0);
        return new String(uncompressed, encoding);
    }

    public static String uncompressString(byte[] input2, int offset, int length, Charset encoding) throws IOException, UnsupportedEncodingException {
        byte[] uncompressed = new byte[Snappy.uncompressedLength(input2, offset, length)];
        int compressedSize = Snappy.uncompress(input2, offset, length, uncompressed, 0);
        return new String(uncompressed, encoding);
    }

    public static String uncompressString(byte[] input2, String encoding) throws IOException, UnsupportedEncodingException {
        byte[] uncompressed = Snappy.uncompress(input2);
        return new String(uncompressed, encoding);
    }

    public static String uncompressString(byte[] input2, Charset encoding) throws IOException, UnsupportedEncodingException {
        byte[] uncompressed = Snappy.uncompress(input2);
        return new String(uncompressed, encoding);
    }

    static {
        try {
            impl = SnappyLoader.load();
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

