/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.io.nio;

import java.nio.ByteBuffer;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.nio.NIOBuffer;

public class IndirectNIOBuffer
extends ByteArrayBuffer
implements NIOBuffer {
    protected ByteBuffer _buf;

    public IndirectNIOBuffer(int size2) {
        super(2, false);
        this._buf = ByteBuffer.allocate(size2);
        this._buf.position(0);
        this._buf.limit(this._buf.capacity());
        this._bytes = this._buf.array();
    }

    public IndirectNIOBuffer(ByteBuffer buffer, boolean immutable2) {
        super(immutable2 ? 0 : 2, false);
        if (buffer.isDirect()) {
            throw new IllegalArgumentException();
        }
        this._buf = buffer;
        this.setGetIndex(buffer.position());
        this.setPutIndex(buffer.limit());
        this._bytes = this._buf.array();
    }

    public ByteBuffer getByteBuffer() {
        return this._buf;
    }

    public boolean isDirect() {
        return false;
    }
}

