/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.io;

import org.mortbay.io.AbstractBuffer;
import org.mortbay.io.Buffer;

public class View
extends AbstractBuffer {
    Buffer _buffer;

    public View(Buffer buffer, int mark, int get2, int put2, int access) {
        super(2, !buffer.isImmutable());
        this._buffer = buffer.buffer();
        this.setPutIndex(put2);
        this.setGetIndex(get2);
        this.setMarkIndex(mark);
        this._access = access;
    }

    public View(Buffer buffer) {
        super(2, !buffer.isImmutable());
        this._buffer = buffer.buffer();
        this.setPutIndex(buffer.putIndex());
        this.setGetIndex(buffer.getIndex());
        this.setMarkIndex(buffer.markIndex());
        this._access = buffer.isReadOnly() ? 1 : 2;
    }

    public View() {
        super(2, true);
    }

    public void update(Buffer buffer) {
        this._access = 2;
        this._buffer = buffer.buffer();
        this.setGetIndex(0);
        this.setPutIndex(buffer.putIndex());
        this.setGetIndex(buffer.getIndex());
        this.setMarkIndex(buffer.markIndex());
        this._access = buffer.isReadOnly() ? 1 : 2;
    }

    public void update(int get2, int put2) {
        int a = this._access;
        this._access = 2;
        this.setGetIndex(0);
        this.setPutIndex(put2);
        this.setGetIndex(get2);
        this.setMarkIndex(-1);
        this._access = a;
    }

    public byte[] array() {
        return this._buffer.array();
    }

    public Buffer buffer() {
        return this._buffer.buffer();
    }

    public int capacity() {
        return this._buffer.capacity();
    }

    public void clear() {
        this.setMarkIndex(-1);
        this.setGetIndex(0);
        this.setPutIndex(this._buffer.getIndex());
        this.setGetIndex(this._buffer.getIndex());
    }

    public void compact() {
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof Buffer && ((Buffer)obj).equals(this) || super.equals(obj);
    }

    public boolean isReadOnly() {
        return this._buffer.isReadOnly();
    }

    public boolean isVolatile() {
        return true;
    }

    public byte peek(int index2) {
        return this._buffer.peek(index2);
    }

    public int peek(int index2, byte[] b, int offset, int length) {
        return this._buffer.peek(index2, b, offset, length);
    }

    public Buffer peek(int index2, int length) {
        return this._buffer.peek(index2, length);
    }

    public int poke(int index2, Buffer src) {
        return this._buffer.poke(index2, src);
    }

    public void poke(int index2, byte b) {
        this._buffer.poke(index2, b);
    }

    public int poke(int index2, byte[] b, int offset, int length) {
        return this._buffer.poke(index2, b, offset, length);
    }

    public String toString() {
        if (this._buffer == null) {
            return "INVALID";
        }
        return super.toString();
    }

    public static class CaseInsensitive
    extends View
    implements Buffer.CaseInsensitve {
        public CaseInsensitive() {
        }

        public CaseInsensitive(Buffer buffer, int mark, int get2, int put2, int access) {
            super(buffer, mark, get2, put2, access);
        }

        public CaseInsensitive(Buffer buffer) {
            super(buffer);
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof Buffer && ((Buffer)obj).equalsIgnoreCase(this) || super.equals(obj);
        }
    }
}

