/*
 * Decompiled with CFR 0.152.
 */
package org.joni.ast;

import java.util.Set;
import org.joni.UnsetAddrList;
import org.joni.WarnCallback;
import org.joni.ast.Node;
import org.joni.ast.StateNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CallNode
extends StateNode {
    public byte[] name;
    public int nameP;
    public int nameEnd;
    public int groupNum;
    public Node target;
    public UnsetAddrList unsetAddrList;

    public CallNode(byte[] name, int nameP, int nameEnd, int gnum) {
        this.name = name;
        this.nameP = nameP;
        this.nameEnd = nameEnd;
        this.groupNum = gnum;
    }

    @Override
    public int getType() {
        return 10;
    }

    @Override
    protected void setChild(Node newChild) {
        this.target = newChild;
    }

    @Override
    protected Node getChild() {
        return this.target;
    }

    public void setTarget(Node tgt) {
        this.target = tgt;
        tgt.parent = this;
    }

    @Override
    public String getName() {
        return "Call";
    }

    @Override
    public void verifyTree(Set<Node> set, WarnCallback warnings) {
        if (this.target == null || this.target.parent == this) {
            warnings.warn(this.getAddressName() + " doesn't point to a target or the target has been stolen");
        }
    }

    @Override
    public String toString(int level) {
        StringBuilder value2 = new StringBuilder(super.toString(level));
        value2.append("\n  name: " + new String(this.name, this.nameP, this.nameEnd - this.nameP));
        value2.append("\n  groupNum: " + this.groupNum);
        value2.append("\n  target: " + CallNode.pad(this.target.getAddressName(), level + 1));
        value2.append("\n  unsetAddrList: " + CallNode.pad(this.unsetAddrList, level + 1));
        return value2.toString();
    }
}

