/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import org.jcodings.Encoding;
import org.jcodings.IntHolder;
import org.joni.Regex;

public abstract class SearchAlgorithm {
    public static final SearchAlgorithm NONE = new SearchAlgorithm(){

        public final String getName() {
            return "NONE";
        }

        public final int search(Regex regex, byte[] text2, int textP, int textEnd, int textRange) {
            return textP;
        }

        public final int searchBackward(Regex regex, byte[] text2, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            return textP;
        }
    };
    public static final SearchAlgorithm SLOW = new SearchAlgorithm(){

        public final String getName() {
            return "EXACT";
        }

        public final int search(Regex regex, byte[] text2, int textP, int textEnd, int textRange) {
            Encoding enc = regex.enc;
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int end = textEnd;
            if ((end -= targetEnd - targetP - 1) > textRange) {
                end = textRange;
            }
            for (int s2 = textP; s2 < end; s2 += enc.length(text2, s2, textEnd)) {
                int t;
                if (text2[s2] != target[targetP]) continue;
                int p = s2 + 1;
                for (t = targetP + 1; t < targetEnd && target[t] == text2[p++]; ++t) {
                }
                if (t != targetEnd) continue;
                return s2;
            }
            return -1;
        }

        public final int searchBackward(Regex regex, byte[] text2, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            Encoding enc = regex.enc;
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int s2 = textEnd;
            s2 = (s2 -= targetEnd - targetP) > textStart ? textStart : enc.leftAdjustCharHead(text2, adjustText, s2, textEnd);
            while (s2 >= textP) {
                if (text2[s2] == target[targetP]) {
                    int t;
                    int p = s2 + 1;
                    for (t = targetP + 1; t < targetEnd && target[t] == text2[p++]; ++t) {
                    }
                    if (t == targetEnd) {
                        return s2;
                    }
                }
                s2 = enc.prevCharHead(text2, adjustText, s2, textEnd);
            }
            return -1;
        }
    };
    public static final SearchAlgorithm SLOW_SB = new SearchAlgorithm(){

        public final String getName() {
            return "EXACT_SB";
        }

        public final int search(Regex regex, byte[] text2, int textP, int textEnd, int textRange) {
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int end = textEnd;
            if ((end -= targetEnd - targetP - 1) > textRange) {
                end = textRange;
            }
            for (int s2 = textP; s2 < end; ++s2) {
                int t;
                if (text2[s2] != target[targetP]) continue;
                int p = s2 + 1;
                for (t = targetP + 1; t < targetEnd && target[t] == text2[p++]; ++t) {
                }
                if (t != targetEnd) continue;
                return s2;
            }
            return -1;
        }

        public final int searchBackward(Regex regex, byte[] text2, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int s2 = textEnd;
            if ((s2 -= targetEnd - targetP) > textStart) {
                s2 = textStart;
            }
            while (s2 >= textP) {
                if (text2[s2] == target[targetP]) {
                    int t;
                    int p = s2 + 1;
                    for (t = targetP + 1; t < targetEnd && target[t] == text2[p++]; ++t) {
                    }
                    if (t == targetEnd) {
                        return s2;
                    }
                }
                --s2;
            }
            return -1;
        }
    };
    public static final SearchAlgorithm SLOW_IC_SB = new SearchAlgorithm(){

        public final String getName() {
            return "EXACT_IC_SB";
        }

        public final int search(Regex regex, byte[] text2, int textP, int textEnd, int textRange) {
            byte[] toLowerTable = regex.enc.toLowerCaseTable();
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int end = textEnd;
            if ((end -= targetEnd - targetP - 1) > textRange) {
                end = textRange;
            }
            for (int s2 = textP; s2 < end; ++s2) {
                int t;
                if (target[targetP] != toLowerTable[text2[s2] & 0xFF]) continue;
                int p = s2 + 1;
                for (t = targetP + 1; t < targetEnd && target[t] == toLowerTable[text2[p++] & 0xFF]; ++t) {
                }
                if (t != targetEnd) continue;
                return s2;
            }
            return -1;
        }

        public final int searchBackward(Regex regex, byte[] text2, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            byte[] toLowerTable = regex.enc.toLowerCaseTable();
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int s2 = textEnd;
            if ((s2 -= targetEnd - targetP) > textStart) {
                s2 = textStart;
            }
            while (s2 >= textP) {
                if (target[targetP] == toLowerTable[text2[s2] & 0xFF]) {
                    int t;
                    int p = s2 + 1;
                    for (t = targetP + 1; t < targetEnd && target[t] == toLowerTable[text2[p++] & 0xFF]; ++t) {
                    }
                    if (t == targetEnd) {
                        return s2;
                    }
                }
                --s2;
            }
            return -1;
        }
    };
    public static final SearchAlgorithm BM = new SearchAlgorithm(){
        private static final int BM_BACKWARD_SEARCH_LENGTH_THRESHOLD = 100;

        public final String getName() {
            return "EXACT_BM";
        }

        public final int search(Regex regex, byte[] text2, int textP, int textEnd, int textRange) {
            int s2;
            byte[] target = regex.exact;
            int targetEnd = regex.exactEnd;
            int targetP = regex.exactP;
            int end = textRange + (targetEnd - targetP) - 1;
            if (end > textEnd) {
                end = textEnd;
            }
            int tail = targetEnd - 1;
            if (regex.intMap == null) {
                for (s2 = textP + (targetEnd - targetP) - 1; s2 < end; s2 += regex.map[text2[s2] & 0xFF]) {
                    int p = s2;
                    int t = tail;
                    while (text2[p] == target[t]) {
                        if (t == targetP) {
                            return p;
                        }
                        --p;
                        --t;
                    }
                }
            } else {
                while (s2 < end) {
                    int p = s2;
                    int t = tail;
                    while (text2[p] == target[t]) {
                        if (t == targetP) {
                            return p;
                        }
                        --p;
                        --t;
                    }
                    s2 += regex.intMap[text2[s2] & 0xFF];
                }
            }
            return -1;
        }

        public final int searchBackward(Regex regex, byte[] text2, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            int s2;
            Encoding enc = regex.enc;
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            if (regex.intMapBackward == null) {
                if (s_ - range_ < 100) {
                    return SLOW.searchBackward(regex, text2, textP, adjustText, textEnd, textStart, s_, range_);
                }
                this.setBmBackwardSkip(regex, target, targetP, targetEnd);
            }
            s2 = textStart < (s2 = textEnd - (targetEnd - targetP)) ? textStart : enc.leftAdjustCharHead(text2, adjustText, s2, textEnd);
            while (s2 >= textP) {
                int t;
                int p = s2;
                for (t = targetP; t < targetEnd && text2[p] == target[t]; ++t) {
                    ++p;
                }
                if (t == targetEnd) {
                    return s2;
                }
                s2 -= regex.intMapBackward[text2[s2] & 0xFF];
                s2 = enc.leftAdjustCharHead(text2, adjustText, s2, textEnd);
            }
            return -1;
        }

        private void setBmBackwardSkip(Regex regex, byte[] bytes, int p, int end) {
            int i;
            int[] skip;
            if (regex.intMapBackward == null) {
                skip = new int[256];
                regex.intMapBackward = skip;
            } else {
                skip = regex.intMapBackward;
            }
            int len = end - p;
            for (i = 0; i < 256; ++i) {
                skip[i] = len;
            }
            for (i = len - 1; i > 0; --i) {
                skip[bytes[i] & 0xFF] = i;
            }
        }
    };
    public static final SearchAlgorithm BM_NOT_REV = new SearchAlgorithm(){

        public final String getName() {
            return "EXACT_BM_NOT_REV";
        }

        public final int search(Regex regex, byte[] text2, int textP, int textEnd, int textRange) {
            Encoding enc = regex.enc;
            byte[] target = regex.exact;
            int end = textRange;
            int targetEnd = regex.exactEnd;
            int tail = targetEnd - 1;
            int targetP = regex.exactP;
            int tlen1 = tail - targetP;
            if (end + tlen1 > textEnd) {
                end = textEnd - tlen1;
            }
            int s2 = textP;
            if (regex.intMap == null) {
                while (s2 < end) {
                    int se;
                    int p = se = s2 + tlen1;
                    int t = tail;
                    while (text2[p] == target[t]) {
                        if (t == targetP) {
                            return s2;
                        }
                        --p;
                        --t;
                    }
                    byte skip = regex.map[text2[se] & 0xFF];
                    t = s2;
                    while ((s2 += enc.length(text2, s2, textEnd)) - t < skip && s2 < end) {
                    }
                }
            } else {
                while (s2 < end) {
                    int se;
                    int p = se = s2 + tlen1;
                    int t = tail;
                    while (text2[p] == target[t]) {
                        if (t == targetP) {
                            return s2;
                        }
                        --p;
                        --t;
                    }
                    int skip = regex.intMap[text2[se] & 0xFF];
                    t = s2;
                    while ((s2 += enc.length(text2, s2, textEnd)) - t < skip && s2 < end) {
                    }
                }
            }
            return -1;
        }

        public final int searchBackward(Regex regex, byte[] text2, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            return BM.searchBackward(regex, text2, textP, adjustText, textEnd, textStart, s_, range_);
        }
    };
    public static final SearchAlgorithm MAP = new SearchAlgorithm(){

        public final String getName() {
            return "MAP";
        }

        public final int search(Regex regex, byte[] text2, int textP, int textEnd, int textRange) {
            Encoding enc = regex.enc;
            byte[] map2 = regex.map;
            for (int s2 = textP; s2 < textRange; s2 += enc.length(text2, s2, textEnd)) {
                if (map2[text2[s2] & 0xFF] == 0) continue;
                return s2;
            }
            return -1;
        }

        public final int searchBackward(Regex regex, byte[] text2, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            Encoding enc = regex.enc;
            byte[] map2 = regex.map;
            int s2 = textStart;
            if (s2 >= textEnd) {
                s2 = textEnd - 1;
            }
            while (s2 >= textP) {
                if (map2[text2[s2] & 0xFF] != 0) {
                    return s2;
                }
                s2 = enc.prevCharHead(text2, adjustText, s2, textEnd);
            }
            return -1;
        }
    };
    public static final SearchAlgorithm MAP_SB = new SearchAlgorithm(){

        public final String getName() {
            return "MAP_SB";
        }

        public final int search(Regex regex, byte[] text2, int textP, int textEnd, int textRange) {
            byte[] map2 = regex.map;
            for (int s2 = textP; s2 < textRange; ++s2) {
                if (map2[text2[s2] & 0xFF] == 0) continue;
                return s2;
            }
            return -1;
        }

        public final int searchBackward(Regex regex, byte[] text2, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            byte[] map2 = regex.map;
            int s2 = textStart;
            if (s2 >= textEnd) {
                s2 = textEnd - 1;
            }
            while (s2 >= textP) {
                if (map2[text2[s2] & 0xFF] != 0) {
                    return s2;
                }
                --s2;
            }
            return -1;
        }
    };

    public abstract String getName();

    public abstract int search(Regex var1, byte[] var2, int var3, int var4, int var5);

    public abstract int searchBackward(Regex var1, byte[] var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public static final class SLOW_IC
    extends SearchAlgorithm {
        private final byte[] buf = new byte[18];
        private final IntHolder holder = new IntHolder();
        private final int caseFoldFlag;
        private final Encoding enc;

        public SLOW_IC(Regex regex) {
            this.caseFoldFlag = regex.caseFoldFlag;
            this.enc = regex.enc;
        }

        public final String getName() {
            return "EXACT_IC";
        }

        public final int search(Regex regex, byte[] text2, int textP, int textEnd, int textRange) {
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int end = textEnd;
            if ((end -= targetEnd - targetP - 1) > textRange) {
                end = textRange;
            }
            for (int s2 = textP; s2 < end; s2 += this.enc.length(text2, s2, textEnd)) {
                if (!this.lowerCaseMatch(target, targetP, targetEnd, text2, s2, textEnd)) continue;
                return s2;
            }
            return -1;
        }

        public final int searchBackward(Regex regex, byte[] text2, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int s2 = textEnd;
            s2 = (s2 -= targetEnd - targetP) > textStart ? textStart : this.enc.leftAdjustCharHead(text2, adjustText, s2, textEnd);
            while (s2 >= textP) {
                if (this.lowerCaseMatch(target, targetP, targetEnd, text2, s2, textEnd)) {
                    return s2;
                }
                s2 = this.enc.prevCharHead(text2, adjustText, s2, textEnd);
            }
            return -1;
        }

        private boolean lowerCaseMatch(byte[] t, int tP, int tEnd, byte[] bytes, int p, int end) {
            this.holder.value = p;
            while (tP < tEnd) {
                int lowlen = this.enc.mbcCaseFold(this.caseFoldFlag, bytes, this.holder, end, this.buf);
                if (lowlen == 1) {
                    if (t[tP++] == this.buf[0]) continue;
                    return false;
                }
                int q = 0;
                while (lowlen > 0) {
                    if (t[tP++] != this.buf[q++]) {
                        return false;
                    }
                    --lowlen;
                }
            }
            return true;
        }
    }
}

