/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import org.jcodings.Encoding;
import org.joni.MinMaxLen;
import org.joni.OptAnchorInfo;
import org.joni.OptEnvironment;
import org.joni.OptMapInfo;

final class OptExactInfo {
    static final int OPT_EXACT_MAXLEN = 24;
    final MinMaxLen mmd = new MinMaxLen();
    final OptAnchorInfo anchor = new OptAnchorInfo();
    boolean reachEnd;
    boolean ignoreCase;
    final byte[] bytes = new byte[24];
    int length;
    private static final int COMP_EM_BASE = 20;

    OptExactInfo() {
    }

    boolean isFull() {
        return this.length >= 24;
    }

    void clear() {
        this.mmd.clear();
        this.anchor.clear();
        this.reachEnd = false;
        this.ignoreCase = false;
        this.length = 0;
    }

    void copy(OptExactInfo other) {
        this.mmd.copy(other.mmd);
        this.anchor.copy(other.anchor);
        this.reachEnd = other.reachEnd;
        this.ignoreCase = other.ignoreCase;
        this.length = other.length;
        System.arraycopy(other.bytes, 0, this.bytes, 0, 24);
    }

    void concat(OptExactInfo other, Encoding enc) {
        int len;
        if (!this.ignoreCase && other.ignoreCase) {
            if (this.length >= other.length) {
                return;
            }
            this.ignoreCase = true;
        }
        int p = 0;
        int end = p + other.length;
        int i = this.length;
        while (p < end && i + (len = enc.length(other.bytes, p, end)) <= 24) {
            for (int j = 0; j < len && p < end; ++j) {
                this.bytes[i++] = other.bytes[p++];
            }
        }
        this.length = i;
        this.reachEnd = p == end ? other.reachEnd : false;
        OptAnchorInfo tmp = new OptAnchorInfo();
        tmp.concat(this.anchor, other.anchor, 1, 1);
        if (!other.reachEnd) {
            tmp.rightAnchor = 0;
        }
        this.anchor.copy(tmp);
    }

    void concatStr(byte[] lbytes, int p, int end, boolean raw2, Encoding enc) {
        int len;
        int i = this.length;
        while (p < end && i < 24 && i + (len = enc.length(lbytes, p, end)) <= 24) {
            for (int j = 0; j < len && p < end; ++j) {
                this.bytes[i++] = lbytes[p++];
            }
        }
        this.length = i;
    }

    void altMerge(OptExactInfo other, OptEnvironment env) {
        int i;
        int len;
        if (other.length == 0 || this.length == 0) {
            this.clear();
            return;
        }
        if (!this.mmd.equal(other.mmd)) {
            this.clear();
            return;
        }
        for (i = 0; i < this.length && i < other.length && this.bytes[i] == other.bytes[i]; i += len) {
            int j;
            len = env.enc.length(this.bytes, i, this.length);
            for (j = 1; j < len && this.bytes[i + j] == other.bytes[i + j]; ++j) {
            }
            if (j < len) break;
        }
        if (!other.reachEnd || i < other.length || i < this.length) {
            this.reachEnd = false;
        }
        this.length = i;
        this.ignoreCase |= other.ignoreCase;
        this.anchor.altMerge(other.anchor);
        if (!this.reachEnd) {
            this.anchor.rightAnchor = 0;
        }
    }

    void select(OptExactInfo alt, Encoding enc) {
        int v1 = this.length;
        int v2 = alt.length;
        if (v2 == 0) {
            return;
        }
        if (v1 == 0) {
            this.copy(alt);
            return;
        }
        if (v1 <= 2 && v2 <= 2) {
            v2 = OptMapInfo.positionValue(enc, this.bytes[0] & 0xFF);
            v1 = OptMapInfo.positionValue(enc, alt.bytes[0] & 0xFF);
            if (this.length > 1) {
                v1 += 5;
            }
            if (alt.length > 1) {
                v2 += 5;
            }
        }
        if (!this.ignoreCase) {
            v1 *= 2;
        }
        if (!alt.ignoreCase) {
            v2 *= 2;
        }
        if (this.mmd.compareDistanceValue(alt.mmd, v1, v2) > 0) {
            this.copy(alt);
        }
    }

    int compare(OptMapInfo m) {
        if (m.value <= 0) {
            return -1;
        }
        int ve = 20 * this.length * (this.ignoreCase ? 1 : 2);
        int vm = 200 / m.value;
        return this.mmd.compareDistanceValue(m.mmd, ve, vm);
    }
}

