/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings.util;

import org.jcodings.util.Hash;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntArrayHash<V>
extends Hash<V> {
    public IntArrayHash() {
    }

    public IntArrayHash(int size2) {
        super(size2);
    }

    @Override
    protected void init() {
        this.head = new IntArrayHashEntry();
    }

    private int hashCode(int[] key) {
        switch (key.length) {
            case 1: {
                return key[0];
            }
            case 2: {
                return key[0] + key[1];
            }
            case 3: {
                return key[0] + key[1] + key[2];
            }
            case 4: {
                return key[0] + key[1] + key[2] + key[3];
            }
        }
        int h = 0;
        for (int i = 0; i < key.length; ++i) {
            h += key[i];
        }
        return h;
    }

    public V put(int[] key, V value2) {
        this.checkResize();
        int hash = IntArrayHash.hashValue(this.hashCode(key));
        int i = IntArrayHash.bucketIndex(hash, this.table.length);
        IntArrayHashEntry entry2 = (IntArrayHashEntry)this.table[i];
        while (entry2 != null) {
            if (entry2.hash == hash && entry2.equals(key)) {
                entry2.value = value2;
                return value2;
            }
            entry2 = (IntArrayHashEntry)entry2.next;
        }
        this.table[i] = new IntArrayHashEntry<V>(hash, this.table[i], value2, key, this.head);
        ++this.size;
        return null;
    }

    public void putDirect(int[] key, V value2) {
        this.checkResize();
        int hash = IntArrayHash.hashValue(this.hashCode(key));
        int i = IntArrayHash.bucketIndex(hash, this.table.length);
        this.table[i] = new IntArrayHashEntry<V>(hash, this.table[i], value2, key, this.head);
        ++this.size;
    }

    public V get(int ... key) {
        int hash = IntArrayHash.hashValue(this.hashCode(key));
        IntArrayHashEntry entry2 = (IntArrayHashEntry)this.table[IntArrayHash.bucketIndex(hash, this.table.length)];
        while (entry2 != null) {
            if (entry2.hash == hash && entry2.equals(key)) {
                return (V)entry2.value;
            }
            entry2 = (IntArrayHashEntry)entry2.next;
        }
        return null;
    }

    public V delete(int ... key) {
        int hash = IntArrayHash.hashValue(this.hashCode(key));
        int i = IntArrayHash.bucketIndex(hash, this.table.length);
        IntArrayHashEntry entry2 = (IntArrayHashEntry)this.table[i];
        if (entry2 == null) {
            return null;
        }
        if (entry2.hash == hash && entry2.equals(key)) {
            this.table[i] = entry2.next;
            --this.size;
            entry2.remove();
            return (V)entry2.value;
        }
        while (entry2.next != null) {
            Hash.HashEntry tmp = entry2.next;
            if (tmp.hash == hash && entry2.equals(key)) {
                entry2.next = entry2.next.next;
                --this.size;
                tmp.remove();
                return tmp.value;
            }
            entry2 = (IntArrayHashEntry)entry2.next;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IntArrayHashEntry<V>
    extends Hash.HashEntry<V> {
        public final int[] key;

        public IntArrayHashEntry(int hash, Hash.HashEntry<V> next2, V value2, int[] key, Hash.HashEntry<V> head2) {
            super(hash, next2, value2, head2);
            this.key = key;
        }

        public IntArrayHashEntry() {
            this.key = null;
        }

        public boolean equals(int[] key) {
            if (this.key == key) {
                return true;
            }
            if (this.key.length != key.length) {
                return false;
            }
            switch (key.length) {
                case 1: {
                    return this.key[0] == key[0];
                }
                case 2: {
                    return this.key[0] == key[0] && this.key[1] == key[1];
                }
                case 3: {
                    return this.key[0] == key[0] && this.key[1] == key[1] && this.key[2] == key[2];
                }
                case 4: {
                    return this.key[0] == key[0] && this.key[1] == key[1] && this.key[2] == key[2] && this.key[3] == key[3];
                }
            }
            for (int i = 0; i < key.length; ++i) {
                if (this.key[i] == key[i]) continue;
                return false;
            }
            return true;
        }
    }
}

