/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings.util;

import org.jcodings.util.Hash;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BytesHash<V>
extends Hash<V> {
    public BytesHash() {
    }

    public BytesHash(int size2) {
        super(size2);
    }

    @Override
    protected void init() {
        this.head = new BytesHashEntry();
    }

    public static int hashCode(byte[] bytes, int p, int end) {
        int key = 0;
        while (p < end) {
            key = (key << 16) + (key << 6) - key + bytes[p++];
        }
        key += key >> 5;
        return key;
    }

    public V put(byte[] bytes, V value2) {
        return this.put(bytes, 0, bytes.length, value2);
    }

    public V put(byte[] bytes, int p, int end, V value2) {
        this.checkResize();
        int hash = BytesHash.hashValue(BytesHash.hashCode(bytes, p, end));
        int i = BytesHash.bucketIndex(hash, this.table.length);
        BytesHashEntry entry2 = (BytesHashEntry)this.table[i];
        while (entry2 != null) {
            if (entry2.hash == hash && entry2.equals(bytes, p, end)) {
                entry2.value = value2;
                return value2;
            }
            entry2 = (BytesHashEntry)entry2.next;
        }
        this.table[i] = new BytesHashEntry<V>(hash, this.table[i], value2, bytes, p, end, this.head);
        ++this.size;
        return null;
    }

    public void putDirect(byte[] bytes, V value2) {
        this.putDirect(bytes, 0, bytes.length, value2);
    }

    public void putDirect(byte[] bytes, int p, int end, V value2) {
        this.checkResize();
        int hash = BytesHash.hashValue(BytesHash.hashCode(bytes, p, end));
        int i = BytesHash.bucketIndex(hash, this.table.length);
        this.table[i] = new BytesHashEntry<V>(hash, this.table[i], value2, bytes, p, end, this.head);
        ++this.size;
    }

    public V get(byte[] bytes) {
        return this.get(bytes, 0, bytes.length);
    }

    public V get(byte[] bytes, int p, int end) {
        int hash = BytesHash.hashValue(BytesHash.hashCode(bytes, p, end));
        BytesHashEntry entry2 = (BytesHashEntry)this.table[BytesHash.bucketIndex(hash, this.table.length)];
        while (entry2 != null) {
            if (entry2.hash == hash && entry2.equals(bytes, p, end)) {
                return (V)entry2.value;
            }
            entry2 = (BytesHashEntry)entry2.next;
        }
        return null;
    }

    public V delete(byte[] bytes) {
        return this.delete(bytes, 0, bytes.length);
    }

    public V delete(byte[] bytes, int p, int end) {
        int hash = BytesHash.hashValue(BytesHash.hashCode(bytes, p, end));
        int i = BytesHash.bucketIndex(hash, this.table.length);
        BytesHashEntry entry2 = (BytesHashEntry)this.table[i];
        if (entry2 == null) {
            return null;
        }
        if (entry2.hash == hash && entry2.equals(bytes, p, end)) {
            this.table[i] = entry2.next;
            --this.size;
            entry2.remove();
            return (V)entry2.value;
        }
        while (entry2.next != null) {
            Hash.HashEntry tmp = entry2.next;
            if (tmp.hash == hash && entry2.equals(bytes, p, end)) {
                entry2.next = entry2.next.next;
                --this.size;
                tmp.remove();
                return tmp.value;
            }
            entry2 = (BytesHashEntry)entry2.next;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class BytesHashEntry<V>
    extends Hash.HashEntry<V> {
        public final byte[] bytes;
        public final int p;
        public final int end;

        public BytesHashEntry(int hash, Hash.HashEntry<V> next2, V value2, byte[] bytes, int p, int end, Hash.HashEntry<V> head2) {
            super(hash, next2, value2, head2);
            this.bytes = bytes;
            this.p = p;
            this.end = end;
        }

        public BytesHashEntry() {
            this.bytes = null;
            this.end = 0;
            this.p = 0;
        }

        public boolean equals(byte[] bytes, int p, int end) {
            if (this.end - this.p != end - p) {
                return false;
            }
            if (this.bytes == bytes) {
                return true;
            }
            int q = this.p;
            while (q < this.end) {
                if (this.bytes[q++] == bytes[p++]) continue;
                return false;
            }
            return true;
        }
    }
}

