/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings.unicode;

import org.jcodings.IntHolder;
import org.jcodings.unicode.UnicodeEncoding;

public abstract class FixedWidthUnicodeEncoding
extends UnicodeEncoding {
    protected final int shift;

    protected FixedWidthUnicodeEncoding(String name, int width) {
        super(name, width, width, (int[])null);
        this.shift = FixedWidthUnicodeEncoding.log2(width);
    }

    public final int length(byte c) {
        return this.minLength;
    }

    public final int length(byte[] bytes, int p, int end) {
        return this.minLength;
    }

    public final int strLength(byte[] bytes, int p, int end) {
        return end - p >>> this.shift;
    }

    public final int strCodeAt(byte[] bytes, int p, int end, int index2) {
        return this.mbcToCode(bytes, p + (index2 << this.shift), end);
    }

    public final int codeToMbcLength(int code) {
        return this.minLength;
    }

    public final int[] ctypeCodeRange(int ctype, IntHolder sbOut) {
        sbOut.value = 0;
        return super.ctypeCodeRange(ctype);
    }

    public final int leftAdjustCharHead(byte[] bytes, int p, int s2, int end) {
        if (s2 <= p) {
            return s2;
        }
        return s2 - (s2 - p) % this.maxLength;
    }

    public final boolean isReverseMatchAllowed(byte[] bytes, int p, int end) {
        return false;
    }

    private static int log2(int n) {
        int log2 = 0;
        while ((n >>>= 1) != 0) {
            ++log2;
        }
        return log2;
    }
}

