/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.spdy;

import java.nio.ByteOrder;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.spdy.SpdyHeaderBlockEncoder;
import org.jboss.netty.handler.codec.spdy.SpdyHeadersFrame;
import org.jboss.netty.handler.codec.spdy.SpdyVersion;

public class SpdyHeaderBlockRawEncoder
extends SpdyHeaderBlockEncoder {
    private final int version;

    public SpdyHeaderBlockRawEncoder(SpdyVersion spdyVersion) {
        if (spdyVersion == null) {
            throw new NullPointerException("spdyVersion");
        }
        this.version = spdyVersion.getVersion();
    }

    private void setLengthField(ChannelBuffer buffer, int writerIndex, int length) {
        buffer.setInt(writerIndex, length);
    }

    private void writeLengthField(ChannelBuffer buffer, int length) {
        buffer.writeInt(length);
    }

    public ChannelBuffer encode(SpdyHeadersFrame headerFrame) throws Exception {
        Set<String> names = headerFrame.headers().names();
        int numHeaders = names.size();
        if (numHeaders == 0) {
            return ChannelBuffers.EMPTY_BUFFER;
        }
        if (numHeaders > 65535) {
            throw new IllegalArgumentException("header block contains too many headers");
        }
        ChannelBuffer headerBlock = ChannelBuffers.dynamicBuffer(ByteOrder.BIG_ENDIAN, 256);
        this.writeLengthField(headerBlock, numHeaders);
        for (String name : names) {
            byte[] nameBytes = name.getBytes("UTF-8");
            this.writeLengthField(headerBlock, nameBytes.length);
            headerBlock.writeBytes(nameBytes);
            int savedIndex = headerBlock.writerIndex();
            int valueLength = 0;
            this.writeLengthField(headerBlock, valueLength);
            for (String value2 : headerFrame.headers().getAll(name)) {
                byte[] valueBytes = value2.getBytes("UTF-8");
                if (valueBytes.length <= 0) continue;
                headerBlock.writeBytes(valueBytes);
                headerBlock.writeByte(0);
                valueLength += valueBytes.length + 1;
            }
            if (valueLength != 0) {
                --valueLength;
            }
            if (valueLength > 65535) {
                throw new IllegalArgumentException("header exceeds allowable length: " + name);
            }
            if (valueLength <= 0) continue;
            this.setLengthField(headerBlock, savedIndex, valueLength);
            headerBlock.writerIndex(headerBlock.writerIndex() - 1);
        }
        return headerBlock;
    }

    void end() {
    }
}

