/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import java.text.ParseException;
import java.util.Collection;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.Cookie;
import org.glassfish.grizzly.http.LazyCookie;
import org.glassfish.grizzly.http.util.Ascii;
import org.glassfish.grizzly.http.util.BufferChunk;
import org.glassfish.grizzly.http.util.CharChunk;
import org.glassfish.grizzly.http.util.Charsets;
import org.glassfish.grizzly.http.util.CookieUtils;
import org.glassfish.grizzly.http.util.DataChunk;

public class CookieParserUtils {
    private static final Logger LOGGER = Grizzly.logger(CookieParserUtils.class);

    public static void parseClientCookies(Collection<Cookie> cookies, Buffer buffer, int off, int len) {
        CookieParserUtils.parseClientCookies(cookies, buffer, off, len, CookieUtils.COOKIE_VERSION_ONE_STRICT_COMPLIANCE);
    }

    /*
     * Unable to fully structure code
     */
    public static void parseClientCookies(Collection<Cookie> cookies, Buffer buffer, int off, int len, boolean versionOneStrictCompliance) {
        if (len <= 0 || buffer == null) {
            throw new IllegalArgumentException();
        }
        end = off + len;
        pos = off;
        version = 0;
        cookie = null;
        lazyCookie = null;
        while (pos < end) {
            block24: {
                block23: {
                    isSpecial = false;
                    isQuoted = false;
                    while (pos < end && (CookieUtils.isSeparator(buffer.get(pos)) || CookieUtils.isWhiteSpace(buffer.get(pos)))) {
                        ++pos;
                    }
                    if (pos >= end) {
                        return;
                    }
                    if (buffer.get(pos) == 36) {
                        isSpecial = true;
                    }
                    valueStart = nameStart = ++pos;
                    valueEnd = nameStart;
                    for (pos = nameEnd = CookieUtils.getTokenEndPosition(buffer, pos, end); pos < end && CookieUtils.isWhiteSpace(buffer.get(pos)); ++pos) {
                    }
                    if (pos >= end || buffer.get(pos) != 61) break block23;
                    while (++pos < end && CookieUtils.isWhiteSpace(buffer.get(pos))) {
                    }
                    if (pos >= end) {
                        return;
                    }
                    switch (buffer.get(pos)) {
                        case 34: {
                            isQuoted = true;
                            valueStart = pos + 1;
                            pos = valueEnd = CookieUtils.getQuotedValueEndPosition(buffer, valueStart, end);
                            if (pos >= end) {
                                return;
                            }
                            break block24;
                        }
                        case 44: 
                        case 59: {
                            valueEnd = -1;
                            valueStart = -1;
                            break block24;
                        }
                        default: {
                            if (CookieUtils.isSeparator(buffer.get(pos), versionOneStrictCompliance)) ** GOTO lbl44
                            valueStart = pos;
                            pos = valueEnd = CookieUtils.getTokenEndPosition(buffer, valueStart, end, versionOneStrictCompliance);
                            break block24;
lbl44:
                            // 1 sources

                            CookieParserUtils.LOGGER.fine("Invalid cookie. Value not a token or quoted value");
                            while (pos < end && buffer.get(pos) != 59 && buffer.get(pos) != 44) {
                                ++pos;
                            }
                            ++pos;
                            cookie = null;
                            lazyCookie = null;
                            break;
                        }
                    }
                    continue;
                }
                valueEnd = -1;
                valueStart = -1;
                pos = nameEnd;
            }
            while (pos < end && CookieUtils.isWhiteSpace(buffer.get(pos))) {
                ++pos;
            }
            while (pos < end && buffer.get(pos) != 59 && buffer.get(pos) != 44) {
                ++pos;
            }
            ++pos;
            if (isSpecial) {
                isSpecial = false;
                if (CookieUtils.equals("Version", buffer, nameStart, nameEnd) && cookie == null) {
                    if (buffer.get(valueStart) != 49 || valueEnd != valueStart + 1) continue;
                    version = 1;
                    continue;
                }
                if (cookie == null) continue;
                if (CookieUtils.equals("Domain", buffer, nameStart, nameEnd)) {
                    lazyCookie.getDomain().setBuffer(buffer, valueStart, valueEnd);
                    continue;
                }
                if (CookieUtils.equals("Path", buffer, nameStart, nameEnd)) {
                    lazyCookie.getPath().setBuffer(buffer, valueStart, valueEnd);
                    continue;
                }
                if (CookieUtils.equals("Port", buffer, nameStart, nameEnd)) continue;
                CookieParserUtils.LOGGER.fine("Unknown Special Cookie");
                continue;
            }
            cookie = new LazyCookie();
            lazyCookie = cookie.lazy();
            cookie.setVersion(version);
            lazyCookie.getName().setBuffer(buffer, nameStart, nameEnd);
            if (valueStart != -1) {
                lazyCookie.getValue().setBuffer(buffer, valueStart, valueEnd);
                if (isQuoted) {
                    CookieParserUtils.unescapeDoubleQuotes(lazyCookie.getValue());
                }
            } else {
                lazyCookie.getValue().setString("");
            }
            cookies.add(cookie);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void parseClientCookies(Collection<Cookie> cookies, String cookiesStr, boolean versionOneStrictCompliance) {
        if (cookiesStr == null) {
            throw new IllegalArgumentException();
        }
        end = cookiesStr.length();
        pos = 0;
        version = 0;
        cookie = null;
        while (pos < end) {
            block21: {
                block20: {
                    isSpecial = false;
                    isQuoted = false;
                    while (pos < end && (CookieUtils.isSeparator(cookiesStr.charAt(pos)) || CookieUtils.isWhiteSpace(cookiesStr.charAt(pos)))) {
                        ++pos;
                    }
                    if (pos >= end) {
                        return;
                    }
                    if (cookiesStr.charAt(pos) == '$') {
                        isSpecial = true;
                    }
                    valueStart = nameStart = ++pos;
                    valueEnd = nameStart;
                    for (pos = nameEnd = CookieUtils.getTokenEndPosition(cookiesStr, pos, end); pos < end && CookieUtils.isWhiteSpace(cookiesStr.charAt(pos)); ++pos) {
                    }
                    if (pos >= end || cookiesStr.charAt(pos) != '=') break block20;
                    while (++pos < end && CookieUtils.isWhiteSpace(cookiesStr.charAt(pos))) {
                    }
                    if (pos >= end) {
                        return;
                    }
                    switch (cookiesStr.charAt(pos)) {
                        case '\"': {
                            isQuoted = true;
                            valueStart = pos + 1;
                            pos = valueEnd = CookieUtils.getQuotedValueEndPosition(cookiesStr, valueStart, end);
                            if (pos >= end) {
                                return;
                            }
                            break block21;
                        }
                        case ',': 
                        case ';': {
                            valueEnd = -1;
                            valueStart = -1;
                            break block21;
                        }
                        default: {
                            if (CookieUtils.isSeparator(cookiesStr.charAt(pos), versionOneStrictCompliance)) ** GOTO lbl43
                            valueStart = pos;
                            pos = valueEnd = CookieUtils.getTokenEndPosition(cookiesStr, valueStart, end, versionOneStrictCompliance);
                            break block21;
lbl43:
                            // 1 sources

                            CookieParserUtils.LOGGER.fine("Invalid cookie. Value not a token or quoted value");
                            while (pos < end && cookiesStr.charAt(pos) != ';' && cookiesStr.charAt(pos) != ',') {
                                ++pos;
                            }
                            ++pos;
                            cookie = null;
                            break;
                        }
                    }
                    continue;
                }
                valueEnd = -1;
                valueStart = -1;
                pos = nameEnd;
            }
            while (pos < end && CookieUtils.isWhiteSpace(cookiesStr.charAt(pos))) {
                ++pos;
            }
            while (pos < end && cookiesStr.charAt(pos) != ';' && cookiesStr.charAt(pos) != ',') {
                ++pos;
            }
            ++pos;
            if (isSpecial) {
                isSpecial = false;
                if (CookieUtils.equals("Version", cookiesStr, nameStart, nameEnd) && cookie == null) {
                    if (cookiesStr.charAt(valueStart) != '1' || valueEnd != valueStart + 1) continue;
                    version = 1;
                    continue;
                }
                if (cookie == null) continue;
                if (CookieUtils.equals("Domain", cookiesStr, nameStart, nameEnd)) {
                    cookie.setDomain(cookiesStr.substring(valueStart, valueEnd));
                    continue;
                }
                if (CookieUtils.equals("Path", cookiesStr, nameStart, nameEnd)) {
                    cookie.setPath(cookiesStr.substring(valueStart, valueEnd));
                    continue;
                }
                if (CookieUtils.equals("Port", cookiesStr, nameStart, nameEnd)) continue;
                CookieParserUtils.LOGGER.fine("Unknown Special Cookie");
                continue;
            }
            name = cookiesStr.substring(nameStart, nameEnd);
            value = valueStart != -1 ? (isQuoted ? CookieParserUtils.unescapeDoubleQuotes(cookiesStr, valueStart, valueEnd - valueStart) : cookiesStr.substring(valueStart, valueEnd)) : "";
            cookie = new Cookie(name, value);
            cookie.setVersion(version);
            cookies.add(cookie);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void parseServerCookies(Collection<Cookie> cookies, Buffer buffer, int off, int len, boolean versionOneStrictCompliance) {
        if (len <= 0 || buffer == null) {
            throw new IllegalArgumentException();
        }
        end = off + len;
        pos = off;
        cookie = null;
        lazyCookie = null;
        while (pos < end) {
            block30: {
                block29: {
                    isQuoted = false;
                    while (pos < end && (CookieUtils.isSeparator(buffer.get(pos)) || CookieUtils.isWhiteSpace(buffer.get(pos)))) {
                        ++pos;
                    }
                    if (pos >= end) {
                        return;
                    }
                    valueStart = nameStart = pos;
                    valueEnd = nameStart;
                    for (pos = nameEnd = CookieUtils.getTokenEndPosition(buffer, pos, end); pos < end && CookieUtils.isWhiteSpace(buffer.get(pos)); ++pos) {
                    }
                    if (pos >= end || buffer.get(pos) != 61) break block29;
                    while (++pos < end && CookieUtils.isWhiteSpace(buffer.get(pos))) {
                    }
                    if (pos >= end) {
                        return;
                    }
                    switch (buffer.get(pos)) {
                        case 34: {
                            isQuoted = true;
                            valueStart = pos + 1;
                            pos = valueEnd = CookieUtils.getQuotedValueEndPosition(buffer, valueStart, end);
                            if (pos >= end) {
                                return;
                            }
                            break block30;
                        }
                        case 44: 
                        case 59: {
                            valueEnd = -1;
                            valueStart = -1;
                            break block30;
                        }
                        default: {
                            if (CookieUtils.isSeparator(buffer.get(pos), versionOneStrictCompliance)) ** GOTO lbl40
                            valueStart = pos;
                            pos = valueEnd = CookieUtils.getTokenEndPosition(buffer, valueStart, end, versionOneStrictCompliance);
                            break block30;
lbl40:
                            // 1 sources

                            CookieParserUtils.LOGGER.fine("Invalid cookie. Value not a token or quoted value");
                            while (pos < end && buffer.get(pos) != 59 && buffer.get(pos) != 44) {
                                ++pos;
                            }
                            ++pos;
                            cookie = null;
                            lazyCookie = null;
                            break;
                        }
                    }
                    continue;
                }
                valueEnd = -1;
                valueStart = -1;
                pos = nameEnd;
            }
            while (pos < end && CookieUtils.isWhiteSpace(buffer.get(pos))) {
                ++pos;
            }
            while (pos < end && buffer.get(pos) != 59 && buffer.get(pos) != 44) {
                ++pos;
            }
            ++pos;
            if (cookie != null) {
                if (lazyCookie.getDomain().isNull() && CookieUtils.equalsIgnoreCase("Domain", buffer, nameStart, nameEnd)) {
                    lazyCookie.getDomain().setBuffer(buffer, valueStart, valueEnd);
                    continue;
                }
                if (lazyCookie.getPath().isNull() && CookieUtils.equalsIgnoreCase("Path", buffer, nameStart, nameEnd)) {
                    lazyCookie.getPath().setBuffer(buffer, valueStart, valueEnd);
                    continue;
                }
                if (cookie.getVersion() == 0 && CookieUtils.equals("Version", buffer, nameStart, nameEnd)) {
                    if (buffer.get(valueStart) != 49 || valueEnd != valueStart + 1) continue;
                    cookie.setVersion(1);
                    continue;
                }
                if (lazyCookie.getComment().isNull() && CookieUtils.equals("Comment", buffer, nameStart, nameEnd)) {
                    lazyCookie.getComment().setBuffer(buffer, valueStart, valueEnd);
                    continue;
                }
                if (cookie.getMaxAge() == -1 && CookieUtils.equals("Max-Age", buffer, nameStart, nameEnd)) {
                    cookie.setMaxAge(Ascii.parseInt(buffer, valueStart, valueEnd - valueStart));
                    continue;
                }
                if (cookie.getVersion() == 0 && cookie.getMaxAge() == -1 && CookieUtils.equalsIgnoreCase("Expires", buffer, nameStart, nameEnd)) {
                    try {
                        valueEnd = CookieUtils.getTokenEndPosition(buffer, valueEnd + 1, end, false);
                        pos = valueEnd + 1;
                        expiresDate = buffer.toStringContent(Charsets.ASCII_CHARSET, valueStart, valueEnd);
                        date = CookieUtils.OLD_COOKIE_FORMAT.get().parse(expiresDate);
                        cookie.setMaxAge((int)(date.getTime() - System.currentTimeMillis()));
                    }
                    catch (ParseException ignore) {}
                    continue;
                }
                if (!cookie.isSecure() && CookieUtils.equalsIgnoreCase("Secure", buffer, nameStart, nameEnd)) {
                    lazyCookie.setSecure(true);
                    continue;
                }
                if (!cookie.isHttpOnly() && CookieUtils.equals("HttpOnly", buffer, nameStart, nameEnd)) {
                    cookie.setHttpOnly(true);
                    continue;
                }
                if (CookieUtils.equals("Port", buffer, nameStart, nameEnd)) continue;
            }
            cookie = new LazyCookie();
            lazyCookie = cookie.lazy();
            lazyCookie.getName().setBuffer(buffer, nameStart, nameEnd);
            if (valueStart != -1) {
                lazyCookie.getValue().setBuffer(buffer, valueStart, valueEnd);
                if (isQuoted) {
                    CookieParserUtils.unescapeDoubleQuotes(lazyCookie.getValue());
                }
            } else {
                lazyCookie.getValue().setString("");
            }
            cookies.add(cookie);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void parseServerCookies(Collection<Cookie> cookies, String cookiesStr, boolean versionOneStrictCompliance) {
        if (cookiesStr == null) {
            throw new IllegalArgumentException();
        }
        end = cookiesStr.length();
        pos = 0;
        cookie = null;
        while (pos < end) {
            block27: {
                block26: {
                    isQuoted = false;
                    while (pos < end && (CookieUtils.isSeparator(cookiesStr.charAt(pos)) || CookieUtils.isWhiteSpace(cookiesStr.charAt(pos)))) {
                        ++pos;
                    }
                    if (pos >= end) {
                        return;
                    }
                    valueStart = nameStart = pos;
                    valueEnd = nameStart;
                    for (pos = nameEnd = CookieUtils.getTokenEndPosition(cookiesStr, pos, end); pos < end && CookieUtils.isWhiteSpace(cookiesStr.charAt(pos)); ++pos) {
                    }
                    if (pos >= end || cookiesStr.charAt(pos) != '=') break block26;
                    while (++pos < end && CookieUtils.isWhiteSpace(cookiesStr.charAt(pos))) {
                    }
                    if (pos >= end) {
                        return;
                    }
                    switch (cookiesStr.charAt(pos)) {
                        case '\"': {
                            isQuoted = true;
                            valueStart = pos + 1;
                            pos = valueEnd = CookieUtils.getQuotedValueEndPosition(cookiesStr, valueStart, end);
                            if (pos >= end) {
                                return;
                            }
                            break block27;
                        }
                        case ',': 
                        case ';': {
                            valueEnd = -1;
                            valueStart = -1;
                            break block27;
                        }
                        default: {
                            if (CookieUtils.isSeparator(cookiesStr.charAt(pos), versionOneStrictCompliance)) ** GOTO lbl39
                            valueStart = pos;
                            pos = valueEnd = CookieUtils.getTokenEndPosition(cookiesStr, valueStart, end, versionOneStrictCompliance);
                            break block27;
lbl39:
                            // 1 sources

                            CookieParserUtils.LOGGER.fine("Invalid cookie. Value not a token or quoted value");
                            while (pos < end && cookiesStr.charAt(pos) != ';' && cookiesStr.charAt(pos) != ',') {
                                ++pos;
                            }
                            ++pos;
                            cookie = null;
                            break;
                        }
                    }
                    continue;
                }
                valueEnd = -1;
                valueStart = -1;
                pos = nameEnd;
            }
            while (pos < end && CookieUtils.isWhiteSpace(cookiesStr.charAt(pos))) {
                ++pos;
            }
            while (pos < end && cookiesStr.charAt(pos) != ';' && cookiesStr.charAt(pos) != ',') {
                ++pos;
            }
            ++pos;
            if (cookie != null) {
                if (cookie.getDomain() == null && CookieUtils.equalsIgnoreCase("Domain", cookiesStr, nameStart, nameEnd)) {
                    cookie.setDomain(cookiesStr.substring(valueStart, valueEnd));
                    continue;
                }
                if (cookie.getPath() == null && CookieUtils.equalsIgnoreCase("Path", cookiesStr, nameStart, nameEnd)) {
                    cookie.setPath(cookiesStr.substring(valueStart, valueEnd));
                    continue;
                }
                if (cookie.getVersion() == 0 && CookieUtils.equals("Version", cookiesStr, nameStart, nameEnd)) {
                    if (cookiesStr.charAt(valueStart) != '1' || valueEnd != valueStart + 1) continue;
                    cookie.setVersion(1);
                    continue;
                }
                if (cookie.getComment() == null && CookieUtils.equals("Comment", cookiesStr, nameStart, nameEnd)) {
                    cookie.setComment(cookiesStr.substring(valueStart, valueEnd));
                    continue;
                }
                if (cookie.getMaxAge() == -1 && CookieUtils.equals("Max-Age", cookiesStr, nameStart, nameEnd)) {
                    cookie.setMaxAge(Integer.parseInt(cookiesStr.substring(valueStart, valueEnd)));
                    continue;
                }
                if (cookie.getVersion() == 0 && cookie.getMaxAge() == -1 && CookieUtils.equalsIgnoreCase("Expires", cookiesStr, nameStart, nameEnd)) {
                    try {
                        valueEnd = CookieUtils.getTokenEndPosition(cookiesStr, valueEnd + 1, end, false);
                        pos = valueEnd + 1;
                        expiresDate = cookiesStr.substring(valueStart, valueEnd);
                        date = CookieUtils.OLD_COOKIE_FORMAT.get().parse(expiresDate);
                        cookie.setMaxAge((int)(date.getTime() - System.currentTimeMillis()) / 1000);
                    }
                    catch (ParseException ignore) {}
                    continue;
                }
                if (!cookie.isSecure() && CookieUtils.equalsIgnoreCase("Secure", cookiesStr, nameStart, nameEnd)) {
                    cookie.setSecure(true);
                    continue;
                }
                if (!cookie.isHttpOnly() && CookieUtils.equals("HttpOnly", cookiesStr, nameStart, nameEnd)) {
                    cookie.setHttpOnly(true);
                    continue;
                }
                if (CookieUtils.equals("Port", cookiesStr, nameStart, nameEnd) || CookieUtils.equals("Discard", cookiesStr, nameStart, nameEnd)) continue;
            }
            name = cookiesStr.substring(nameStart, nameEnd);
            value = valueStart != -1 ? (isQuoted ? CookieParserUtils.unescapeDoubleQuotes(cookiesStr, valueStart, valueEnd - valueStart) : cookiesStr.substring(valueStart, valueEnd)) : "";
            cookie = new Cookie(name, value);
            cookies.add(cookie);
        }
    }

    public static void unescapeDoubleQuotes(DataChunk dc) {
        switch (dc.getType()) {
            case Buffer: {
                CookieParserUtils.unescapeDoubleQuotes(dc.getBufferChunk());
                return;
            }
            case String: {
                String s2 = dc.toString();
                dc.setString(CookieParserUtils.unescapeDoubleQuotes(s2, 0, s2.length()));
                return;
            }
        }
        throw new NullPointerException();
    }

    public static void unescapeDoubleQuotes(BufferChunk bc) {
        int src;
        if (bc == null || bc.getLength() == 0) {
            return;
        }
        int end = bc.getEnd();
        int dest = src;
        Buffer buffer = bc.getBuffer();
        for (src = bc.getStart(); src < end; ++src) {
            if (buffer.get(src) == 92 && src < end && buffer.get(src + 1) == 34) {
                ++src;
            }
            buffer.put(dest, buffer.get(src));
            ++dest;
        }
        bc.setEnd(dest);
    }

    public static void unescapeDoubleQuotes(CharChunk cc) {
        int src;
        if (cc == null || cc.getLength() == 0) {
            return;
        }
        int end = cc.getLimit();
        int dest = src;
        char[] buffer = cc.getBuffer();
        for (src = cc.getStart(); src < end; ++src) {
            if (buffer[src] == '\\' && src < end && buffer[src + 1] == '\"') {
                ++src;
            }
            buffer[dest] = buffer[src];
            ++dest;
        }
        cc.setLimit(dest);
    }

    public static int unescapeDoubleQuotes(Buffer buffer, int start, int length) {
        int src;
        if (buffer == null || length <= 0) {
            return length;
        }
        int end = src + length;
        int dest = src;
        for (src = start; src < end; ++src) {
            if (buffer.get(src) == 92 && src < end && buffer.get(src + 1) == 34) {
                ++src;
            }
            buffer.put(dest, buffer.get(src));
            ++dest;
        }
        return dest - start;
    }

    public static String unescapeDoubleQuotes(String s2, int start, int length) {
        int src;
        if (s2 == null || s2.length() == 0) {
            return s2;
        }
        StringBuilder sb = new StringBuilder(s2.length());
        int end = src + length;
        for (src = start; src < end; ++src) {
            if (s2.charAt(src) == '\\' && src < end && s2.charAt(src + 1) == '\"') {
                ++src;
            }
            sb.append(s2.charAt(src));
        }
        return sb.toString();
    }
}

