/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server.util;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.glassfish.grizzly.ssl.SSLSupportImpl;

public class RequestUtils {
    private static final Logger LOGGER = Grizzly.logger(RequestUtils.class);

    public static Object populateCertificateAttribute(Request request) {
        Object[] certificates = null;
        if (request.getRequest().isSecure()) {
            SSLFilter.CertificateEvent event;
            block3: {
                event = new SSLFilter.CertificateEvent(true);
                try {
                    request.getContext().notifyDownstream(event);
                }
                catch (IOException ioe) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block3;
                    LOGGER.log(Level.FINE, ioe.toString(), ioe);
                }
            }
            certificates = event.getCertificates();
            request.setAttribute("javax.servlet.request.X509Certificate", certificates);
        }
        return certificates;
    }

    public static void populateSSLAttributes(Request request) {
        block9: {
            if (request.isSecure()) {
                try {
                    SSLSupportImpl sslSupport = new SSLSupportImpl(request.getContext().getConnection());
                    Object sslO = sslSupport.getCipherSuite();
                    if (sslO != null) {
                        request.setAttribute("javax.servlet.request.cipher_suite", sslO);
                    }
                    if ((sslO = sslSupport.getPeerCertificateChain(false)) != null) {
                        request.setAttribute("javax.servlet.request.X509Certificate", sslO);
                    }
                    if ((sslO = sslSupport.getKeySize()) != null) {
                        request.setAttribute("javax.servlet.request.key_size", sslO);
                    }
                    if ((sslO = sslSupport.getSessionId()) != null) {
                        request.setAttribute("javax.servlet.request.ssl_session_id", sslO);
                    }
                    break block9;
                }
                catch (Exception ioe) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, "Unable to populate SSL attributes", ioe);
                    }
                    break block9;
                }
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Unable to populate SSL attributes on plain HTTP request");
            }
        }
    }
}

