/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import java.util.ArrayList;
import java.util.List;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.Cookie;
import org.glassfish.grizzly.http.util.CookieParserUtils;

public class CookiesBuilder {
    public static ClientCookiesBuilder client() {
        return CookiesBuilder.client(false);
    }

    public static ClientCookiesBuilder client(boolean strictVersionOneCompliant) {
        return new ClientCookiesBuilder(strictVersionOneCompliant);
    }

    public static ServerCookiesBuilder server() {
        return CookiesBuilder.server(false);
    }

    public static ServerCookiesBuilder server(boolean strictVersionOneCompliant) {
        return new ServerCookiesBuilder(strictVersionOneCompliant);
    }

    public static abstract class AbstractCookiesBuilder<E extends AbstractCookiesBuilder> {
        protected final boolean strictVersionOneCompliant;
        protected final List<Cookie> cookies = new ArrayList<Cookie>(4);

        public AbstractCookiesBuilder(boolean strictVersionOneCompliant) {
            this.strictVersionOneCompliant = strictVersionOneCompliant;
        }

        public E addCookie(Cookie cookie) {
            this.cookies.add(cookie);
            return (E)this;
        }

        public abstract E parse(Buffer var1);

        public abstract E parse(Buffer var1, int var2, int var3);

        public abstract E parse(String var1);

        public List<Cookie> build() {
            return this.cookies;
        }
    }

    public static class ServerCookiesBuilder
    extends AbstractCookiesBuilder<ServerCookiesBuilder> {
        public ServerCookiesBuilder(boolean strictVersionOneCompliant) {
            super(strictVersionOneCompliant);
        }

        @Override
        public ServerCookiesBuilder parse(Buffer cookiesHeader) {
            return this.parse(cookiesHeader, cookiesHeader.position(), cookiesHeader.limit());
        }

        @Override
        public ServerCookiesBuilder parse(Buffer cookiesHeader, int position, int limit) {
            CookieParserUtils.parseServerCookies(this.cookies, cookiesHeader, position, limit - position, this.strictVersionOneCompliant);
            return this;
        }

        @Override
        public ServerCookiesBuilder parse(String cookiesHeader) {
            CookieParserUtils.parseServerCookies(this.cookies, cookiesHeader, this.strictVersionOneCompliant);
            return this;
        }
    }

    public static class ClientCookiesBuilder
    extends AbstractCookiesBuilder<ClientCookiesBuilder> {
        public ClientCookiesBuilder(boolean strictVersionOneCompliant) {
            super(strictVersionOneCompliant);
        }

        @Override
        public ClientCookiesBuilder parse(Buffer cookiesHeader) {
            return this.parse(cookiesHeader, cookiesHeader.position(), cookiesHeader.limit());
        }

        @Override
        public ClientCookiesBuilder parse(Buffer cookiesHeader, int position, int limit) {
            CookieParserUtils.parseClientCookies(this.cookies, cookiesHeader, position, limit - position, this.strictVersionOneCompliant);
            return this;
        }

        @Override
        public ClientCookiesBuilder parse(String cookiesHeader) {
            CookieParserUtils.parseClientCookies(this.cookies, cookiesHeader, this.strictVersionOneCompliant);
            return this;
        }
    }
}

