/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.filterchain;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.glassfish.grizzly.filterchain.AbstractFilterChain;
import org.glassfish.grizzly.filterchain.Filter;

public abstract class ListFacadeFilterChain
extends AbstractFilterChain {
    protected final List<Filter> filters;

    public ListFacadeFilterChain(List<Filter> filtersImpl) {
        this.filters = filtersImpl;
    }

    @Override
    public boolean add(Filter filter2) {
        if (this.filters.add(filter2)) {
            filter2.onAdded(this);
            this.notifyChangedExcept(filter2);
            return true;
        }
        return false;
    }

    @Override
    public void add(int index2, Filter filter2) {
        this.filters.add(index2, filter2);
        filter2.onAdded(this);
        this.notifyChangedExcept(filter2);
    }

    @Override
    public boolean addAll(Collection<? extends Filter> c) {
        for (Filter filter2 : c) {
            this.filters.add(filter2);
            filter2.onAdded(this);
        }
        this.notifyChangedExcept(null);
        return true;
    }

    @Override
    public boolean addAll(int index2, Collection<? extends Filter> c) {
        int i = 0;
        for (Filter filter2 : c) {
            this.filters.add(index2 + i++, filter2);
            filter2.onAdded(this);
        }
        this.notifyChangedExcept(null);
        return true;
    }

    @Override
    public Filter set(int index2, Filter filter2) {
        Filter oldFilter = this.filters.set(index2, filter2);
        if (oldFilter != filter2) {
            filter2.onAdded(this);
            if (oldFilter != null) {
                oldFilter.onRemoved(this);
            }
            this.notifyChangedExcept(filter2);
        }
        return oldFilter;
    }

    @Override
    public final Filter get(int index2) {
        return this.filters.get(index2);
    }

    @Override
    public int indexOf(Object object) {
        return this.filters.indexOf(object);
    }

    @Override
    public int lastIndexOf(Object filter2) {
        return this.filters.lastIndexOf(filter2);
    }

    @Override
    public boolean contains(Object filter2) {
        return this.filters.contains(filter2);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.filters.containsAll(c);
    }

    @Override
    public Object[] toArray() {
        return this.filters.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.filters.toArray(a);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object object) {
        Filter filter2 = (Filter)object;
        if (this.filters.remove(filter2)) {
            filter2.onRemoved(this);
            this.notifyChangedExcept(filter2);
            return true;
        }
        return false;
    }

    @Override
    public Filter remove(int index2) {
        Filter filter2 = this.filters.remove(index2);
        if (filter2 != null) {
            filter2.onRemoved(this);
            this.notifyChangedExcept(filter2);
            return filter2;
        }
        return null;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.filters == null || this.filters.isEmpty();
    }

    @Override
    public int size() {
        return this.filters.size();
    }

    @Override
    public void clear() {
        Object[] localFilters = this.filters.toArray();
        this.filters.clear();
        for (Object filter2 : localFilters) {
            ((Filter)filter2).onRemoved(this);
        }
    }

    @Override
    public Iterator<Filter> iterator() {
        return this.filters.iterator();
    }

    @Override
    public ListIterator<Filter> listIterator() {
        return this.filters.listIterator();
    }

    @Override
    public ListIterator<Filter> listIterator(int index2) {
        return this.filters.listIterator(index2);
    }

    protected void notifyChangedExcept(Filter filter2) {
        for (Filter currentFilter : this.filters) {
            if (currentFilter == filter2) continue;
            currentFilter.onFilterChainChanged(this);
        }
    }
}

