/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.xc;

import java.io.IOException;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.deser.StdDeserializer;
import org.codehaus.jackson.node.ArrayNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomElementJsonDeserializer
extends StdDeserializer<Element> {
    private final DocumentBuilder builder;

    public DomElementJsonDeserializer() {
        super(Element.class);
        try {
            DocumentBuilderFactory bf = DocumentBuilderFactory.newInstance();
            bf.setNamespaceAware(true);
            this.builder = bf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException();
        }
    }

    public DomElementJsonDeserializer(DocumentBuilder builder) {
        super(Element.class);
        this.builder = builder;
    }

    @Override
    public Element deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Document document2 = this.builder.newDocument();
        return this.fromNode(document2, jp.readValueAsTree());
    }

    protected Element fromNode(Document document2, JsonNode jsonNode) throws IOException {
        JsonNode childsNode;
        String name;
        String ns = jsonNode.get("namespace") != null ? jsonNode.get("namespace").getValueAsText() : null;
        String string2 = name = jsonNode.get("name") != null ? jsonNode.get("name").getValueAsText() : null;
        if (name == null) {
            throw new JsonMappingException("No name for DOM element was provided in the JSON object.");
        }
        Element element = document2.createElementNS(ns, name);
        JsonNode attributesNode = jsonNode.get("attributes");
        if (attributesNode != null && attributesNode instanceof ArrayNode) {
            Iterator<JsonNode> atts = attributesNode.getElements();
            while (atts.hasNext()) {
                String value2;
                JsonNode node = atts.next();
                ns = node.get("namespace") != null ? node.get("namespace").getValueAsText() : null;
                name = node.get("name") != null ? node.get("name").getValueAsText() : null;
                String string3 = value2 = node.get("$") != null ? node.get("$").getValueAsText() : null;
                if (name == null) continue;
                element.setAttributeNS(ns, name, value2);
            }
        }
        if ((childsNode = jsonNode.get("children")) != null && childsNode instanceof ArrayNode) {
            Iterator<JsonNode> els = childsNode.getElements();
            while (els.hasNext()) {
                String value3;
                JsonNode node = els.next();
                name = node.get("name") != null ? node.get("name").getValueAsText() : null;
                String string4 = value3 = node.get("$") != null ? node.get("$").getValueAsText() : null;
                if (value3 != null) {
                    element.appendChild(document2.createTextNode(value3));
                    continue;
                }
                if (name == null) continue;
                element.appendChild(this.fromNode(document2, node));
            }
        }
        return element;
    }
}

