/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser;

import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.deser.PropertyValue;
import org.codehaus.jackson.map.deser.SettableAnyProperty;
import org.codehaus.jackson.map.deser.SettableBeanProperty;

public final class PropertyValueBuffer {
    final JsonParser _parser;
    final DeserializationContext _context;
    final Object[] _creatorParameters;
    private int _paramsNeeded;
    private PropertyValue _buffered;

    public PropertyValueBuffer(JsonParser jp, DeserializationContext ctxt, int paramCount) {
        this._parser = jp;
        this._context = ctxt;
        this._paramsNeeded = paramCount;
        this._creatorParameters = new Object[paramCount];
    }

    protected final Object[] getParameters(Object[] defaults) {
        if (defaults != null) {
            int len = this._creatorParameters.length;
            for (int i = 0; i < len; ++i) {
                Object value2;
                if (this._creatorParameters[i] != null || (value2 = defaults[i]) == null) continue;
                this._creatorParameters[i] = value2;
            }
        }
        return this._creatorParameters;
    }

    protected PropertyValue buffered() {
        return this._buffered;
    }

    public boolean assignParameter(int index2, Object value2) {
        this._creatorParameters[index2] = value2;
        return --this._paramsNeeded <= 0;
    }

    public void bufferProperty(SettableBeanProperty prop, Object value2) {
        this._buffered = new PropertyValue.Regular(this._buffered, value2, prop);
    }

    public void bufferAnyProperty(SettableAnyProperty prop, String propName, Object value2) {
        this._buffered = new PropertyValue.Any(this._buffered, value2, prop, propName);
    }

    public void bufferMapProperty(Object key, Object value2) {
        this._buffered = new PropertyValue.Map(this._buffered, value2, key);
    }
}

