/*
 * Decompiled with CFR 0.152.
 */
package org.cloudera.htrace.wrappers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.cloudera.htrace.wrappers.TraceCallable;
import org.cloudera.htrace.wrappers.TraceRunnable;

public class TraceExecutorService
implements ExecutorService {
    private final ExecutorService impl;

    public TraceExecutorService(ExecutorService impl) {
        this.impl = impl;
    }

    @Override
    public void execute(Runnable command) {
        this.impl.execute(new TraceRunnable(command));
    }

    @Override
    public void shutdown() {
        this.impl.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.impl.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.impl.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.impl.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.impl.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.impl.submit(new TraceCallable<T>(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result2) {
        return this.impl.submit(new TraceRunnable(task), result2);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.impl.submit(new TraceRunnable(task));
    }

    private <T> Collection<? extends Callable<T>> wrapCollection(Collection<? extends Callable<T>> tasks) {
        ArrayList<TraceCallable<T>> result2 = new ArrayList<TraceCallable<T>>();
        for (Callable<T> task : tasks) {
            result2.add(new TraceCallable<T>(task));
        }
        return result2;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.impl.invokeAll(this.wrapCollection(tasks));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.impl.invokeAll(this.wrapCollection(tasks), timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.impl.invokeAny(this.wrapCollection(tasks));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.impl.invokeAny(this.wrapCollection(tasks), timeout, unit);
    }
}

