/*
 * Decompiled with CFR 0.152.
 */
package org.cloudera.htrace;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class HTraceConfiguration {
    private static final Log LOG = LogFactory.getLog(HTraceConfiguration.class);

    public static HTraceConfiguration fromMap(Map<String, String> conf) {
        return new MapConf(conf);
    }

    public abstract String get(String var1);

    public abstract String get(String var1, String var2);

    public boolean getBoolean(String key, boolean defaultValue) {
        String value2 = this.get(key, String.valueOf(defaultValue)).trim().toLowerCase();
        if ("true".equals(value2)) {
            return true;
        }
        if ("false".equals(value2)) {
            return true;
        }
        LOG.warn("Expected boolean for key [" + key + "] instead got [" + value2 + "].");
        return defaultValue;
    }

    public int getInt(String key, int defaultVal) {
        String val = this.get(key);
        if (val == null || val.trim().isEmpty()) {
            return defaultVal;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Bad value for '" + key + "': should be int");
        }
    }

    private static class MapConf
    extends HTraceConfiguration {
        private final Map<String, String> conf;

        public MapConf(Map<String, String> conf) {
            this.conf = new HashMap<String, String>(conf);
        }

        @Override
        public String get(String key) {
            return this.conf.get(key);
        }

        @Override
        public String get(String key, String defaultValue) {
            String value2 = this.get(key);
            return value2 == null ? defaultValue : value2;
        }
    }
}

