/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.core;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.taglibs.standard.resources.Resources;
import org.apache.taglibs.standard.tag.common.core.Util;

public class SetSupport
extends BodyTagSupport {
    protected Object value;
    protected boolean valueSpecified;
    protected Object target;
    protected String property;
    private String var;
    private int scope;
    private boolean scopeSpecified;

    public SetSupport() {
        this.init();
    }

    private void init() {
        this.var = null;
        this.value = null;
        this.valueSpecified = false;
        this.scopeSpecified = false;
        this.scope = 1;
    }

    public void release() {
        super.release();
        this.init();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int doEndTag() throws JspException {
        Object result2 = this.value != null ? this.value : (this.valueSpecified ? null : (this.bodyContent == null || this.bodyContent.getString() == null ? "" : this.bodyContent.getString().trim()));
        if (this.var != null) {
            if (result2 != null) {
                if (result2 instanceof ValueExpression) {
                    if (this.scope != 1) {
                        throw new JspException(Resources.getMessage("SET_BAD_SCOPE_DEFERRED"));
                    }
                    VariableMapper vm = this.pageContext.getELContext().getVariableMapper();
                    if (vm == null) return 6;
                    vm.setVariable(this.var, (ValueExpression)result2);
                    return 6;
                } else {
                    VariableMapper vm;
                    if (this.scope == 1 && (vm = this.pageContext.getELContext().getVariableMapper()) != null) {
                        vm.setVariable(this.var, null);
                    }
                    this.pageContext.setAttribute(this.var, result2, this.scope);
                }
                return 6;
            } else {
                VariableMapper vm;
                if (this.scopeSpecified) {
                    this.pageContext.removeAttribute(this.var, this.scope);
                } else {
                    this.pageContext.removeAttribute(this.var);
                }
                if (this.scope != 1 || (vm = this.pageContext.getELContext().getVariableMapper()) == null) return 6;
                vm.setVariable(this.var, null);
            }
            return 6;
        } else {
            if (this.target == null) throw new JspTagException();
            if (this.target instanceof Map) {
                if (result2 == null) {
                    ((Map)this.target).remove(this.property);
                    return 6;
                } else {
                    ((Map)this.target).put(this.property, result2);
                }
                return 6;
            } else {
                try {
                    PropertyDescriptor[] pd = Introspector.getBeanInfo(this.target.getClass()).getPropertyDescriptors();
                    boolean succeeded = false;
                    for (int i = 0; i < pd.length; ++i) {
                        if (!pd[i].getName().equals(this.property)) continue;
                        Method m = pd[i].getWriteMethod();
                        if (m == null) {
                            throw new JspException(Resources.getMessage("SET_NO_SETTER_METHOD", this.property));
                        }
                        if (result2 != null) {
                            try {
                                m.invoke(this.target, this.convertToExpectedType(result2, m.getParameterTypes()[0]));
                            }
                            catch (ELException ex) {
                                throw new JspTagException(ex);
                            }
                        } else {
                            m.invoke(this.target, new Object[]{null});
                        }
                        succeeded = true;
                    }
                    if (succeeded) return 6;
                    throw new JspTagException(Resources.getMessage("SET_INVALID_PROPERTY", this.property));
                }
                catch (IllegalAccessException ex) {
                    throw new JspException(ex);
                }
                catch (IntrospectionException ex) {
                    throw new JspException(ex);
                }
                catch (InvocationTargetException ex) {
                    throw new JspException(ex);
                }
            }
        }
    }

    private Object convertToExpectedType(Object value2, Class expectedType) {
        JspFactory jspFactory = JspFactory.getDefaultFactory();
        JspApplicationContext jspAppContext = jspFactory.getJspApplicationContext(this.pageContext.getServletContext());
        ExpressionFactory exprFactory = jspAppContext.getExpressionFactory();
        return exprFactory.coerceToType(value2, expectedType);
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setScope(String scope) {
        this.scope = Util.getScope(scope);
        this.scopeSpecified = true;
    }
}

