/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.bolt.format;

import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Tuple;
import org.apache.storm.hdfs.bolt.format.RecordFormat;

public class DelimitedRecordFormat
implements RecordFormat {
    public static final String DEFAULT_FIELD_DELIMITER = ",";
    public static final String DEFAULT_RECORD_DELIMITER = "\n";
    private String fieldDelimiter = ",";
    private String recordDelimiter = "\n";
    private Fields fields = null;

    public DelimitedRecordFormat withFields(Fields fields) {
        this.fields = fields;
        return this;
    }

    public DelimitedRecordFormat withFieldDelimiter(String delimiter) {
        this.fieldDelimiter = delimiter;
        return this;
    }

    public DelimitedRecordFormat withRecordDelimiter(String delimiter) {
        this.recordDelimiter = delimiter;
        return this;
    }

    @Override
    public byte[] format(Tuple tuple) {
        StringBuilder sb = new StringBuilder();
        Fields fields = this.fields == null ? tuple.getFields() : this.fields;
        int size2 = fields.size();
        for (int i = 0; i < size2; ++i) {
            sb.append(tuple.getValueByField(fields.get(i)));
            if (i == size2 - 1) continue;
            sb.append(this.fieldDelimiter);
        }
        sb.append(this.recordDelimiter);
        return sb.toString().getBytes();
    }
}

