/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hbase.security;

import backtype.storm.security.INimbusCredentialPlugin;
import backtype.storm.security.auth.IAutoCredentials;
import backtype.storm.security.auth.ICredentialsRenewer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.xml.bind.DatatypeConverter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.token.TokenUtil;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoHBase
implements IAutoCredentials,
ICredentialsRenewer,
INimbusCredentialPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(AutoHBase.class);
    public static final String HBASE_CREDENTIALS = "HBASE_CREDENTIALS";
    public static final String HBASE_KEYTAB_FILE_KEY = "hbase.keytab.file";
    public static final String HBASE_PRINCIPAL_KEY = "hbase.kerberos.principal";
    public String hbaseKeytab;
    public String hbasePrincipal;

    public void prepare(Map conf) {
        if (conf.containsKey(HBASE_KEYTAB_FILE_KEY) && conf.containsKey(HBASE_PRINCIPAL_KEY)) {
            this.hbaseKeytab = (String)conf.get(HBASE_KEYTAB_FILE_KEY);
            this.hbasePrincipal = (String)conf.get(HBASE_PRINCIPAL_KEY);
        }
    }

    public void shutdown() {
    }

    public void populateCredentials(Map<String, String> credentials, Map conf) {
        try {
            credentials.put(this.getCredentialKey(), DatatypeConverter.printBase64Binary(this.getHadoopCredentials(conf)));
        }
        catch (Exception e) {
            LOG.error("Could not populate HBase credentials.", e);
        }
    }

    public void populateCredentials(Map<String, String> credentials) {
        credentials.put(HBASE_CREDENTIALS, DatatypeConverter.printBase64Binary("dummy place holder".getBytes()));
    }

    protected Object getCredentials(Map<String, String> credentials) {
        Credentials credential = null;
        if (credentials != null && credentials.containsKey(this.getCredentialKey())) {
            try {
                byte[] credBytes = DatatypeConverter.parseBase64Binary(credentials.get(this.getCredentialKey()));
                ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(credBytes));
                credential = new Credentials();
                credential.readFields(in);
                LOG.info("Got hbase credentials from credentials Map.");
            }
            catch (Exception e) {
                LOG.error("Could not obtain credentials from credentials map.", e);
            }
        }
        return credential;
    }

    public void updateSubject(Subject subject, Map<String, String> credentials) {
        this.addCredentialToSubject(subject, credentials);
        this.addTokensToUGI(subject);
    }

    public void populateSubject(Subject subject, Map<String, String> credentials) {
        this.addCredentialToSubject(subject, credentials);
        this.addTokensToUGI(subject);
    }

    private void addCredentialToSubject(Subject subject, Map<String, String> credentials) {
        try {
            Object credential = this.getCredentials(credentials);
            if (credential != null) {
                subject.getPrivateCredentials().add(credential);
                LOG.info("Hbase credentials added to subject.");
            } else {
                LOG.info("No credential found in credentials map.");
            }
        }
        catch (Exception e) {
            LOG.error("Failed to initialize and get UserGroupInformation.", e);
        }
    }

    public void addTokensToUGI(Subject subject) {
        Set<Credentials> privateCredentials;
        if (subject != null && (privateCredentials = subject.getPrivateCredentials(Credentials.class)) != null) {
            for (Credentials cred : privateCredentials) {
                Collection<Token<? extends TokenIdentifier>> allTokens = cred.getAllTokens();
                if (allTokens == null) continue;
                for (Token<? extends TokenIdentifier> token2 : allTokens) {
                    try {
                        UserGroupInformation.getCurrentUser().addToken(token2);
                        LOG.info("Added delegation tokens to UGI.");
                    }
                    catch (IOException e) {
                        LOG.error("Exception while trying to add tokens to ugi", e);
                    }
                }
            }
        }
    }

    protected byte[] getHadoopCredentials(Map conf) {
        try {
            Configuration hbaseConf = HBaseConfiguration.create();
            if (UserGroupInformation.isSecurityEnabled()) {
                String topologySubmitterUser = (String)conf.get("topology.submitter.principal");
                UserProvider provider = UserProvider.instantiate(hbaseConf);
                hbaseConf.set(HBASE_KEYTAB_FILE_KEY, this.hbaseKeytab);
                hbaseConf.set(HBASE_PRINCIPAL_KEY, this.hbasePrincipal);
                provider.login(HBASE_KEYTAB_FILE_KEY, HBASE_PRINCIPAL_KEY, InetAddress.getLocalHost().getCanonicalHostName());
                LOG.info("Logged into Hbase as principal = " + conf.get(HBASE_PRINCIPAL_KEY));
                UserGroupInformation.setConfiguration(hbaseConf);
                UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
                UserGroupInformation proxyUser = UserGroupInformation.createProxyUser(topologySubmitterUser, ugi);
                User user = User.create(ugi);
                if (User.isHBaseSecurityEnabled(hbaseConf)) {
                    TokenUtil.obtainAndCacheToken(hbaseConf, proxyUser);
                    LOG.info("Obtained HBase tokens, adding to user credentials.");
                    Credentials credential = proxyUser.getCredentials();
                    ByteArrayOutputStream bao = new ByteArrayOutputStream();
                    ObjectOutputStream out = new ObjectOutputStream(bao);
                    credential.write(out);
                    out.flush();
                    out.close();
                    return bao.toByteArray();
                }
                throw new RuntimeException("Security is not enabled for HBase.");
            }
            throw new RuntimeException("Security is not enabled for Hadoop");
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to get delegation tokens.", ex);
        }
    }

    public void renew(Map<String, String> credentials, Map topologyConf) {
        this.populateCredentials(credentials, topologyConf);
    }

    protected String getCredentialKey() {
        return HBASE_CREDENTIALS;
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("topology.submitter.principal", args[0]);
        conf.put(HBASE_PRINCIPAL_KEY, args[1]);
        conf.put(HBASE_KEYTAB_FILE_KEY, args[2]);
        AutoHBase autoHBase = new AutoHBase();
        autoHBase.prepare(conf);
        HashMap<String, String> creds = new HashMap<String, String>();
        autoHBase.populateCredentials(creds, conf);
        LOG.info("Got HBase credentials" + autoHBase.getCredentials(creds));
        Subject s2 = new Subject();
        autoHBase.populateSubject(s2, creds);
        LOG.info("Got a Subject " + s2);
        autoHBase.renew(creds, conf);
        LOG.info("renewed credentials" + autoHBase.getCredentials(creds));
    }
}

