/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hbase.common;

import java.math.BigDecimal;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger LOG = LoggerFactory.getLogger(Utils.class);

    private Utils() {
    }

    public static long toLong(Object obj) {
        long l = 0L;
        if (obj != null) {
            if (obj instanceof Number) {
                l = ((Number)obj).longValue();
            } else {
                LOG.warn("Could not coerce {} to Long", (Object)obj.getClass().getName());
            }
        }
        return l;
    }

    public static byte[] toBytes(Object obj) {
        if (obj instanceof String) {
            return ((String)obj).getBytes();
        }
        if (obj instanceof Integer) {
            return Bytes.toBytes((Integer)obj);
        }
        if (obj instanceof Long) {
            return Bytes.toBytes((Long)obj);
        }
        if (obj instanceof Short) {
            return Bytes.toBytes((Short)obj);
        }
        if (obj instanceof Float) {
            return Bytes.toBytes(((Float)obj).floatValue());
        }
        if (obj instanceof Double) {
            return Bytes.toBytes((Double)obj);
        }
        if (obj instanceof Boolean) {
            return Bytes.toBytes((Boolean)obj);
        }
        if (obj instanceof BigDecimal) {
            return Bytes.toBytes((BigDecimal)obj);
        }
        LOG.error("Can't convert class to byte array: " + obj.getClass().getName());
        return new byte[0];
    }
}

