/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hbase.common;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.storm.hbase.bolt.mapper.HBaseProjectionCriteria;
import org.apache.storm.hbase.common.ColumnList;
import org.apache.storm.hbase.security.HBaseSecurityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseClient {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseClient.class);
    private HTable table;

    public HBaseClient(Map<String, Object> map2, final Configuration configuration, final String tableName) {
        try {
            UserProvider provider = HBaseSecurityUtil.login(map2, configuration);
            this.table = provider.getCurrent().getUGI().doAs(new PrivilegedExceptionAction<HTable>(){

                @Override
                public HTable run() throws IOException {
                    return new HTable(configuration, tableName);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("HBase bolt preparation failed: " + e.getMessage(), e);
        }
    }

    public List<Mutation> constructMutationReq(byte[] rowKey, ColumnList cols, Durability durability) {
        ArrayList<Mutation> mutations = Lists.newArrayList();
        if (cols.hasColumns()) {
            Put put2 = new Put(rowKey);
            put2.setDurability(durability);
            for (ColumnList.Column col : cols.getColumns()) {
                if (col.getTs() > 0L) {
                    put2.add(col.getFamily(), col.getQualifier(), col.getTs(), col.getValue());
                    continue;
                }
                put2.add(col.getFamily(), col.getQualifier(), col.getValue());
            }
            mutations.add(put2);
        }
        if (cols.hasCounters()) {
            Increment inc = new Increment(rowKey);
            inc.setDurability(durability);
            for (ColumnList.Counter cnt : cols.getCounters()) {
                inc.addColumn(cnt.getFamily(), cnt.getQualifier(), cnt.getIncrement());
            }
            mutations.add(inc);
        }
        if (mutations.isEmpty()) {
            mutations.add(new Put(rowKey));
        }
        return mutations;
    }

    public void batchMutate(List<Mutation> mutations) throws Exception {
        Object[] result2 = new Object[mutations.size()];
        try {
            this.table.batch(mutations, result2);
        }
        catch (InterruptedException e) {
            LOG.warn("Error performing a mutation to HBase.", e);
            throw e;
        }
        catch (IOException e) {
            LOG.warn("Error performing a mutation to HBase.", e);
            throw e;
        }
    }

    public Get constructGetRequests(byte[] rowKey, HBaseProjectionCriteria projectionCriteria) {
        Get get2 = new Get(rowKey);
        if (projectionCriteria != null) {
            for (byte[] columnFamily : projectionCriteria.getColumnFamilies()) {
                get2.addFamily(columnFamily);
            }
            for (HBaseProjectionCriteria.ColumnMetaData columnMetaData : projectionCriteria.getColumns()) {
                get2.addColumn(columnMetaData.getColumnFamily(), columnMetaData.getQualifier());
            }
        }
        return get2;
    }

    public Result[] batchGet(List<Get> gets) throws Exception {
        try {
            return this.table.get(gets);
        }
        catch (Exception e) {
            LOG.warn("Could not perform HBASE lookup.", e);
            throw e;
        }
    }
}

