/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hbase.common;

import java.util.ArrayList;
import java.util.List;
import org.apache.storm.hbase.common.IColumn;
import org.apache.storm.hbase.common.ICounter;

public class ColumnList {
    private ArrayList<Column> columns;
    private ArrayList<Counter> counters;

    private ArrayList<Column> columns() {
        if (this.columns == null) {
            this.columns = new ArrayList();
        }
        return this.columns;
    }

    private ArrayList<Counter> counters() {
        if (this.counters == null) {
            this.counters = new ArrayList();
        }
        return this.counters;
    }

    public ColumnList addColumn(byte[] family, byte[] qualifier, long ts, byte[] value2) {
        this.columns().add(new Column(family, qualifier, ts, value2));
        return this;
    }

    public ColumnList addColumn(byte[] family, byte[] qualifier, byte[] value2) {
        this.columns().add(new Column(family, qualifier, -1L, value2));
        return this;
    }

    public ColumnList addColumn(IColumn column) {
        return this.addColumn(column.family(), column.qualifier(), column.timestamp(), column.value());
    }

    public ColumnList addCounter(byte[] family, byte[] qualifier, long incr) {
        this.counters().add(new Counter(family, qualifier, incr));
        return this;
    }

    public ColumnList addCounter(ICounter counter) {
        return this.addCounter(counter.family(), counter.qualifier(), counter.increment());
    }

    public boolean hasColumns() {
        return this.columns != null;
    }

    public boolean hasCounters() {
        return this.counters != null;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public List<Counter> getCounters() {
        return this.counters;
    }

    public static class Counter
    extends AbstractColumn {
        long incr = 0L;

        Counter(byte[] family, byte[] qualifier, long incr) {
            super(family, qualifier);
            this.incr = incr;
        }

        public long getIncrement() {
            return this.incr;
        }
    }

    public static class Column
    extends AbstractColumn {
        byte[] value;
        long ts = -1L;

        Column(byte[] family, byte[] qualifier, long ts, byte[] value2) {
            super(family, qualifier);
            this.value = value2;
            this.ts = ts;
        }

        public byte[] getValue() {
            return this.value;
        }

        public long getTs() {
            return this.ts;
        }
    }

    public static abstract class AbstractColumn {
        byte[] family;
        byte[] qualifier;

        AbstractColumn(byte[] family, byte[] qualifier) {
            this.family = family;
            this.qualifier = qualifier;
        }

        public byte[] getFamily() {
            return this.family;
        }

        public byte[] getQualifier() {
            return this.qualifier;
        }
    }
}

