/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.flux.examples;

import java.io.FileInputStream;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;

public class WordCountClient {
    public static void main(String[] args) throws Exception {
        String[] words;
        Configuration config = HBaseConfiguration.create();
        if (args.length == 1) {
            Properties props = new Properties();
            props.load(new FileInputStream(args[0]));
            System.out.println("HBase configuration:");
            for (Object key : props.keySet()) {
                System.out.println(key + "=" + props.get(key));
                config.set((String)key, props.getProperty((String)key));
            }
        } else {
            System.out.println("Usage: WordCountClient <hbase_config.properties>");
            System.exit(1);
        }
        HTable table = new HTable(config, "WordCount");
        for (String word : words = new String[]{"nathan", "mike", "jackson", "golda", "bertels"}) {
            Get get2 = new Get(Bytes.toBytes(word));
            Result result2 = table.get(get2);
            byte[] countBytes = result2.getValue(Bytes.toBytes("cf"), Bytes.toBytes("count"));
            byte[] wordBytes = result2.getValue(Bytes.toBytes("cf"), Bytes.toBytes("word"));
            String wordStr = Bytes.toString(wordBytes);
            long count2 = Bytes.toLong(countBytes);
            System.out.println("Word: '" + wordStr + "', Count: " + count2);
        }
    }
}

