/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import javax.servlet.ServletConfig;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;

public class TagHandlerPool {
    private Tag[] handlers;
    public static String OPTION_TAGPOOL = "tagpoolClassName";
    public static String OPTION_MAXSIZE = "tagpoolMaxSize";
    private int current;

    public static TagHandlerPool getTagHandlerPool(ServletConfig config) {
        TagHandlerPool result2 = null;
        String tpClassName = TagHandlerPool.getOption(config, OPTION_TAGPOOL, null);
        if (tpClassName != null) {
            try {
                Class<?> c = Class.forName(tpClassName);
                result2 = (TagHandlerPool)c.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                result2 = null;
            }
        }
        if (result2 == null) {
            result2 = new TagHandlerPool();
        }
        result2.init(config);
        return result2;
    }

    protected void init(ServletConfig config) {
        int maxSize = -1;
        String maxSizeS = TagHandlerPool.getOption(config, OPTION_MAXSIZE, null);
        if (maxSizeS != null) {
            try {
                maxSize = Integer.parseInt(maxSizeS);
            }
            catch (Exception ex) {
                maxSize = -1;
            }
        }
        if (maxSize < 0) {
            maxSize = 5;
        }
        this.handlers = new Tag[maxSize];
        this.current = -1;
    }

    public TagHandlerPool() {
    }

    public TagHandlerPool(int capacity) {
        this.handlers = new Tag[capacity];
        this.current = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tag get(Class handlerClass) throws JspException {
        Tag handler = null;
        TagHandlerPool tagHandlerPool = this;
        synchronized (tagHandlerPool) {
            if (this.current >= 0) {
                handler = this.handlers[this.current--];
                return handler;
            }
        }
        try {
            return (Tag)handlerClass.newInstance();
        }
        catch (Exception e) {
            throw new JspException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reuse(Tag handler) {
        TagHandlerPool tagHandlerPool = this;
        synchronized (tagHandlerPool) {
            if (this.current < this.handlers.length - 1) {
                this.handlers[++this.current] = handler;
                return;
            }
        }
        handler.release();
    }

    public synchronized void release() {
        for (int i = this.current; i >= 0; --i) {
            this.handlers[i].release();
        }
    }

    protected static String getOption(ServletConfig config, String name, String defaultV) {
        if (config == null) {
            return defaultV;
        }
        String value2 = config.getInitParameter(name);
        if (value2 != null) {
            return value2;
        }
        if (config.getServletContext() == null) {
            return defaultV;
        }
        value2 = config.getServletContext().getInitParameter(name);
        if (value2 != null) {
            return value2;
        }
        return defaultV;
    }
}

