/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import org.apache.jasper.JasperException;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.compiler.PageInfo;

public class TextOptimizer {
    public static void concatenate(Compiler compiler, Node.Nodes page) throws JasperException {
        TextCatVisitor v;
        boolean trim2;
        Options options = compiler.getCompilationContext().getOptions();
        PageInfo pageInfo = compiler.getPageInfo();
        boolean bl = trim2 = options.getTrimSpaces() || pageInfo.isTrimDirectiveWhitespaces();
        if (trim2) {
            v = new TextCatVisitor(true, trim2);
            page.visit(v);
            v.collectText();
        }
        v = new TextCatVisitor(false, trim2);
        page.visit(v);
        v.collectText();
    }

    static class TextCatVisitor
    extends Node.Visitor {
        private int textNodeCount = 0;
        private Node.TemplateText firstTextNode = null;
        private StringBuffer textBuffer;
        private final String emptyText = new String("");
        private boolean prePass;
        private boolean trim;

        public TextCatVisitor(boolean prePass, boolean trim2) {
            this.prePass = prePass;
            this.trim = trim2;
        }

        public void doVisit(Node n) throws JasperException {
            this.collectText();
        }

        public void visit(Node.PageDirective n) throws JasperException {
            if (this.prePass) {
                this.collectText();
            }
        }

        public void visit(Node.TagDirective n) throws JasperException {
            if (this.prePass) {
                this.collectText();
            }
        }

        public void visit(Node.TaglibDirective n) throws JasperException {
            if (this.prePass) {
                this.collectText();
            }
        }

        public void visit(Node.AttributeDirective n) throws JasperException {
            if (this.prePass) {
                this.collectText();
            }
        }

        public void visit(Node.VariableDirective n) throws JasperException {
            if (this.prePass) {
                this.collectText();
            }
        }

        public void visitBody(Node n) throws JasperException {
            super.visitBody(n);
            this.collectText();
        }

        public void visit(Node.TemplateText n) throws JasperException {
            if (this.trim && !this.prePass && n.isAllSpace()) {
                n.setText(this.emptyText);
                return;
            }
            if (this.textNodeCount++ == 0) {
                this.firstTextNode = n;
                this.textBuffer = new StringBuffer(n.getText());
            } else {
                this.textBuffer.append(n.getText());
                n.setText(this.emptyText);
            }
        }

        private void collectText() {
            if (this.textNodeCount > 1) {
                this.firstTextNode.setText(this.textBuffer.toString());
            }
            this.textNodeCount = 0;
        }
    }
}

