/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import com.sun.org.apache.commons.logging.Log;
import com.sun.org.apache.commons.logging.LogFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspFactory;
import org.apache.jasper.Constants;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.runtime.JspFactoryImpl;
import org.apache.jasper.security.SecurityClassLoad;
import org.apache.jasper.servlet.JspCServletContext;
import org.apache.jasper.servlet.JspServletWrapper;
import org.apache.jasper.util.SystemLogHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JspRuntimeContext
implements Runnable {
    private static Log log = LogFactory.getLog(JspRuntimeContext.class);
    private int jspReloadCount;
    private ServletContext context;
    private Options options;
    private URLClassLoader parentClassLoader;
    private PermissionCollection permissionCollection;
    private CodeSource codeSource;
    private String classpath;
    private Map<String, JspServletWrapper> jsps;
    private Map<String, byte[]> bytecodes;
    private Map<String, Long> bytecodeBirthTimes;
    private Map<String, ArrayList<Object>> packageMap;
    private Thread thread = null;
    private boolean threadDone = false;
    private String threadName = "JspRuntimeContext";

    public JspRuntimeContext(ServletContext context, Options options) {
        System.setErr(new SystemLogHandler(System.err));
        this.context = context;
        this.options = options;
        int hashSize = options.getInitialCapacity();
        this.jsps = new ConcurrentHashMap<String, JspServletWrapper>(hashSize);
        this.bytecodes = new ConcurrentHashMap<String, byte[]>(hashSize);
        this.bytecodeBirthTimes = new ConcurrentHashMap<String, Long>(hashSize);
        this.parentClassLoader = (URLClassLoader)Thread.currentThread().getContextClassLoader();
        if (this.parentClassLoader == null) {
            this.parentClassLoader = (URLClassLoader)this.getClass().getClassLoader();
        }
        if (log.isTraceEnabled()) {
            if (this.parentClassLoader != null) {
                log.trace(Localizer.getMessage("jsp.message.parent_class_loader_is", this.parentClassLoader.toString()));
            } else {
                log.trace(Localizer.getMessage("jsp.message.parent_class_loader_is", "<none>"));
            }
        }
        this.initClassPath();
        if (context instanceof JspCServletContext) {
            return;
        }
        if (Constants.IS_SECURITY_ENABLED) {
            this.initSecurity();
        }
        String appBase = context.getRealPath("/");
        if (!options.getDevelopment() && appBase != null && options.getCheckInterval() > 0) {
            if (appBase.endsWith(File.separator)) {
                appBase = appBase.substring(0, appBase.length() - 1);
            }
            String directory = appBase.substring(appBase.lastIndexOf(File.separator));
            this.threadName = this.threadName + "[" + directory + "]";
            this.threadStart();
        }
    }

    public void addWrapper(String jspUri, JspServletWrapper jsw) {
        this.jsps.remove(jspUri);
        this.jsps.put(jspUri, jsw);
    }

    public JspServletWrapper getWrapper(String jspUri) {
        return this.jsps.get(jspUri);
    }

    public void removeWrapper(String jspUri) {
        this.jsps.remove(jspUri);
    }

    public int getJspCount() {
        return this.jsps.size();
    }

    public CodeSource getCodeSource() {
        return this.codeSource;
    }

    public URLClassLoader getParentClassLoader() {
        return this.parentClassLoader;
    }

    public PermissionCollection getPermissionCollection() {
        return this.permissionCollection;
    }

    public void destroy() {
        if (System.err instanceof SystemLogHandler) {
            System.setErr(((SystemLogHandler)System.err).getWrapped());
        }
        this.threadStop();
        for (JspServletWrapper jsw : this.jsps.values()) {
            jsw.destroy();
        }
        this.parentClassLoader = null;
    }

    public synchronized void incrementJspReloadCount() {
        ++this.jspReloadCount;
    }

    public synchronized void setJspReloadCount(int count2) {
        this.jspReloadCount = count2;
    }

    public int getJspReloadCount() {
        return this.jspReloadCount;
    }

    public void setBytecode(String name, byte[] bytecode) {
        if (bytecode == null) {
            this.bytecodes.remove(name);
            this.bytecodeBirthTimes.remove(name);
            return;
        }
        this.bytecodes.put(name, bytecode);
        this.bytecodeBirthTimes.put(name, System.currentTimeMillis());
    }

    public void adjustBytecodeTime(String name, long reference) {
        Long time = this.bytecodeBirthTimes.get(name);
        if (time == null) {
            return;
        }
        if (time < reference) {
            this.bytecodeBirthTimes.put(name, reference);
        }
    }

    public Map<String, byte[]> getBytecodes() {
        return this.bytecodes;
    }

    public byte[] getBytecode(String name) {
        return this.bytecodes.get(name);
    }

    public long getBytecodeBirthTime(String name) {
        Long time = this.bytecodeBirthTimes.get(name);
        return time != null ? time : 0L;
    }

    public Map<String, ArrayList<Object>> getPackageMap() {
        if (this.packageMap == null) {
            this.packageMap = new HashMap<String, ArrayList<Object>>();
        }
        return this.packageMap;
    }

    public void saveBytecode(String className, String classFileName) {
        byte[] bytecode = this.getBytecode(className);
        if (bytecode != null) {
            try {
                FileOutputStream fos = new FileOutputStream(classFileName);
                fos.write(bytecode);
                fos.close();
            }
            catch (IOException ex) {
                this.context.log("Error in saving bytecode for " + className + " to " + classFileName, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCompile() {
        for (JspServletWrapper jsw : this.jsps.values()) {
            if (jsw.isTagFile()) continue;
            JspCompilationContext ctxt = jsw.getJspEngineContext();
            JspServletWrapper jspServletWrapper = jsw;
            synchronized (jspServletWrapper) {
                try {
                    ctxt.compile();
                }
                catch (FileNotFoundException ex) {
                    ctxt.incrementRemoved();
                }
                catch (Throwable t) {
                    jsw.getServletContext().log("Background compile failed", t);
                }
            }
        }
    }

    public String getClassPath() {
        return this.classpath;
    }

    private void initClassPath() {
        block4: {
            URL[] urls = this.parentClassLoader.getURLs();
            StringBuffer cpath = new StringBuffer();
            String sep = System.getProperty("path.separator");
            for (int i = 0; i < urls.length; ++i) {
                if (!urls[i].getProtocol().equals("file")) continue;
                cpath.append(urls[i].getFile() + sep);
            }
            cpath.append(this.options.getScratchDir() + sep);
            String cp = (String)this.context.getAttribute("org.apache.catalina.jsp_classpath");
            if (cp == null || cp.equals("")) {
                cp = this.options.getClassPath();
            }
            this.classpath = cpath.toString() + cp;
            try {
                this.classpath = URLDecoder.decode(this.classpath, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                if (!log.isDebugEnabled()) break block4;
                log.debug("Exception decoding classpath : " + this.classpath, e);
            }
        }
    }

    private void initSecurity() {
        Policy policy = Policy.getPolicy();
        if (policy != null) {
            try {
                String codeBase;
                String docBase = this.context.getRealPath("/");
                if (docBase == null) {
                    docBase = this.options.getScratchDir().toString();
                }
                if (!(codeBase = docBase).endsWith(File.separator)) {
                    codeBase = codeBase + File.separator;
                }
                File contextDir = new File(codeBase);
                URL url = contextDir.getCanonicalFile().toURL();
                this.codeSource = new CodeSource(url, (Certificate[])null);
                this.permissionCollection = policy.getPermissions(this.codeSource);
                if (!docBase.endsWith(File.separator)) {
                    this.permissionCollection.add(new FilePermission(docBase, "read"));
                    docBase = docBase + File.separator;
                } else {
                    this.permissionCollection.add(new FilePermission(docBase.substring(0, docBase.length() - 1), "read"));
                }
                docBase = docBase + "-";
                this.permissionCollection.add(new FilePermission(docBase, "read"));
                String workDir = this.options.getScratchDir().toString();
                if (!workDir.endsWith(File.separator)) {
                    this.permissionCollection.add(new FilePermission(workDir, "read"));
                    workDir = workDir + File.separator;
                }
                workDir = workDir + "-";
                this.permissionCollection.add(new FilePermission(workDir, "read"));
                this.permissionCollection.add(new RuntimePermission("accessClassInPackage.org.apache.jasper.runtime"));
                if (this.parentClassLoader instanceof URLClassLoader) {
                    URL[] urls = this.parentClassLoader.getURLs();
                    String jarUrl = null;
                    String jndiUrl = null;
                    for (int i = 0; i < urls.length; ++i) {
                        if (jndiUrl == null && urls[i].toString().startsWith("jndi:")) {
                            jndiUrl = urls[i].toString() + "-";
                        }
                        if (jarUrl != null || !urls[i].toString().startsWith("jar:jndi:")) continue;
                        jarUrl = urls[i].toString();
                        jarUrl = jarUrl.substring(0, jarUrl.length() - 2);
                        jarUrl = jarUrl.substring(0, jarUrl.lastIndexOf(47)) + "/-";
                    }
                    if (jarUrl != null) {
                        this.permissionCollection.add(new FilePermission(jarUrl, "read"));
                        this.permissionCollection.add(new FilePermission(jarUrl.substring(4), "read"));
                    }
                    if (jndiUrl != null) {
                        this.permissionCollection.add(new FilePermission(jndiUrl, "read"));
                    }
                }
            }
            catch (Exception e) {
                this.context.log("Security Init for context failed", e);
            }
        }
    }

    protected void threadStart() {
        if (this.thread != null) {
            return;
        }
        this.threadDone = false;
        this.thread = new Thread((Runnable)this, this.threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    protected void threadStop() {
        if (this.thread == null) {
            return;
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread = null;
    }

    protected void threadSleep() {
        try {
            Thread.sleep((long)this.options.getCheckInterval() * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        while (!this.threadDone) {
            this.threadSleep();
            try {
                this.checkCompile();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    static {
        JspFactoryImpl factory = new JspFactoryImpl();
        SecurityClassLoad.securityClassLoad(factory.getClass().getClassLoader());
        if (System.getSecurityManager() != null) {
            String basePackage = "org.apache.jasper.";
            try {
                factory.getClass().getClassLoader().loadClass(basePackage + "runtime.JspFactoryImpl$PrivilegedGetPageContext");
                factory.getClass().getClassLoader().loadClass(basePackage + "runtime.JspFactoryImpl$PrivilegedReleasePageContext");
                factory.getClass().getClassLoader().loadClass(basePackage + "runtime.JspRuntimeLibrary");
                factory.getClass().getClassLoader().loadClass(basePackage + "runtime.JspRuntimeLibrary$PrivilegedIntrospectHelper");
                factory.getClass().getClassLoader().loadClass(basePackage + "runtime.ServletResponseWrapperInclude");
                factory.getClass().getClassLoader().loadClass(basePackage + "servlet.JspServletWrapper");
            }
            catch (ClassNotFoundException ex) {
                log.error("Jasper JspRuntimeContext preload of class failed: " + ex.getMessage(), ex);
            }
        }
        JspFactory.setDefaultFactory(factory);
    }
}

