/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.Node;

class BeanRepository {
    private Vector sessionBeans;
    private Vector pageBeans;
    private Vector appBeans;
    private Vector requestBeans;
    private Hashtable beanTypes;
    private ClassLoader loader;
    private ErrorDispatcher errDispatcher;

    public BeanRepository(ClassLoader loader, ErrorDispatcher err2) {
        this.loader = loader;
        this.errDispatcher = err2;
        this.sessionBeans = new Vector(11);
        this.pageBeans = new Vector(11);
        this.appBeans = new Vector(11);
        this.requestBeans = new Vector(11);
        this.beanTypes = new Hashtable();
    }

    public void addBean(Node.UseBean n, String s2, String type, String scope) throws JasperException {
        if (scope == null || scope.equals("page")) {
            this.pageBeans.addElement(s2);
        } else if (scope.equals("request")) {
            this.requestBeans.addElement(s2);
        } else if (scope.equals("session")) {
            this.sessionBeans.addElement(s2);
        } else if (scope.equals("application")) {
            this.appBeans.addElement(s2);
        } else {
            this.errDispatcher.jspError((Node)n, "jsp.error.invalid.scope", scope);
        }
        this.putBeanType(s2, type);
    }

    public Class getBeanType(String bean) throws JasperException {
        Class<?> clazz = null;
        try {
            clazz = this.loader.loadClass((String)this.beanTypes.get(bean));
        }
        catch (ClassNotFoundException ex) {
            throw new JasperException(ex);
        }
        return clazz;
    }

    public boolean checkVariable(String bean) {
        return this.checkPageBean(bean) || this.checkSessionBean(bean) || this.checkRequestBean(bean) || this.checkApplicationBean(bean);
    }

    private void putBeanType(String bean, String type) {
        this.beanTypes.put(bean, type);
    }

    private boolean checkPageBean(String s2) {
        return this.pageBeans.contains(s2);
    }

    private boolean checkRequestBean(String s2) {
        return this.requestBeans.contains(s2);
    }

    private boolean checkSessionBean(String s2) {
        return this.sessionBeans.contains(s2);
    }

    private boolean checkApplicationBean(String s2) {
        return this.appBeans.contains(s2);
    }
}

