/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenRenewer;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenRequest;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class RMDelegationTokenIdentifier
extends AbstractDelegationTokenIdentifier {
    public static final Text KIND_NAME = new Text("RM_DELEGATION_TOKEN");

    public RMDelegationTokenIdentifier() {
    }

    public RMDelegationTokenIdentifier(Text owner, Text renewer, Text realUser) {
        super(owner, renewer, realUser);
    }

    @Override
    public Text getKind() {
        return KIND_NAME;
    }

    public static class Renewer
    extends TokenRenewer {
        private static AbstractDelegationTokenSecretManager<RMDelegationTokenIdentifier> localSecretManager;
        private static InetSocketAddress localServiceAddress;

        @Override
        public boolean handleKind(Text kind) {
            return KIND_NAME.equals(kind);
        }

        @Override
        public boolean isManaged(Token<?> token2) throws IOException {
            return true;
        }

        @InterfaceAudience.Private
        public static void setSecretManager(AbstractDelegationTokenSecretManager<RMDelegationTokenIdentifier> secretManager, InetSocketAddress serviceAddress) {
            localSecretManager = secretManager;
            localServiceAddress = serviceAddress;
        }

        @Override
        public long renew(Token<?> token2, Configuration conf) throws IOException, InterruptedException {
            ApplicationClientProtocol rmClient = Renewer.getRmClient(token2, conf);
            if (rmClient != null) {
                try {
                    RenewDelegationTokenRequest request = Records.newRecord(RenewDelegationTokenRequest.class);
                    request.setDelegationToken(Renewer.convertToProtoToken(token2));
                    long l = rmClient.renewDelegationToken(request).getNextExpirationTime();
                    return l;
                }
                catch (YarnException e) {
                    throw new IOException(e);
                }
                finally {
                    RPC.stopProxy(rmClient);
                }
            }
            return localSecretManager.renewToken(token2, Renewer.getRenewer(token2));
        }

        @Override
        public void cancel(Token<?> token2, Configuration conf) throws IOException, InterruptedException {
            ApplicationClientProtocol rmClient = Renewer.getRmClient(token2, conf);
            if (rmClient != null) {
                try {
                    CancelDelegationTokenRequest request = Records.newRecord(CancelDelegationTokenRequest.class);
                    request.setDelegationToken(Renewer.convertToProtoToken(token2));
                    rmClient.cancelDelegationToken(request);
                }
                catch (YarnException e) {
                    throw new IOException(e);
                }
                finally {
                    RPC.stopProxy(rmClient);
                }
            } else {
                localSecretManager.cancelToken(token2, Renewer.getRenewer(token2));
            }
        }

        private static ApplicationClientProtocol getRmClient(Token<?> token2, Configuration conf) {
            InetSocketAddress addr = SecurityUtil.getTokenServiceAddr(token2);
            if (localSecretManager != null && (localServiceAddress.getAddress().isAnyLocalAddress() ? NetUtils.isLocalAddress(addr.getAddress()) && addr.getPort() == localServiceAddress.getPort() : addr.equals(localServiceAddress))) {
                return null;
            }
            YarnRPC rpc = YarnRPC.create(conf);
            return (ApplicationClientProtocol)rpc.getProxy(ApplicationClientProtocol.class, addr, conf);
        }

        private static String getRenewer(Token<?> token2) throws IOException {
            return ((RMDelegationTokenIdentifier)token2.decodeIdentifier()).getRenewer().toString();
        }

        private static org.apache.hadoop.yarn.api.records.Token convertToProtoToken(Token<?> token2) {
            return org.apache.hadoop.yarn.api.records.Token.newInstance(token2.getIdentifier(), token2.getKind().toString(), token2.getPassword(), token2.getService().toString());
        }
    }
}

