/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenSelector;
import org.apache.hadoop.yarn.security.NMTokenIdentifier;

public class NMTokenSelector
implements TokenSelector<NMTokenIdentifier> {
    private static final Log LOG = LogFactory.getLog(NMTokenSelector.class);

    @Override
    public Token<NMTokenIdentifier> selectToken(Text service, Collection<Token<? extends TokenIdentifier>> tokens) {
        if (service == null) {
            return null;
        }
        for (Token<? extends TokenIdentifier> token2 : tokens) {
            if (LOG.isDebugEnabled()) {
                LOG.info("Looking for service: " + service + ". Current token is " + token2);
            }
            if (!NMTokenIdentifier.KIND.equals(token2.getKind()) || !service.equals(token2.getService())) continue;
            return token2;
        }
        return null;
    }
}

