/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Writer;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.SecureIOUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.file.tfile.TFile;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.util.ConverterUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class AggregatedLogFormat {
    private static final Log LOG = LogFactory.getLog(AggregatedLogFormat.class);
    private static final LogKey APPLICATION_ACL_KEY = new LogKey("APPLICATION_ACL");
    private static final LogKey APPLICATION_OWNER_KEY = new LogKey("APPLICATION_OWNER");
    private static final LogKey VERSION_KEY = new LogKey("VERSION");
    private static final Map<String, LogKey> RESERVED_KEYS;
    private static final int VERSION = 1;
    private static final FsPermission APP_LOG_FILE_UMASK;

    static {
        APP_LOG_FILE_UMASK = FsPermission.createImmutable((short)95);
        RESERVED_KEYS = new HashMap<String, LogKey>();
        RESERVED_KEYS.put(APPLICATION_ACL_KEY.toString(), APPLICATION_ACL_KEY);
        RESERVED_KEYS.put(APPLICATION_OWNER_KEY.toString(), APPLICATION_OWNER_KEY);
        RESERVED_KEYS.put(VERSION_KEY.toString(), VERSION_KEY);
    }

    @InterfaceAudience.Private
    public static class ContainerLogsReader {
        private DataInputStream valueStream;
        private String currentLogType = null;
        private long currentLogLength = 0L;
        private BoundedInputStream currentLogData = null;
        private InputStreamReader currentLogISR;

        public ContainerLogsReader(DataInputStream stream) {
            this.valueStream = stream;
        }

        public String nextLog() throws IOException {
            if (this.currentLogData != null && this.currentLogLength > 0L) {
                while (this.currentLogData.skip(this.currentLogLength) >= 0L && this.currentLogData.read() != -1) {
                }
            }
            this.currentLogType = null;
            this.currentLogLength = 0L;
            this.currentLogData = null;
            this.currentLogISR = null;
            try {
                String logType = this.valueStream.readUTF();
                String logLengthStr = this.valueStream.readUTF();
                this.currentLogLength = Long.parseLong(logLengthStr);
                this.currentLogData = new BoundedInputStream(this.valueStream, this.currentLogLength);
                this.currentLogData.setPropagateClose(false);
                this.currentLogISR = new InputStreamReader(this.currentLogData);
                this.currentLogType = logType;
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            return this.currentLogType;
        }

        public String getCurrentLogType() {
            return this.currentLogType;
        }

        public long getCurrentLogLength() {
            return this.currentLogLength;
        }

        public long skip(long n) throws IOException {
            return this.currentLogData.skip(n);
        }

        public int read(byte[] buf, int off, int len) throws IOException {
            return this.currentLogData.read(buf, off, len);
        }

        public int read(char[] buf, int off, int len) throws IOException {
            return this.currentLogISR.read(buf, off, len);
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static class LogReader {
        private final FSDataInputStream fsDataIStream;
        private final TFile.Reader.Scanner scanner;
        private final TFile.Reader reader;
        private boolean atBeginning = true;

        public LogReader(Configuration conf, Path remoteAppLogFile) throws IOException {
            FileContext fileContext = FileContext.getFileContext(conf);
            this.fsDataIStream = fileContext.open(remoteAppLogFile);
            this.reader = new TFile.Reader(this.fsDataIStream, fileContext.getFileStatus(remoteAppLogFile).getLen(), conf);
            this.scanner = this.reader.createScanner();
        }

        public String getApplicationOwner() throws IOException {
            TFile.Reader.Scanner ownerScanner = this.reader.createScanner();
            LogKey key = new LogKey();
            while (!ownerScanner.atEnd()) {
                TFile.Reader.Scanner.Entry entry2 = ownerScanner.entry();
                key.readFields(entry2.getKeyStream());
                if (key.toString().equals(APPLICATION_OWNER_KEY.toString())) {
                    DataInputStream valueStream = entry2.getValueStream();
                    return valueStream.readUTF();
                }
                ownerScanner.advance();
            }
            return null;
        }

        public Map<ApplicationAccessType, String> getApplicationAcls() throws IOException {
            TFile.Reader.Scanner aclScanner = this.reader.createScanner();
            LogKey key = new LogKey();
            HashMap<ApplicationAccessType, String> acls = new HashMap<ApplicationAccessType, String>();
            while (!aclScanner.atEnd()) {
                TFile.Reader.Scanner.Entry entry2 = aclScanner.entry();
                key.readFields(entry2.getKeyStream());
                if (key.toString().equals(APPLICATION_ACL_KEY.toString())) {
                    DataInputStream valueStream = entry2.getValueStream();
                    while (true) {
                        String appAccessOp = null;
                        String aclString = null;
                        try {
                            appAccessOp = valueStream.readUTF();
                        }
                        catch (EOFException e) {
                            break;
                        }
                        try {
                            aclString = valueStream.readUTF();
                        }
                        catch (EOFException e) {
                            throw new YarnRuntimeException("Error reading ACLs", e);
                        }
                        acls.put(ApplicationAccessType.valueOf(appAccessOp), aclString);
                    }
                }
                aclScanner.advance();
            }
            return acls;
        }

        public DataInputStream next(LogKey key) throws IOException {
            if (!this.atBeginning) {
                this.scanner.advance();
            } else {
                this.atBeginning = false;
            }
            if (this.scanner.atEnd()) {
                return null;
            }
            TFile.Reader.Scanner.Entry entry2 = this.scanner.entry();
            key.readFields(entry2.getKeyStream());
            if (RESERVED_KEYS.containsKey(key.toString())) {
                return this.next(key);
            }
            DataInputStream valueStream = entry2.getValueStream();
            return valueStream;
        }

        @InterfaceAudience.Private
        public ContainerLogsReader getContainerLogsReader(ContainerId containerId) throws IOException {
            ContainerLogsReader logReader = null;
            LogKey containerKey = new LogKey(containerId);
            LogKey key = new LogKey();
            DataInputStream valueStream = this.next(key);
            while (valueStream != null && !key.equals(containerKey)) {
                valueStream = this.next(key);
            }
            if (valueStream != null) {
                logReader = new ContainerLogsReader(valueStream);
            }
            return logReader;
        }

        public static void readAcontainerLogs(DataInputStream valueStream, Writer writer) throws IOException {
            int bufferSize = 65536;
            char[] cbuf = new char[bufferSize];
            block2: while (true) {
                String fileType;
                try {
                    fileType = valueStream.readUTF();
                }
                catch (EOFException e) {
                    return;
                }
                String fileLengthStr = valueStream.readUTF();
                long fileLength = Long.parseLong(fileLengthStr);
                writer.write("\n\nLogType:");
                writer.write(fileType);
                writer.write("\nLogLength:");
                writer.write(fileLengthStr);
                writer.write("\nLog Contents:\n");
                BoundedInputStream bis = new BoundedInputStream(valueStream, fileLength);
                InputStreamReader reader = new InputStreamReader(bis);
                int currentRead = 0;
                int totalRead = 0;
                while (true) {
                    if ((currentRead = reader.read(cbuf, 0, bufferSize)) == -1) continue block2;
                    writer.write(cbuf, 0, currentRead);
                    totalRead += currentRead;
                }
                break;
            }
        }

        public static void readAContainerLogsForALogType(DataInputStream valueStream, PrintStream out) throws IOException {
            byte[] buf = new byte[65535];
            String fileType = valueStream.readUTF();
            String fileLengthStr = valueStream.readUTF();
            long fileLength = Long.parseLong(fileLengthStr);
            out.print("LogType: ");
            out.println(fileType);
            out.print("LogLength: ");
            out.println(fileLengthStr);
            out.println("Log Contents:");
            int curRead = 0;
            long pendingRead = fileLength - (long)curRead;
            int toRead = pendingRead > (long)buf.length ? buf.length : (int)pendingRead;
            int len = valueStream.read(buf, 0, toRead);
            while (len != -1 && (long)curRead < fileLength) {
                out.write(buf, 0, len);
                pendingRead = fileLength - (long)(curRead += len);
                toRead = pendingRead > (long)buf.length ? buf.length : (int)pendingRead;
                len = valueStream.read(buf, 0, toRead);
            }
            out.println("");
        }

        public void close() throws IOException {
            this.scanner.close();
            this.fsDataIStream.close();
        }
    }

    @InterfaceAudience.Private
    public static class LogWriter {
        private final FSDataOutputStream fsDataOStream;
        private final TFile.Writer writer;

        public LogWriter(final Configuration conf, final Path remoteAppLogFile, UserGroupInformation userUgi) throws IOException {
            try {
                this.fsDataOStream = userUgi.doAs(new PrivilegedExceptionAction<FSDataOutputStream>(){

                    @Override
                    public FSDataOutputStream run() throws Exception {
                        FileContext fc = FileContext.getFileContext(conf);
                        fc.setUMask(APP_LOG_FILE_UMASK);
                        return fc.create(remoteAppLogFile, EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), new Options.CreateOpts[0]);
                    }
                });
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            this.writer = new TFile.Writer(this.fsDataOStream, 262144, conf.get("yarn.nodemanager.log-aggregation.compression-type", "none"), null, conf);
            this.writeVersion();
        }

        private void writeVersion() throws IOException {
            DataOutputStream out = this.writer.prepareAppendKey(-1);
            VERSION_KEY.write(out);
            out.close();
            out = this.writer.prepareAppendValue(-1);
            out.writeInt(1);
            out.close();
        }

        public void writeApplicationOwner(String user) throws IOException {
            DataOutputStream out = this.writer.prepareAppendKey(-1);
            APPLICATION_OWNER_KEY.write(out);
            out.close();
            out = this.writer.prepareAppendValue(-1);
            out.writeUTF(user);
            out.close();
        }

        public void writeApplicationACLs(Map<ApplicationAccessType, String> appAcls) throws IOException {
            DataOutputStream out = this.writer.prepareAppendKey(-1);
            APPLICATION_ACL_KEY.write(out);
            out.close();
            out = this.writer.prepareAppendValue(-1);
            for (Map.Entry<ApplicationAccessType, String> entry2 : appAcls.entrySet()) {
                out.writeUTF(entry2.getKey().toString());
                out.writeUTF(entry2.getValue());
            }
            out.close();
        }

        public void append(LogKey logKey, LogValue logValue) throws IOException {
            DataOutputStream out = this.writer.prepareAppendKey(-1);
            logKey.write(out);
            out.close();
            out = this.writer.prepareAppendValue(-1);
            logValue.write(out);
            out.close();
        }

        public void closeWriter() {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                LOG.warn("Exception closing writer", e);
            }
            try {
                this.fsDataOStream.close();
            }
            catch (IOException e) {
                LOG.warn("Exception closing output-stream", e);
            }
        }
    }

    @InterfaceAudience.Private
    public static class LogValue {
        private final List<String> rootLogDirs;
        private final ContainerId containerId;
        private final String user;

        public LogValue(List<String> rootLogDirs, ContainerId containerId, String user) {
            this.rootLogDirs = new ArrayList<String>(rootLogDirs);
            this.containerId = containerId;
            this.user = user;
            Collections.sort(this.rootLogDirs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(DataOutputStream out) throws IOException {
            for (String rootLogDir : this.rootLogDirs) {
                File appLogDir = new File(rootLogDir, ConverterUtils.toString(this.containerId.getApplicationAttemptId().getApplicationId()));
                File containerLogDir = new File(appLogDir, ConverterUtils.toString(this.containerId));
                if (!containerLogDir.isDirectory()) continue;
                Object[] logFiles = containerLogDir.listFiles();
                Arrays.sort(logFiles);
                for (Object logFile : logFiles) {
                    out.writeUTF(((File)logFile).getName());
                    out.writeUTF(String.valueOf(((File)logFile).length()));
                    FileInputStream in = null;
                    try {
                        in = SecureIOUtils.openForRead((File)logFile, this.getUser(), null);
                        byte[] buf = new byte[65535];
                        int len = 0;
                        while ((len = in.read(buf)) != -1) {
                            out.write(buf, 0, len);
                        }
                    }
                    catch (IOException e) {
                        String message = "Error aggregating log file. Log file : " + ((File)logFile).getAbsolutePath() + e.getMessage();
                        LOG.error(message, e);
                        out.write(message.getBytes());
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
            }
        }

        public String getUser() {
            return this.user;
        }
    }

    @InterfaceAudience.Public
    public static class LogKey
    implements Writable {
        private String keyString;

        public LogKey() {
        }

        public LogKey(ContainerId containerId) {
            this.keyString = containerId.toString();
        }

        public LogKey(String keyString) {
            this.keyString = keyString;
        }

        public int hashCode() {
            return this.keyString == null ? 0 : this.keyString.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof LogKey) {
                LogKey other = (LogKey)obj;
                if (this.keyString == null) {
                    return other.keyString == null;
                }
                return this.keyString.equals(other.keyString);
            }
            return false;
        }

        @Override
        @InterfaceAudience.Private
        public void write(DataOutput out) throws IOException {
            out.writeUTF(this.keyString);
        }

        @Override
        @InterfaceAudience.Private
        public void readFields(DataInput in) throws IOException {
            this.keyString = in.readUTF();
        }

        public String toString() {
            return this.keyString;
        }
    }
}

