/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import java.text.NumberFormat;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class ApplicationAttemptId
implements Comparable<ApplicationAttemptId> {
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static final String appAttemptIdStrPrefix = "appattempt_";
    static final ThreadLocal<NumberFormat> attemptIdFormat = new ThreadLocal<NumberFormat>(){

        @Override
        public NumberFormat initialValue() {
            NumberFormat fmt = NumberFormat.getInstance();
            fmt.setGroupingUsed(false);
            fmt.setMinimumIntegerDigits(6);
            return fmt;
        }
    };

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static ApplicationAttemptId newInstance(ApplicationId appId, int attemptId) {
        ApplicationAttemptId appAttemptId = Records.newRecord(ApplicationAttemptId.class);
        appAttemptId.setApplicationId(appId);
        appAttemptId.setAttemptId(attemptId);
        appAttemptId.build();
        return appAttemptId;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract ApplicationId getApplicationId();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    protected abstract void setApplicationId(ApplicationId var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract int getAttemptId();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    protected abstract void setAttemptId(int var1);

    public int hashCode() {
        int prime = 347671;
        int result2 = 5501;
        ApplicationId appId = this.getApplicationId();
        result2 = 347671 * result2 + appId.hashCode();
        result2 = 347671 * result2 + this.getAttemptId();
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApplicationAttemptId other = (ApplicationAttemptId)obj;
        if (!this.getApplicationId().equals(other.getApplicationId())) {
            return false;
        }
        return this.getAttemptId() == other.getAttemptId();
    }

    @Override
    public int compareTo(ApplicationAttemptId other) {
        int compareAppIds = this.getApplicationId().compareTo(other.getApplicationId());
        if (compareAppIds == 0) {
            return this.getAttemptId() - other.getAttemptId();
        }
        return compareAppIds;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(appAttemptIdStrPrefix);
        sb.append(this.getApplicationId().getClusterTimestamp()).append("_");
        sb.append(ApplicationId.appIdFormat.get().format(this.getApplicationId().getId()));
        sb.append("_").append(attemptIdFormat.get().format(this.getAttemptId()));
        return sb.toString();
    }

    protected abstract void build();
}

