/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import com.google.common.collect.ComparisonChain;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public abstract class VersionUtil {
    private static final Pattern COMPONENT_GROUPS = Pattern.compile("(\\d+)|(\\D+)");
    private static final String SNAPSHOT_SUFFIX = "-SNAPSHOT";

    public static int compareVersions(String version1, String version2) {
        boolean isSnapshot1 = version1.endsWith(SNAPSHOT_SUFFIX);
        boolean isSnapshot2 = version2.endsWith(SNAPSHOT_SUFFIX);
        version1 = VersionUtil.stripSnapshotSuffix(version1);
        version2 = VersionUtil.stripSnapshotSuffix(version2);
        String[] version1Parts = version1.split("\\.");
        String[] version2Parts = version2.split("\\.");
        for (int i = 0; i < version1Parts.length && i < version2Parts.length; ++i) {
            String component1 = version1Parts[i];
            String component2 = version2Parts[i];
            if (component1.equals(component2)) continue;
            Matcher matcher1 = COMPONENT_GROUPS.matcher(component1);
            Matcher matcher2 = COMPONENT_GROUPS.matcher(component2);
            while (matcher1.find() && matcher2.find()) {
                String group2;
                String group1 = matcher1.group();
                if (group1.equals(group2 = matcher2.group())) continue;
                if (VersionUtil.isNumeric(group1) && VersionUtil.isNumeric(group2)) {
                    return Integer.parseInt(group1) - Integer.parseInt(group2);
                }
                if (!VersionUtil.isNumeric(group1) && !VersionUtil.isNumeric(group2)) {
                    return group1.compareTo(group2);
                }
                return VersionUtil.isNumeric(group1) ? -1 : 1;
            }
            return component1.length() - component2.length();
        }
        return ComparisonChain.start().compare(version1Parts.length, version2Parts.length).compare(isSnapshot2, isSnapshot1).result();
    }

    private static String stripSnapshotSuffix(String version) {
        if (version.endsWith(SNAPSHOT_SUFFIX)) {
            return version.substring(0, version.length() - SNAPSHOT_SUFFIX.length());
        }
        return version;
    }

    private static boolean isNumeric(String s2) {
        try {
            Integer.parseInt(s2);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }
}

