/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class Credentials
implements Writable {
    private static final Log LOG = LogFactory.getLog(Credentials.class);
    private Map<Text, byte[]> secretKeysMap = new HashMap<Text, byte[]>();
    private Map<Text, Token<? extends TokenIdentifier>> tokenMap = new HashMap<Text, Token<? extends TokenIdentifier>>();
    private static final byte[] TOKEN_STORAGE_MAGIC = "HDTS".getBytes();
    private static final byte TOKEN_STORAGE_VERSION = 0;

    public Credentials() {
    }

    public Credentials(Credentials credentials) {
        this.addAll(credentials);
    }

    public byte[] getSecretKey(Text alias) {
        return this.secretKeysMap.get(alias);
    }

    public Token<? extends TokenIdentifier> getToken(Text alias) {
        return this.tokenMap.get(alias);
    }

    public void addToken(Text alias, Token<? extends TokenIdentifier> t) {
        if (t != null) {
            this.tokenMap.put(alias, t);
        } else {
            LOG.warn("Null token ignored for " + alias);
        }
    }

    public Collection<Token<? extends TokenIdentifier>> getAllTokens() {
        return this.tokenMap.values();
    }

    public int numberOfTokens() {
        return this.tokenMap.size();
    }

    public int numberOfSecretKeys() {
        return this.secretKeysMap.size();
    }

    public void addSecretKey(Text alias, byte[] key) {
        this.secretKeysMap.put(alias, key);
    }

    public static Credentials readTokenStorageFile(Path filename, Configuration conf) throws IOException {
        Credentials credentials;
        FSDataInputStream in = null;
        Credentials credentials2 = new Credentials();
        try {
            in = filename.getFileSystem(conf).open(filename);
            credentials2.readTokenStorageStream(in);
            in.close();
            credentials = credentials2;
        }
        catch (IOException ioe) {
            try {
                throw new IOException("Exception reading " + filename, ioe);
            }
            catch (Throwable throwable) {
                IOUtils.cleanup(LOG, in);
                throw throwable;
            }
        }
        IOUtils.cleanup(LOG, in);
        return credentials;
    }

    public static Credentials readTokenStorageFile(File filename, Configuration conf) throws IOException {
        Credentials credentials;
        DataInputStream in = null;
        Credentials credentials2 = new Credentials();
        try {
            in = new DataInputStream(new BufferedInputStream(new FileInputStream(filename)));
            credentials2.readTokenStorageStream(in);
            credentials = credentials2;
        }
        catch (IOException ioe) {
            try {
                throw new IOException("Exception reading " + filename, ioe);
            }
            catch (Throwable throwable) {
                IOUtils.cleanup(LOG, in);
                throw throwable;
            }
        }
        IOUtils.cleanup(LOG, in);
        return credentials;
    }

    public void readTokenStorageStream(DataInputStream in) throws IOException {
        byte[] magic = new byte[TOKEN_STORAGE_MAGIC.length];
        in.readFully(magic);
        if (!Arrays.equals(magic, TOKEN_STORAGE_MAGIC)) {
            throw new IOException("Bad header found in token storage.");
        }
        byte version = in.readByte();
        if (version != 0) {
            throw new IOException("Unknown version " + version + " in token storage.");
        }
        this.readFields(in);
    }

    public void writeTokenStorageToStream(DataOutputStream os) throws IOException {
        os.write(TOKEN_STORAGE_MAGIC);
        os.write(0);
        this.write(os);
    }

    public void writeTokenStorageFile(Path filename, Configuration conf) throws IOException {
        FSDataOutputStream os = filename.getFileSystem(conf).create(filename);
        this.writeTokenStorageToStream(os);
        os.close();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt(out, this.tokenMap.size());
        for (Map.Entry<Text, Token<? extends TokenIdentifier>> entry2 : this.tokenMap.entrySet()) {
            entry2.getKey().write(out);
            entry2.getValue().write(out);
        }
        WritableUtils.writeVInt(out, this.secretKeysMap.size());
        for (Map.Entry<Text, Token<? extends TokenIdentifier>> entry3 : this.secretKeysMap.entrySet()) {
            entry3.getKey().write(out);
            WritableUtils.writeVInt(out, ((byte[])entry3.getValue()).length);
            out.write((byte[])entry3.getValue());
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        Text alias;
        int i;
        this.secretKeysMap.clear();
        this.tokenMap.clear();
        int size2 = WritableUtils.readVInt(in);
        for (i = 0; i < size2; ++i) {
            alias = new Text();
            alias.readFields(in);
            Token t = new Token();
            t.readFields(in);
            this.tokenMap.put(alias, t);
        }
        size2 = WritableUtils.readVInt(in);
        for (i = 0; i < size2; ++i) {
            alias = new Text();
            alias.readFields(in);
            int len = WritableUtils.readVInt(in);
            byte[] value2 = new byte[len];
            in.readFully(value2);
            this.secretKeysMap.put(alias, value2);
        }
    }

    public void addAll(Credentials other) {
        this.addAll(other, true);
    }

    public void mergeAll(Credentials other) {
        this.addAll(other, false);
    }

    private void addAll(Credentials other, boolean overwrite) {
        Text key;
        for (Map.Entry<Text, byte[]> entry2 : other.secretKeysMap.entrySet()) {
            key = entry2.getKey();
            if (this.secretKeysMap.containsKey(key) && !overwrite) continue;
            this.secretKeysMap.put(key, entry2.getValue());
        }
        for (Map.Entry<Text, Object> entry3 : other.tokenMap.entrySet()) {
            key = entry3.getKey();
            if (this.tokenMap.containsKey(key) && !overwrite) continue;
            this.tokenMap.put(key, (Token<? extends TokenIdentifier>)entry3.getValue());
        }
    }
}

