/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileRecordReader;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class SequenceFileInputFilter<K, V>
extends SequenceFileInputFormat<K, V> {
    public static final Log LOG = LogFactory.getLog(FileInputFormat.class);
    public static final String FILTER_CLASS = "mapreduce.input.sequencefileinputfilter.class";
    public static final String FILTER_FREQUENCY = "mapreduce.input.sequencefileinputfilter.frequency";
    public static final String FILTER_REGEX = "mapreduce.input.sequencefileinputfilter.regex";

    @Override
    public RecordReader<K, V> createRecordReader(InputSplit split2, TaskAttemptContext context) throws IOException {
        context.setStatus(split2.toString());
        return new FilterRecordReader(context.getConfiguration());
    }

    public static void setFilterClass(Job job, Class<?> filterClass) {
        job.getConfiguration().set(FILTER_CLASS, filterClass.getName());
    }

    private static class FilterRecordReader<K, V>
    extends SequenceFileRecordReader<K, V> {
        private Filter filter;
        private K key;
        private V value;

        public FilterRecordReader(Configuration conf) throws IOException {
            this.filter = (Filter)ReflectionUtils.newInstance(conf.getClass(SequenceFileInputFilter.FILTER_CLASS, PercentFilter.class), conf);
        }

        @Override
        public synchronized boolean nextKeyValue() throws IOException, InterruptedException {
            while (super.nextKeyValue()) {
                this.key = super.getCurrentKey();
                if (!this.filter.accept(this.key)) continue;
                this.value = super.getCurrentValue();
                return true;
            }
            return false;
        }

        @Override
        public K getCurrentKey() {
            return this.key;
        }

        @Override
        public V getCurrentValue() {
            return this.value;
        }
    }

    public static class MD5Filter
    extends FilterBase {
        private int frequency;
        private static final MessageDigest DIGESTER;
        public static final int MD5_LEN = 16;
        private byte[] digest = new byte[16];

        public static void setFrequency(Configuration conf, int frequency) {
            if (frequency <= 0) {
                throw new IllegalArgumentException("Negative mapreduce.input.sequencefileinputfilter.frequency: " + frequency);
            }
            conf.setInt(SequenceFileInputFilter.FILTER_FREQUENCY, frequency);
        }

        @Override
        public void setConf(Configuration conf) {
            this.frequency = conf.getInt(SequenceFileInputFilter.FILTER_FREQUENCY, 10);
            if (this.frequency <= 0) {
                throw new RuntimeException("Negative mapreduce.input.sequencefileinputfilter.frequency: " + this.frequency);
            }
            this.conf = conf;
        }

        @Override
        public boolean accept(Object key) {
            try {
                long hashcode;
                if (key instanceof Text) {
                    hashcode = this.MD5Hashcode((Text)key);
                } else if (key instanceof BytesWritable) {
                    hashcode = this.MD5Hashcode((BytesWritable)key);
                } else {
                    ByteBuffer bb = Text.encode(key.toString());
                    hashcode = this.MD5Hashcode(bb.array(), 0, bb.limit());
                }
                if (hashcode / (long)this.frequency * (long)this.frequency == hashcode) {
                    return true;
                }
            }
            catch (Exception e) {
                LOG.warn(e);
                throw new RuntimeException(e);
            }
            return false;
        }

        private long MD5Hashcode(Text key) throws DigestException {
            return this.MD5Hashcode(key.getBytes(), 0, key.getLength());
        }

        private long MD5Hashcode(BytesWritable key) throws DigestException {
            return this.MD5Hashcode(key.getBytes(), 0, key.getLength());
        }

        private synchronized long MD5Hashcode(byte[] bytes, int start, int length) throws DigestException {
            DIGESTER.update(bytes, 0, length);
            DIGESTER.digest(this.digest, 0, 16);
            long hashcode = 0L;
            for (int i = 0; i < 8; ++i) {
                hashcode |= ((long)this.digest[i] & 0xFFL) << 8 * (7 - i);
            }
            return hashcode;
        }

        static {
            try {
                DIGESTER = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class PercentFilter
    extends FilterBase {
        private int frequency;
        private int count;

        public static void setFrequency(Configuration conf, int frequency) {
            if (frequency <= 0) {
                throw new IllegalArgumentException("Negative mapreduce.input.sequencefileinputfilter.frequency: " + frequency);
            }
            conf.setInt(SequenceFileInputFilter.FILTER_FREQUENCY, frequency);
        }

        @Override
        public void setConf(Configuration conf) {
            this.frequency = conf.getInt(SequenceFileInputFilter.FILTER_FREQUENCY, 10);
            if (this.frequency <= 0) {
                throw new RuntimeException("Negative mapreduce.input.sequencefileinputfilter.frequency: " + this.frequency);
            }
            this.conf = conf;
        }

        @Override
        public boolean accept(Object key) {
            boolean accepted = false;
            if (this.count == 0) {
                accepted = true;
            }
            if (++this.count == this.frequency) {
                this.count = 0;
            }
            return accepted;
        }
    }

    public static class RegexFilter
    extends FilterBase {
        private Pattern p;

        public static void setPattern(Configuration conf, String regex) throws PatternSyntaxException {
            try {
                Pattern.compile(regex);
            }
            catch (PatternSyntaxException e) {
                throw new IllegalArgumentException("Invalid pattern: " + regex);
            }
            conf.set(SequenceFileInputFilter.FILTER_REGEX, regex);
        }

        @Override
        public void setConf(Configuration conf) {
            String regex = conf.get(SequenceFileInputFilter.FILTER_REGEX);
            if (regex == null) {
                throw new RuntimeException("mapreduce.input.sequencefileinputfilter.regexnot set");
            }
            this.p = Pattern.compile(regex);
            this.conf = conf;
        }

        @Override
        public boolean accept(Object key) {
            return this.p.matcher(key.toString()).matches();
        }
    }

    public static abstract class FilterBase
    implements Filter {
        Configuration conf;

        @Override
        public Configuration getConf() {
            return this.conf;
        }
    }

    public static interface Filter
    extends Configurable {
        public boolean accept(Object var1);
    }
}

