/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.DelegatingRecordReader;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.MultipleInputs;
import org.apache.hadoop.mapreduce.lib.input.TaggedInputSplit;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DelegatingInputFormat<K, V>
extends InputFormat<K, V> {
    @Override
    public List<InputSplit> getSplits(JobContext job) throws IOException, InterruptedException {
        Configuration conf = job.getConfiguration();
        Job jobCopy = new Job(conf);
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        Map<Path, InputFormat> formatMap = MultipleInputs.getInputFormatMap(job);
        Map<Path, Class<? extends Mapper>> mapperMap = MultipleInputs.getMapperTypeMap(job);
        HashMap formatPaths = new HashMap();
        for (Map.Entry<Path, InputFormat> entry2 : formatMap.entrySet()) {
            if (!formatPaths.containsKey(entry2.getValue().getClass())) {
                formatPaths.put(entry2.getValue().getClass(), new LinkedList());
            }
            ((List)formatPaths.get(entry2.getValue().getClass())).add(entry2.getKey());
        }
        for (Map.Entry entry3 : formatPaths.entrySet()) {
            Class<? extends Mapper<?, ?, ?, ?>> mapperClass;
            Class formatClass = (Class)((Object)entry3.getKey());
            InputFormat format2 = (InputFormat)ReflectionUtils.newInstance(formatClass, conf);
            List paths = (List)((Object)entry3.getValue());
            HashMap mapperPaths = new HashMap();
            for (Path path : paths) {
                mapperClass = mapperMap.get(path);
                if (!mapperPaths.containsKey(mapperClass)) {
                    mapperPaths.put(mapperClass, new LinkedList());
                }
                ((List)mapperPaths.get(mapperClass)).add(path);
            }
            for (Map.Entry entry4 : mapperPaths.entrySet()) {
                paths = (List)entry4.getValue();
                mapperClass = (Class<? extends Mapper<?, ?, ?, ?>>)entry4.getKey();
                if (mapperClass == null) {
                    try {
                        mapperClass = job.getMapperClass();
                    }
                    catch (ClassNotFoundException e) {
                        throw new IOException("Mapper class is not found", e);
                    }
                }
                FileInputFormat.setInputPaths(jobCopy, paths.toArray(new Path[paths.size()]));
                List<InputSplit> pathSplits = format2.getSplits(jobCopy);
                for (InputSplit pathSplit : pathSplits) {
                    splits.add(new TaggedInputSplit(pathSplit, conf, format2.getClass(), mapperClass));
                }
            }
        }
        return splits;
    }

    @Override
    public RecordReader<K, V> createRecordReader(InputSplit split2, TaskAttemptContext context) throws IOException, InterruptedException {
        return new DelegatingRecordReader(split2, context);
    }
}

