/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryParser;
import org.apache.hadoop.mapreduce.util.HostUtil;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class HistoryViewer {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("d-MMM-yyyy HH:mm:ss");
    private FileSystem fs;
    private JobHistoryParser.JobInfo job;
    private String jobId;
    private boolean printAll;
    private Comparator<JobHistoryParser.TaskAttemptInfo> cMap = new Comparator<JobHistoryParser.TaskAttemptInfo>(){

        @Override
        public int compare(JobHistoryParser.TaskAttemptInfo t1, JobHistoryParser.TaskAttemptInfo t2) {
            long l1 = t1.getFinishTime() - t1.getStartTime();
            long l2 = t2.getFinishTime() - t2.getStartTime();
            return l2 < l1 ? -1 : (l2 == l1 ? 0 : 1);
        }
    };
    private Comparator<JobHistoryParser.TaskAttemptInfo> cShuffle = new Comparator<JobHistoryParser.TaskAttemptInfo>(){

        @Override
        public int compare(JobHistoryParser.TaskAttemptInfo t1, JobHistoryParser.TaskAttemptInfo t2) {
            long l1 = t1.getShuffleFinishTime() - t1.getStartTime();
            long l2 = t2.getShuffleFinishTime() - t2.getStartTime();
            return l2 < l1 ? -1 : (l2 == l1 ? 0 : 1);
        }
    };
    private Comparator<JobHistoryParser.TaskAttemptInfo> cFinishShuffle = new Comparator<JobHistoryParser.TaskAttemptInfo>(){

        @Override
        public int compare(JobHistoryParser.TaskAttemptInfo t1, JobHistoryParser.TaskAttemptInfo t2) {
            long l1 = t1.getShuffleFinishTime();
            long l2 = t2.getShuffleFinishTime();
            return l2 < l1 ? -1 : (l2 == l1 ? 0 : 1);
        }
    };
    private Comparator<JobHistoryParser.TaskAttemptInfo> cFinishMapRed = new Comparator<JobHistoryParser.TaskAttemptInfo>(){

        @Override
        public int compare(JobHistoryParser.TaskAttemptInfo t1, JobHistoryParser.TaskAttemptInfo t2) {
            long l1 = t1.getFinishTime();
            long l2 = t2.getFinishTime();
            return l2 < l1 ? -1 : (l2 == l1 ? 0 : 1);
        }
    };
    private Comparator<JobHistoryParser.TaskAttemptInfo> cReduce = new Comparator<JobHistoryParser.TaskAttemptInfo>(){

        @Override
        public int compare(JobHistoryParser.TaskAttemptInfo t1, JobHistoryParser.TaskAttemptInfo t2) {
            long l1 = t1.getFinishTime() - t1.getShuffleFinishTime();
            long l2 = t2.getFinishTime() - t2.getShuffleFinishTime();
            return l2 < l1 ? -1 : (l2 == l1 ? 0 : 1);
        }
    };

    public HistoryViewer(String historyFile, Configuration conf, boolean printAll) throws IOException {
        this.printAll = printAll;
        String errorMsg = "Unable to initialize History Viewer";
        try {
            Path jobFile = new Path(historyFile);
            this.fs = jobFile.getFileSystem(conf);
            String[] jobDetails = jobFile.getName().split("_");
            if (jobDetails.length < 2) {
                System.err.println("Ignore unrecognized file: " + jobFile.getName());
                throw new IOException(errorMsg);
            }
            JobHistoryParser parser = new JobHistoryParser(this.fs, jobFile);
            this.job = parser.parse();
            this.jobId = this.job.getJobId().toString();
        }
        catch (Exception e) {
            throw new IOException(errorMsg, e);
        }
    }

    public void print() throws IOException {
        this.printJobDetails();
        this.printTaskSummary();
        this.printJobAnalysis();
        this.printTasks(TaskType.JOB_SETUP, TaskStatus.State.FAILED.toString());
        this.printTasks(TaskType.JOB_SETUP, TaskStatus.State.KILLED.toString());
        this.printTasks(TaskType.MAP, TaskStatus.State.FAILED.toString());
        this.printTasks(TaskType.MAP, TaskStatus.State.KILLED.toString());
        this.printTasks(TaskType.REDUCE, TaskStatus.State.FAILED.toString());
        this.printTasks(TaskType.REDUCE, TaskStatus.State.KILLED.toString());
        this.printTasks(TaskType.JOB_CLEANUP, TaskStatus.State.FAILED.toString());
        this.printTasks(TaskType.JOB_CLEANUP, JobStatus.getJobRunState(JobStatus.KILLED));
        if (this.printAll) {
            this.printTasks(TaskType.JOB_SETUP, TaskStatus.State.SUCCEEDED.toString());
            this.printTasks(TaskType.MAP, TaskStatus.State.SUCCEEDED.toString());
            this.printTasks(TaskType.REDUCE, TaskStatus.State.SUCCEEDED.toString());
            this.printTasks(TaskType.JOB_CLEANUP, TaskStatus.State.SUCCEEDED.toString());
            this.printAllTaskAttempts(TaskType.JOB_SETUP);
            this.printAllTaskAttempts(TaskType.MAP);
            this.printAllTaskAttempts(TaskType.REDUCE);
            this.printAllTaskAttempts(TaskType.JOB_CLEANUP);
        }
        FilteredJob filter2 = new FilteredJob(this.job, TaskStatus.State.FAILED.toString());
        this.printFailedAttempts(filter2);
        filter2 = new FilteredJob(this.job, TaskStatus.State.KILLED.toString());
        this.printFailedAttempts(filter2);
    }

    private void printJobDetails() {
        StringBuffer jobDetails = new StringBuffer();
        jobDetails.append("\nHadoop job: ").append(this.job.getJobId());
        jobDetails.append("\n=====================================");
        jobDetails.append("\nUser: ").append(this.job.getUsername());
        jobDetails.append("\nJobName: ").append(this.job.getJobname());
        jobDetails.append("\nJobConf: ").append(this.job.getJobConfPath());
        jobDetails.append("\nSubmitted At: ").append(StringUtils.getFormattedTimeWithDiff(dateFormat, this.job.getSubmitTime(), 0L));
        jobDetails.append("\nLaunched At: ").append(StringUtils.getFormattedTimeWithDiff(dateFormat, this.job.getLaunchTime(), this.job.getSubmitTime()));
        jobDetails.append("\nFinished At: ").append(StringUtils.getFormattedTimeWithDiff(dateFormat, this.job.getFinishTime(), this.job.getLaunchTime()));
        jobDetails.append("\nStatus: ").append(this.job.getJobStatus() == null ? "Incomplete" : this.job.getJobStatus());
        this.printCounters(jobDetails, this.job.getTotalCounters(), this.job.getMapCounters(), this.job.getReduceCounters());
        jobDetails.append("\n");
        jobDetails.append("\n=====================================");
        System.out.println(jobDetails.toString());
    }

    private void printCounters(StringBuffer buff, Counters totalCounters, Counters mapCounters, Counters reduceCounters) {
        if (totalCounters == null) {
            return;
        }
        buff.append("\nCounters: \n\n");
        buff.append(String.format("|%1$-30s|%2$-30s|%3$-10s|%4$-10s|%5$-10s|", "Group Name", "Counter name", "Map Value", "Reduce Value", "Total Value"));
        buff.append("\n---------------------------------------------------------------------------------------");
        for (String groupName : totalCounters.getGroupNames()) {
            CounterGroup totalGroup = (CounterGroup)totalCounters.getGroup(groupName);
            CounterGroup mapGroup = (CounterGroup)mapCounters.getGroup(groupName);
            CounterGroup reduceGroup = (CounterGroup)reduceCounters.getGroup(groupName);
            DecimalFormat decimal = new DecimalFormat();
            for (Counter counter : totalGroup) {
                String name = counter.getName();
                String mapValue = decimal.format((Object)mapGroup.findCounter(name).getValue());
                String reduceValue = decimal.format((Object)reduceGroup.findCounter(name).getValue());
                String totalValue = decimal.format((Object)counter.getValue());
                buff.append(String.format("%n|%1$-30s|%2$-30s|%3$-10s|%4$-10s|%5$-10s", totalGroup.getDisplayName(), counter.getDisplayName(), mapValue, reduceValue, totalValue));
            }
        }
    }

    private void printAllTaskAttempts(TaskType taskType) {
        Map<TaskID, JobHistoryParser.TaskInfo> tasks = this.job.getAllTasks();
        StringBuffer taskList = new StringBuffer();
        taskList.append("\n").append((Object)taskType);
        taskList.append(" task list for ").append(this.job.getJobId());
        taskList.append("\nTaskId\t\tStartTime");
        if (TaskType.REDUCE.equals((Object)taskType)) {
            taskList.append("\tShuffleFinished\tSortFinished");
        }
        taskList.append("\tFinishTime\tHostName\tError\tTaskLogs");
        taskList.append("\n====================================================");
        System.out.println(taskList.toString());
        for (JobHistoryParser.TaskInfo task : tasks.values()) {
            for (JobHistoryParser.TaskAttemptInfo attempt : task.getAllTaskAttempts().values()) {
                if (!taskType.equals((Object)task.getTaskType())) continue;
                taskList.setLength(0);
                taskList.append(attempt.getAttemptId()).append("\t");
                taskList.append(StringUtils.getFormattedTimeWithDiff(dateFormat, attempt.getStartTime(), 0L)).append("\t");
                if (TaskType.REDUCE.equals((Object)taskType)) {
                    taskList.append(StringUtils.getFormattedTimeWithDiff(dateFormat, attempt.getShuffleFinishTime(), attempt.getStartTime()));
                    taskList.append("\t");
                    taskList.append(StringUtils.getFormattedTimeWithDiff(dateFormat, attempt.getSortFinishTime(), attempt.getShuffleFinishTime()));
                }
                taskList.append(StringUtils.getFormattedTimeWithDiff(dateFormat, attempt.getFinishTime(), attempt.getStartTime()));
                taskList.append("\t");
                taskList.append(attempt.getHostname()).append("\t");
                taskList.append(attempt.getError());
                String taskLogsUrl = HistoryViewer.getTaskLogsUrl(attempt);
                taskList.append(taskLogsUrl != null ? taskLogsUrl : "n/a");
                System.out.println(taskList.toString());
            }
        }
    }

    private void printTaskSummary() {
        SummarizedJob ts = new SummarizedJob(this.job);
        StringBuffer taskSummary = new StringBuffer();
        taskSummary.append("\nTask Summary");
        taskSummary.append("\n============================");
        taskSummary.append("\nKind\tTotal\t");
        taskSummary.append("Successful\tFailed\tKilled\tStartTime\tFinishTime");
        taskSummary.append("\n");
        taskSummary.append("\nSetup\t").append(ts.totalSetups);
        taskSummary.append("\t").append(ts.numFinishedSetups);
        taskSummary.append("\t\t").append(ts.numFailedSetups);
        taskSummary.append("\t").append(ts.numKilledSetups);
        taskSummary.append("\t").append(StringUtils.getFormattedTimeWithDiff(dateFormat, ts.setupStarted, 0L));
        taskSummary.append("\t").append(StringUtils.getFormattedTimeWithDiff(dateFormat, ts.setupFinished, ts.setupStarted));
        taskSummary.append("\nMap\t").append(ts.totalMaps);
        taskSummary.append("\t").append(this.job.getFinishedMaps());
        taskSummary.append("\t\t").append(ts.numFailedMaps);
        taskSummary.append("\t").append(ts.numKilledMaps);
        taskSummary.append("\t").append(StringUtils.getFormattedTimeWithDiff(dateFormat, ts.mapStarted, 0L));
        taskSummary.append("\t").append(StringUtils.getFormattedTimeWithDiff(dateFormat, ts.mapFinished, ts.mapStarted));
        taskSummary.append("\nReduce\t").append(ts.totalReduces);
        taskSummary.append("\t").append(this.job.getFinishedReduces());
        taskSummary.append("\t\t").append(ts.numFailedReduces);
        taskSummary.append("\t").append(ts.numKilledReduces);
        taskSummary.append("\t").append(StringUtils.getFormattedTimeWithDiff(dateFormat, ts.reduceStarted, 0L));
        taskSummary.append("\t").append(StringUtils.getFormattedTimeWithDiff(dateFormat, ts.reduceFinished, ts.reduceStarted));
        taskSummary.append("\nCleanup\t").append(ts.totalCleanups);
        taskSummary.append("\t").append(ts.numFinishedCleanups);
        taskSummary.append("\t\t").append(ts.numFailedCleanups);
        taskSummary.append("\t").append(ts.numKilledCleanups);
        taskSummary.append("\t").append(StringUtils.getFormattedTimeWithDiff(dateFormat, ts.cleanupStarted, 0L));
        taskSummary.append("\t").append(StringUtils.getFormattedTimeWithDiff(dateFormat, ts.cleanupFinished, ts.cleanupStarted));
        taskSummary.append("\n============================\n");
        System.out.println(taskSummary.toString());
    }

    private void printJobAnalysis() {
        if (!this.job.getJobStatus().equals(JobStatus.getJobRunState(JobStatus.SUCCEEDED))) {
            System.out.println("No Analysis available as job did not finish");
            return;
        }
        AnalyzedJob avg = new AnalyzedJob(this.job);
        System.out.println("\nAnalysis");
        System.out.println("=========");
        this.printAnalysis(avg.getMapTasks(), this.cMap, "map", avg.getAvgMapTime(), 10);
        this.printLast(avg.getMapTasks(), "map", this.cFinishMapRed);
        if (avg.getReduceTasks().length > 0) {
            this.printAnalysis(avg.getReduceTasks(), this.cShuffle, "shuffle", avg.getAvgShuffleTime(), 10);
            this.printLast(avg.getReduceTasks(), "shuffle", this.cFinishShuffle);
            this.printAnalysis(avg.getReduceTasks(), this.cReduce, "reduce", avg.getAvgReduceTime(), 10);
            this.printLast(avg.getReduceTasks(), "reduce", this.cFinishMapRed);
        }
        System.out.println("=========");
    }

    private void printAnalysis(JobHistoryParser.TaskAttemptInfo[] tasks, Comparator<JobHistoryParser.TaskAttemptInfo> cmp, String taskType, long avg, int showTasks) {
        Arrays.sort(tasks, cmp);
        JobHistoryParser.TaskAttemptInfo min2 = tasks[tasks.length - 1];
        StringBuffer details = new StringBuffer();
        details.append("\nTime taken by best performing ");
        details.append(taskType).append(" task ");
        details.append(min2.getAttemptId().getTaskID().toString()).append(": ");
        if ("map".equals(taskType)) {
            details.append(StringUtils.formatTimeDiff(min2.getFinishTime(), min2.getStartTime()));
        } else if ("shuffle".equals(taskType)) {
            details.append(StringUtils.formatTimeDiff(min2.getShuffleFinishTime(), min2.getStartTime()));
        } else {
            details.append(StringUtils.formatTimeDiff(min2.getFinishTime(), min2.getShuffleFinishTime()));
        }
        details.append("\nAverage time taken by ");
        details.append(taskType).append(" tasks: ");
        details.append(StringUtils.formatTimeDiff(avg, 0L));
        details.append("\nWorse performing ");
        details.append(taskType).append(" tasks: ");
        details.append("\nTaskId\t\tTimetaken");
        System.out.println(details.toString());
        for (int i = 0; i < showTasks && i < tasks.length; ++i) {
            details.setLength(0);
            details.append(tasks[i].getAttemptId().getTaskID()).append(" ");
            if ("map".equals(taskType)) {
                details.append(StringUtils.formatTimeDiff(tasks[i].getFinishTime(), tasks[i].getStartTime()));
            } else if ("shuffle".equals(taskType)) {
                details.append(StringUtils.formatTimeDiff(tasks[i].getShuffleFinishTime(), tasks[i].getStartTime()));
            } else {
                details.append(StringUtils.formatTimeDiff(tasks[i].getFinishTime(), tasks[i].getShuffleFinishTime()));
            }
            System.out.println(details.toString());
        }
    }

    private void printLast(JobHistoryParser.TaskAttemptInfo[] tasks, String taskType, Comparator<JobHistoryParser.TaskAttemptInfo> cmp) {
        Arrays.sort(tasks, this.cFinishMapRed);
        JobHistoryParser.TaskAttemptInfo last2 = tasks[0];
        StringBuffer lastBuf = new StringBuffer();
        lastBuf.append("The last ").append(taskType);
        lastBuf.append(" task ").append(last2.getAttemptId().getTaskID());
        Long finishTime = "shuffle".equals(taskType) ? Long.valueOf(last2.getShuffleFinishTime()) : Long.valueOf(last2.getFinishTime());
        lastBuf.append(" finished at (relative to the Job launch time): ");
        lastBuf.append(StringUtils.getFormattedTimeWithDiff(dateFormat, finishTime, this.job.getLaunchTime()));
        System.out.println(lastBuf.toString());
    }

    private void printTasks(TaskType taskType, String status) {
        Map<TaskID, JobHistoryParser.TaskInfo> tasks = this.job.getAllTasks();
        StringBuffer header = new StringBuffer();
        header.append("\n").append(status).append(" ");
        header.append((Object)taskType).append(" task list for ").append(this.jobId);
        header.append("\nTaskId\t\tStartTime\tFinishTime\tError");
        if (TaskType.MAP.equals((Object)taskType)) {
            header.append("\tInputSplits");
        }
        header.append("\n====================================================");
        StringBuffer taskList = new StringBuffer();
        for (JobHistoryParser.TaskInfo task : tasks.values()) {
            if (!taskType.equals((Object)task.getTaskType()) || !status.equals(task.getTaskStatus()) && !status.equalsIgnoreCase("ALL")) continue;
            taskList.setLength(0);
            taskList.append(task.getTaskId());
            taskList.append("\t").append(StringUtils.getFormattedTimeWithDiff(dateFormat, task.getStartTime(), 0L));
            taskList.append("\t").append(StringUtils.getFormattedTimeWithDiff(dateFormat, task.getFinishTime(), task.getStartTime()));
            taskList.append("\t").append(task.getError());
            if (TaskType.MAP.equals((Object)taskType)) {
                taskList.append("\t").append(task.getSplitLocations());
            }
            if (taskList == null) continue;
            System.out.println(header.toString());
            System.out.println(taskList.toString());
        }
    }

    private void printFailedAttempts(FilteredJob filteredJob) {
        Map<String, Set<TaskID>> badNodes = filteredJob.getFilteredMap();
        StringBuffer attempts = new StringBuffer();
        if (badNodes.size() > 0) {
            attempts.append("\n").append(filteredJob.getFilter());
            attempts.append(" task attempts by nodes");
            attempts.append("\nHostname\tFailedTasks");
            attempts.append("\n===============================");
            System.out.println(attempts.toString());
            for (Map.Entry<String, Set<TaskID>> entry2 : badNodes.entrySet()) {
                String node = entry2.getKey();
                Set<TaskID> failedTasks = entry2.getValue();
                attempts.setLength(0);
                attempts.append(node).append("\t");
                for (TaskID t : failedTasks) {
                    attempts.append(t).append(", ");
                }
                System.out.println(attempts.toString());
            }
        }
    }

    public static String getTaskLogsUrl(JobHistoryParser.TaskAttemptInfo attempt) {
        if (attempt.getHttpPort() == -1 || attempt.getTrackerName().equals("") || attempt.getAttemptId() == null) {
            return null;
        }
        String taskTrackerName = HostUtil.convertTrackerNameToHostName(attempt.getTrackerName());
        return HostUtil.getTaskLogUrl(taskTrackerName, Integer.toString(attempt.getHttpPort()), attempt.getAttemptId().toString());
    }

    public static class FilteredJob {
        private Map<String, Set<TaskID>> badNodesToFilteredTasks = new HashMap<String, Set<TaskID>>();
        private String filter;

        public Map<String, Set<TaskID>> getFilteredMap() {
            return this.badNodesToFilteredTasks;
        }

        public String getFilter() {
            return this.filter;
        }

        public FilteredJob(JobHistoryParser.JobInfo job, String status) {
            this.filter = status;
            Map<TaskID, JobHistoryParser.TaskInfo> tasks = job.getAllTasks();
            for (JobHistoryParser.TaskInfo task : tasks.values()) {
                Map<TaskAttemptID, JobHistoryParser.TaskAttemptInfo> attempts = task.getAllTaskAttempts();
                for (JobHistoryParser.TaskAttemptInfo attempt : attempts.values()) {
                    if (!attempt.getTaskStatus().equals(status)) continue;
                    String hostname = attempt.getHostname();
                    TaskID id = attempt.getAttemptId().getTaskID();
                    Set<TaskID> set = this.badNodesToFilteredTasks.get(hostname);
                    if (set == null) {
                        set = new TreeSet<TaskID>();
                        set.add(id);
                        this.badNodesToFilteredTasks.put(hostname, set);
                        continue;
                    }
                    set.add(id);
                }
            }
        }
    }

    public static class AnalyzedJob {
        private long avgMapTime;
        private long avgReduceTime;
        private long avgShuffleTime;
        private JobHistoryParser.TaskAttemptInfo[] mapTasks;
        private JobHistoryParser.TaskAttemptInfo[] reduceTasks;

        public long getAvgMapTime() {
            return this.avgMapTime;
        }

        public long getAvgReduceTime() {
            return this.avgReduceTime;
        }

        public long getAvgShuffleTime() {
            return this.avgShuffleTime;
        }

        public JobHistoryParser.TaskAttemptInfo[] getMapTasks() {
            return this.mapTasks;
        }

        public JobHistoryParser.TaskAttemptInfo[] getReduceTasks() {
            return this.reduceTasks;
        }

        public AnalyzedJob(JobHistoryParser.JobInfo job) {
            Map<TaskID, JobHistoryParser.TaskInfo> tasks = job.getAllTasks();
            int finishedMaps = (int)job.getFinishedMaps();
            int finishedReduces = (int)job.getFinishedReduces();
            this.mapTasks = new JobHistoryParser.TaskAttemptInfo[finishedMaps];
            this.reduceTasks = new JobHistoryParser.TaskAttemptInfo[finishedReduces];
            int mapIndex = 0;
            int reduceIndex = 0;
            this.avgMapTime = 0L;
            this.avgReduceTime = 0L;
            this.avgShuffleTime = 0L;
            block0: for (JobHistoryParser.TaskInfo task : tasks.values()) {
                Map<TaskAttemptID, JobHistoryParser.TaskAttemptInfo> attempts = task.getAllTaskAttempts();
                for (JobHistoryParser.TaskAttemptInfo attempt : attempts.values()) {
                    if (!attempt.getTaskStatus().equals(TaskStatus.State.SUCCEEDED.toString())) continue;
                    long avgFinishTime = attempt.getFinishTime() - attempt.getStartTime();
                    if (attempt.getTaskType().equals((Object)TaskType.MAP)) {
                        this.mapTasks[mapIndex++] = attempt;
                        this.avgMapTime += avgFinishTime;
                        continue block0;
                    }
                    if (!attempt.getTaskType().equals((Object)TaskType.REDUCE)) continue block0;
                    this.reduceTasks[reduceIndex++] = attempt;
                    this.avgShuffleTime += attempt.getShuffleFinishTime() - attempt.getStartTime();
                    this.avgReduceTime += attempt.getFinishTime() - attempt.getShuffleFinishTime();
                    continue block0;
                }
            }
            if (finishedMaps > 0) {
                this.avgMapTime /= (long)finishedMaps;
            }
            if (finishedReduces > 0) {
                this.avgReduceTime /= (long)finishedReduces;
                this.avgShuffleTime /= (long)finishedReduces;
            }
        }
    }

    public static class SummarizedJob {
        Map<TaskID, JobHistoryParser.TaskInfo> tasks;
        int totalMaps = 0;
        int totalReduces = 0;
        int totalCleanups = 0;
        int totalSetups = 0;
        int numFailedMaps = 0;
        int numKilledMaps = 0;
        int numFailedReduces = 0;
        int numKilledReduces = 0;
        int numFinishedCleanups = 0;
        int numFailedCleanups = 0;
        int numKilledCleanups = 0;
        int numFinishedSetups = 0;
        int numFailedSetups = 0;
        int numKilledSetups = 0;
        long mapStarted = 0L;
        long mapFinished = 0L;
        long reduceStarted = 0L;
        long reduceFinished = 0L;
        long cleanupStarted = 0L;
        long cleanupFinished = 0L;
        long setupStarted = 0L;
        long setupFinished = 0L;

        public int getTotalMaps() {
            return this.totalMaps;
        }

        public int getTotalReduces() {
            return this.totalReduces;
        }

        public int getTotalCleanups() {
            return this.totalCleanups;
        }

        public int getTotalSetups() {
            return this.totalSetups;
        }

        public int getNumFailedMaps() {
            return this.numFailedMaps;
        }

        public int getNumKilledMaps() {
            return this.numKilledMaps;
        }

        public int getNumFailedReduces() {
            return this.numFailedReduces;
        }

        public int getNumKilledReduces() {
            return this.numKilledReduces;
        }

        public int getNumFinishedCleanups() {
            return this.numFinishedCleanups;
        }

        public int getNumFailedCleanups() {
            return this.numFailedCleanups;
        }

        public int getNumKilledCleanups() {
            return this.numKilledCleanups;
        }

        public int getNumFinishedSetups() {
            return this.numFinishedSetups;
        }

        public int getNumFailedSetups() {
            return this.numFailedSetups;
        }

        public int getNumKilledSetups() {
            return this.numKilledSetups;
        }

        public long getMapStarted() {
            return this.mapStarted;
        }

        public long getMapFinished() {
            return this.mapFinished;
        }

        public long getReduceStarted() {
            return this.reduceStarted;
        }

        public long getReduceFinished() {
            return this.reduceFinished;
        }

        public long getCleanupStarted() {
            return this.cleanupStarted;
        }

        public long getCleanupFinished() {
            return this.cleanupFinished;
        }

        public long getSetupStarted() {
            return this.setupStarted;
        }

        public long getSetupFinished() {
            return this.setupFinished;
        }

        public SummarizedJob(JobHistoryParser.JobInfo job) {
            this.tasks = job.getAllTasks();
            for (JobHistoryParser.TaskInfo task : this.tasks.values()) {
                Map<TaskAttemptID, JobHistoryParser.TaskAttemptInfo> attempts = task.getAllTaskAttempts();
                for (JobHistoryParser.TaskAttemptInfo attempt : attempts.values()) {
                    long startTime = attempt.getStartTime();
                    long finishTime = attempt.getFinishTime();
                    if (attempt.getTaskType().equals((Object)TaskType.MAP)) {
                        if (this.mapStarted == 0L || this.mapStarted > startTime) {
                            this.mapStarted = startTime;
                        }
                        if (this.mapFinished < finishTime) {
                            this.mapFinished = finishTime;
                        }
                        ++this.totalMaps;
                        if (attempt.getTaskStatus().equals(TaskStatus.State.FAILED.toString())) {
                            ++this.numFailedMaps;
                            continue;
                        }
                        if (!attempt.getTaskStatus().equals(TaskStatus.State.KILLED.toString())) continue;
                        ++this.numKilledMaps;
                        continue;
                    }
                    if (attempt.getTaskType().equals((Object)TaskType.REDUCE)) {
                        if (this.reduceStarted == 0L || this.reduceStarted > startTime) {
                            this.reduceStarted = startTime;
                        }
                        if (this.reduceFinished < finishTime) {
                            this.reduceFinished = finishTime;
                        }
                        ++this.totalReduces;
                        if (attempt.getTaskStatus().equals(TaskStatus.State.FAILED.toString())) {
                            ++this.numFailedReduces;
                            continue;
                        }
                        if (!attempt.getTaskStatus().equals(TaskStatus.State.KILLED.toString())) continue;
                        ++this.numKilledReduces;
                        continue;
                    }
                    if (attempt.getTaskType().equals((Object)TaskType.JOB_CLEANUP)) {
                        if (this.cleanupStarted == 0L || this.cleanupStarted > startTime) {
                            this.cleanupStarted = startTime;
                        }
                        if (this.cleanupFinished < finishTime) {
                            this.cleanupFinished = finishTime;
                        }
                        ++this.totalCleanups;
                        if (attempt.getTaskStatus().equals(TaskStatus.State.SUCCEEDED.toString())) {
                            ++this.numFinishedCleanups;
                            continue;
                        }
                        if (attempt.getTaskStatus().equals(TaskStatus.State.FAILED.toString())) {
                            ++this.numFailedCleanups;
                            continue;
                        }
                        if (!attempt.getTaskStatus().equals(TaskStatus.State.KILLED.toString())) continue;
                        ++this.numKilledCleanups;
                        continue;
                    }
                    if (!attempt.getTaskType().equals((Object)TaskType.JOB_SETUP)) continue;
                    if (this.setupStarted == 0L || this.setupStarted > startTime) {
                        this.setupStarted = startTime;
                    }
                    if (this.setupFinished < finishTime) {
                        this.setupFinished = finishTime;
                    }
                    ++this.totalSetups;
                    if (attempt.getTaskStatus().equals(TaskStatus.State.SUCCEEDED.toString())) {
                        ++this.numFinishedSetups;
                        continue;
                    }
                    if (attempt.getTaskStatus().equals(TaskStatus.State.FAILED.toString())) {
                        ++this.numFailedSetups;
                        continue;
                    }
                    if (!attempt.getTaskStatus().equals(TaskStatus.State.KILLED.toString())) continue;
                    ++this.numKilledSetups;
                }
            }
        }
    }
}

